/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Alert;
import btworks.jsse.provider.AlertException;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.ContentType;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.RecordingInputStream;
import btworks.jsse.provider.Session;
import btworks.jsse.provider.Trace;
import btworks.jsse.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLProtocolException;

class RecordInput {
    private static final boolean DEBUG_RECORD_LAYER = BtworksJSSE.DEBUG_RecordInput_record;
    private byte[] fragment;
    private int fragLen;
    private int index;
    private ContentType type;
    private final DataInputStream in;
    private Session session;
    static final boolean dev = BtworksJSSE.DEBUG_RecordInput;

    RecordInput(InputStream in, Session session) {
        this.in = new DataInputStream(in);
        this.session = session;
    }

    synchronized int available(ContentType type) throws IOException {
        if (this.fragment == null) {
            this.readRecord();
        }
        if (type != this.type) {
            return 0;
        }
        return this.fragLen - this.index;
    }

    void setSession(Session session) {
        this.session = session;
    }

    synchronized int read(byte[] buf, int off, int len, ContentType type) throws IOException {
        if (dev) {
            Trace.a("RecordInput.read()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("RecordInput.read()", "read start...[off:" + off + "][len:" + len + "]");
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException("size=" + buf.length + " off=" + off + " len=" + len);
        }
        int reqReadLen = len;
        if (dev) {
            Trace.a("RecordInput.read()", "[1st fragLen:" + this.fragLen + "][len:" + len + "][index:" + this.index + "]");
        }
        if (this.fragment == null || this.index >= this.fragLen) {
            this.readRecord();
        }
        if (type != this.type) {
            return 0;
        }
        if (dev) {
            Trace.a("RecordInput.read()", "[2nd fragLen:" + this.fragLen + "][len:" + len + "][index:" + this.index + "]");
        }
        len = Math.min(len, this.fragLen - this.index);
        if (dev) {
            Trace.a("RecordInput.read()", "len2: " + len);
        }
        System.arraycopy(this.fragment, this.index, buf, off, len);
        this.index += len;
        if (dev) {
            Trace.a("RecordInput.read()", "requested read len:" + reqReadLen + "  final read len:" + len);
        }
        return len;
    }

    boolean pollClose() throws IOException {
        if (this.fragment == null || this.index >= this.fragLen) {
            try {
                this.readRecord();
            }
            catch (AlertException ae) {
                Alert alert = ae.getAlert();
                if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                    return true;
                }
                throw ae;
            }
        }
        return false;
    }

    private void readRecord() throws IOException {
        if (dev) {
            Trace.a("RecordInput.readRecord()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("recInRecordInput()", "\n >>>>>>>>>>>>> readRecord start..");
        }
        this.type = ContentType.read(this.in);
        if (dev) {
            Trace.a("RecordInput.readRecord()", "read 1st Byte : " + this.type);
        }
        if ((this.type.getValue() & 0x80) != 0 || (this.type.getValue() & 0x40) != 0) {
            this.in.read();
            if ((this.type.getValue() & 0x40) != 0) {
                this.in.read();
            }
            this.type = ContentType.read(this.in);
            if (this.type != ContentType.CLIENT_HELLO_V2) {
                throw new SSLProtocolException("unsupported V2 message");
            }
            this.type = ContentType.HANDSHAKE;
            ByteArrayOutputStream buffer2 = new ByteArrayOutputStream(256);
            buffer2.write(1);
            RecordingInputStream in2 = new RecordingInputStream(this.in, buffer2);
            ProtocolVersion version = ProtocolVersion.read(in2);
            if (version.compareTo(ProtocolVersion.SSL_3) < 0) {
                throw new SSLProtocolException("unsupported client version");
            }
            int len = (in2.read() & 0xFF) << 8 | in2.read() & 0xFF;
            len += (in2.read() & 0xFF) << 8 | in2.read() & 0xFF;
            len += (in2.read() & 0xFF) << 8 | in2.read() & 0xFF;
            int count = 0;
            while (count < len) {
                int l = (int)in2.skip(len - count);
                if (l <= 0) continue;
                count += l;
            }
            this.fragment = buffer2.toByteArray();
            this.index = 0;
            return;
        }
        ProtocolVersion v = ProtocolVersion.read(this.in);
        int len = this.in.readUnsignedShort();
        this.fragment = new byte[len];
        this.in.readFully(this.fragment);
        if (dev) {
            Trace.a("RecordInput.readRecord()", "read fragment.. ok : " + len);
        }
        if (DEBUG_RECORD_LAYER) {
            Trace.a("RecordInput.readRecord()", ">> READ RECORD <<");
            Trace.a("RecordInput.readRecord()", "  type = " + this.type + ";");
            Trace.a("RecordInput.readRecord()", "  version = " + v + ";");
            Trace.a("RecordInput.readRecord()", "  length = " + len + ";");
            Trace.a("RecordInput.readRecord()", Util.hexDump(this.fragment, "  "));
            Trace.a("RecordInput.readRecord()", ") TLSCiphertext;");
        }
        this.fragment = this.session.params.decrypt(this.fragment, v, this.type);
        this.fragLen = this.fragment.length;
        if (dev) {
            Trace.a("RecordInput.readRecord()", "fragLen: " + this.fragLen);
        }
        this.index = 0;
        if (dev) {
            Trace.a("RecordInput.readRecord()", "type " + this.type);
        }
        if (dev) {
            Trace.a("RecordInput.readRecord()", "fragment2\n" + Util.hexDump(this.fragment));
        }
        if (this.type == ContentType.ALERT) {
            Alert alert;
            this.session.currentAlert = alert = Alert.read(new ByteArrayInputStream(this.fragment));
        }
        if (this.session.currentAlert != null) {
            if (dev) {
                Trace.a("RecordInput.readRecord()", "throw alert !!");
            }
            throw new AlertException(this.session.currentAlert, false);
        }
    }
}

