/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

class Random
implements Constructed {
    private final int gmtUnixTime;
    private final byte[] randomBytes;

    Random(int gmtUnixTime, byte[] randomBytes) {
        this.gmtUnixTime = gmtUnixTime;
        this.randomBytes = (byte[])randomBytes.clone();
    }

    static Random read(InputStream in) throws IOException {
        int time = (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        byte[] buf = new byte[28];
        in.read(buf);
        return new Random(time, buf);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.gmtUnixTime >>> 24 & 0xFF);
        out.write(this.gmtUnixTime >>> 16 & 0xFF);
        out.write(this.gmtUnixTime >>> 8 & 0xFF);
        out.write(this.gmtUnixTime & 0xFF);
        out.write(this.randomBytes);
    }

    byte[] getEncoded() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(32);
        try {
            this.write(bout);
        }
        catch (IOException cantHappen) {
            throw new Error(cantHappen.toString());
        }
        return bout.toByteArray();
    }

    int getTime() {
        return this.gmtUnixTime;
    }

    byte[] getRandomBytes() {
        return this.randomBytes;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  gmt_unix_time = " + this.gmtUnixTime + ";");
        out.println("  random_bytes = " + Util.toHexString(this.randomBytes, ':') + ";");
        out.println("} Random;");
        return str.toString();
    }
}

