/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.BitString;
import btworks.jsse.provider.DERReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class RSAPublicKeyImpl
implements RSAPublicKey {
    private PublicKey pubkey;
    private byte[] encoded = null;
    private BigInteger n = null;
    private BigInteger e = null;

    public RSAPublicKeyImpl(PublicKey pubkey) {
        this.pubkey = pubkey;
    }

    private void decode() {
        try {
            byte[] encoded = this.getEncoded();
            DERReader der = new DERReader(new ByteArrayInputStream(encoded));
            der.read();
            der.read();
            der.read();
            der.read();
            BitString bs = (BitString)der.read().getValue();
            byte[] p1pubkey = bs.toByteArray();
            DERReader der2 = new DERReader(new ByteArrayInputStream(p1pubkey));
            der2.read();
            BigInteger n = (BigInteger)der2.read().getValue();
            BigInteger e = (BigInteger)der2.read().getValue();
            this.n = n;
            this.e = e;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public BigInteger getModulus() {
        if (this.n == null) {
            this.decode();
        }
        return this.n;
    }

    public BigInteger getPublicExponent() {
        if (this.e == null) {
            this.decode();
        }
        return this.e;
    }

    public String getAlgorithm() {
        return this.pubkey.getAlgorithm();
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = this.pubkey.getEncoded();
        }
        return this.encoded;
    }

    public String getFormat() {
        return this.pubkey.getFormat();
    }
}

