/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.DERReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class RSAPrivateKeyImpl
implements RSAPrivateKey,
RSAPrivateCrtKey {
    private PrivateKey prvkey;
    private byte[] encoded = null;
    private BigInteger n = null;
    private BigInteger e = null;
    private BigInteger d = null;
    private BigInteger p = null;
    private BigInteger q = null;
    private BigInteger dp = null;
    private BigInteger dq = null;
    private BigInteger ce = null;

    public RSAPrivateKeyImpl(PrivateKey prvkey) {
        this.prvkey = prvkey;
    }

    private void decode() {
        try {
            byte[] encoded = this.getEncoded();
            DERReader der = new DERReader(new ByteArrayInputStream(encoded));
            der.read();
            der.read();
            der.read();
            der.read();
            der.read();
            byte[] p1prvkey = (byte[])der.read().getValue();
            DERReader der2 = new DERReader(new ByteArrayInputStream(p1prvkey));
            der2.read();
            der2.read();
            BigInteger n = (BigInteger)der2.read().getValue();
            BigInteger e = (BigInteger)der2.read().getValue();
            BigInteger d = (BigInteger)der2.read().getValue();
            BigInteger p = (BigInteger)der2.read().getValue();
            BigInteger q = (BigInteger)der2.read().getValue();
            BigInteger dp = (BigInteger)der2.read().getValue();
            BigInteger dq = (BigInteger)der2.read().getValue();
            BigInteger ce = (BigInteger)der2.read().getValue();
            this.n = n;
            this.e = e;
            this.d = d;
            this.p = p;
            this.q = q;
            this.dp = dp;
            this.dq = dq;
            this.ce = ce;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public BigInteger getModulus() {
        if (this.n == null) {
            this.decode();
        }
        return this.n;
    }

    public BigInteger getPublicExponent() {
        if (this.e == null) {
            this.decode();
        }
        return this.e;
    }

    public BigInteger getPrivateExponent() {
        if (this.d == null) {
            this.decode();
        }
        return this.d;
    }

    public BigInteger getPrimeP() {
        if (this.p == null) {
            this.decode();
        }
        return this.p;
    }

    public BigInteger getPrimeQ() {
        if (this.q == null) {
            this.decode();
        }
        return this.q;
    }

    public BigInteger getPrimeExponentP() {
        if (this.dp == null) {
            this.decode();
        }
        return this.dp;
    }

    public BigInteger getPrimeExponentQ() {
        if (this.dq == null) {
            this.decode();
        }
        return this.dq;
    }

    public BigInteger getCrtCoefficient() {
        if (this.ce == null) {
            this.decode();
        }
        return this.ce;
    }

    public String getAlgorithm() {
        return this.prvkey.getAlgorithm();
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            this.encoded = this.prvkey.getEncoded();
        }
        return this.encoded;
    }

    public String getFormat() {
        return this.prvkey.getFormat();
    }
}

