/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Constructed;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class ProtocolVersion
implements Comparable,
Constructed {
    static final ProtocolVersion SSL_3 = new ProtocolVersion(3, 0);
    static final ProtocolVersion TLS_1 = new ProtocolVersion(3, 1);
    static final ProtocolVersion TLS_1_1 = new ProtocolVersion(3, 2);
    private final int major;
    private final int minor;

    private ProtocolVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    static ProtocolVersion read(InputStream in) throws IOException {
        int major = in.read() & 0xFF;
        int minor = in.read() & 0xFF;
        return ProtocolVersion.getInstance(major, minor);
    }

    static ProtocolVersion getInstance(int major, int minor) {
        if (major == 3) {
            switch (minor) {
                case 0: {
                    return SSL_3;
                }
                case 1: {
                    return TLS_1;
                }
                case 2: {
                    return TLS_1_1;
                }
            }
        }
        return new ProtocolVersion(major, minor);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.major);
        out.write(this.minor);
    }

    byte[] getEncoded() {
        return new byte[]{(byte)this.major, (byte)this.minor};
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ProtocolVersion)) {
            return false;
        }
        return ((ProtocolVersion)o).major == this.major && ((ProtocolVersion)o).minor == this.minor;
    }

    public int hashCode() {
        return this.major << 8 | this.minor;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ProtocolVersion)) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.major > ((ProtocolVersion)o).major) {
            return 1;
        }
        if (this.major < ((ProtocolVersion)o).major) {
            return -1;
        }
        if (this.minor > ((ProtocolVersion)o).minor) {
            return 1;
        }
        if (this.minor < ((ProtocolVersion)o).minor) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this == SSL_3) {
            return "SSLv3";
        }
        if (this == TLS_1) {
            return "TLSv1";
        }
        if (this == TLS_1_1) {
            return "TLSv1.1";
        }
        return "Unsupported; major=" + this.major + " minor=" + this.minor;
    }
}

