/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Certificate;
import btworks.jsse.provider.CertificateRequest;
import btworks.jsse.provider.CertificateType;
import btworks.jsse.provider.CertificateVerify;
import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.ClientHello;
import btworks.jsse.provider.ClientKeyExchange;
import btworks.jsse.provider.CompressionMethod;
import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.Enumerated;
import btworks.jsse.provider.Finished;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Random;
import btworks.jsse.provider.ServerHello;
import btworks.jsse.provider.ServerKeyExchange;
import btworks.jsse.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import javax.net.ssl.SSLProtocolException;

final class Handshake
implements Constructed {
    private static final boolean dev = BtworksJSSE.DEBUG_Handshake;
    private static final buffer BUF = new buffer();
    private final Type type;
    private final Body body;

    Handshake(Type type, Body body) {
        this.type = type;
        this.body = body;
    }

    static Handshake read(byte[] buffer2) throws IOException {
        return Handshake.read(new ByteArrayInputStream(buffer2));
    }

    static Handshake read(byte[] buffer2, CipherSuite suite, PublicKey key) throws IOException {
        return Handshake.read(new ByteArrayInputStream(buffer2), suite, key);
    }

    static Handshake read(InputStream in) throws IOException {
        return Handshake.read(in, null, null);
    }

    static Handshake read(InputStream in, CipherSuite suite, PublicKey key) throws IOException {
        return Handshake.read(in, suite, key, null);
    }

    static Handshake read(InputStream in, CertificateType certType) throws IOException {
        return Handshake.read(in, null, null, certType);
    }

    static Handshake read(InputStream in, CipherSuite suite, PublicKey key, CertificateType certType) throws IOException {
        Type type = Type.read(in);
        byte[] lenbuf = new byte[3];
        int readLen = in.read(lenbuf);
        if (dev) {
            System.out.println("[Handshake.read] readLen: " + readLen);
        }
        int len = (lenbuf[0] & 0xFF) << 16 | (lenbuf[1] & 0xFF) << 8 | lenbuf[2] & 0xFF;
        Body body = null;
        int typeInt = type.getValue();
        switch (typeInt) {
            case 0: {
                body = null;
                break;
            }
            case 1: {
                if (lenbuf[0] == 3 && lenbuf[1] >= 0 && lenbuf[1] <= 2) {
                    ProtocolVersion vers = null;
                    switch (lenbuf[1]) {
                        case 0: {
                            vers = ProtocolVersion.SSL_3;
                            break;
                        }
                        case 1: {
                            vers = ProtocolVersion.TLS_1;
                            break;
                        }
                        case 2: {
                            vers = ProtocolVersion.TLS_1_1;
                        }
                    }
                    int specLen = (lenbuf[2] & 0xFF) << 8 | in.read() & 0xFF;
                    int idLen = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
                    int chalLen = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
                    ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>(specLen / 3);
                    int i = 0;
                    while (i < specLen) {
                        if (in.read() == 0) {
                            suites.add(CipherSuite.read(in).resolve(vers));
                        } else {
                            in.read();
                            in.read();
                        }
                        i += 3;
                    }
                    byte[] id = new byte[idLen];
                    in.read(id);
                    byte[] challenge = new byte[chalLen];
                    in.read(challenge);
                    if (challenge.length > 32) {
                        challenge = Util.trim(challenge, 32);
                    } else if (challenge.length < 32) {
                        byte[] b = new byte[32];
                        System.arraycopy(challenge, 0, b, b.length - challenge.length, challenge.length);
                        challenge = b;
                    }
                    int time = (challenge[0] & 0xFF) << 24 | (challenge[1] & 0xFF) << 16 | (challenge[2] & 0xFF) << 8 | challenge[3] & 0xFF;
                    Random rand = new Random(time, Util.trim(challenge, 4, 28));
                    return new Handshake(Type.CLIENT_HELLO, new ClientHello(vers, rand, id, suites, Collections.singletonList(CompressionMethod.NULL)));
                }
                byte[] buf = new byte[len];
                int count = 0;
                while (count < len) {
                    int l = in.read(buf, count, len - count);
                    if (l == -1) {
                        throw new EOFException("unexpected end of input stream");
                    }
                    count += l;
                }
                body = ClientHello.read(new ByteArrayInputStream(buf));
                break;
            }
            case 2: {
                byte[] buf2 = new byte[len];
                int count2 = 0;
                while (count2 < len) {
                    int l = in.read(buf2, count2, len - count2);
                    if (l == -1) {
                        throw new EOFException("unexpected end of input stream");
                    }
                    count2 += l;
                }
                body = ServerHello.read(new ByteArrayInputStream(buf2));
                break;
            }
            case 11: {
                body = Certificate.read(in, certType);
                break;
            }
            case 12: {
                body = ServerKeyExchange.read(in, suite);
                break;
            }
            case 13: {
                body = CertificateRequest.read(in);
                break;
            }
            case 15: {
                body = (CertificateVerify)CertificateVerify.read(in, suite);
                break;
            }
            case 16: {
                body = ClientKeyExchange.read(in, suite, key);
                break;
            }
            case 14: {
                body = null;
                break;
            }
            case 20: {
                body = Finished.read(in, suite);
                break;
            }
            default: {
                throw new SSLProtocolException("unknown HandshakeType: " + type.getValue());
            }
        }
        return new Handshake(type, body);
    }

    public void write(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    public int write(OutputStream out, ProtocolVersion version) throws IOException {
        out.write(this.type.getValue());
        if (this.body == null) {
            out.write(0);
            out.write(0);
            out.write(0);
            return 4;
        }
        ByteArrayOutputStream bout = BUF.getBuffer();
        bout.reset();
        if (this.body instanceof ServerKeyExchange) {
            ((ServerKeyExchange)this.body).write(bout, version);
        } else if (this.body instanceof ClientKeyExchange) {
            ((ClientKeyExchange)this.body).write(bout, version);
        } else if (this.body instanceof CertificateVerify) {
            ((CertificateVerify)this.body).write(bout, version);
        } else {
            this.body.write(bout);
        }
        out.write(bout.size() >>> 16 & 0xFF);
        out.write(bout.size() >>> 8 & 0xFF);
        out.write(bout.size() & 0xFF);
        bout.writeTo(out);
        return 4 + bout.size();
    }

    Type getType() {
        return this.type;
    }

    Body getBody() {
        return this.body;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        out.println("struct {");
        out.println("  type = " + this.type + ";");
        if (this.body != null) {
            BufferedReader r = new BufferedReader(new StringReader(this.body.toString()));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    out.print("  ");
                    out.println(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        out.println("} Handshake;");
        return str.toString();
    }

    static interface Body
    extends Constructed {
    }

    static class Type
    implements Enumerated {
        public static final Type HELLO_REQUEST = new Type(0);
        public static final Type CLIENT_HELLO = new Type(1);
        public static final Type SERVER_HELLO = new Type(2);
        public static final Type CERTIFICATE = new Type(11);
        public static final Type SERVER_KEY_EXCHANGE = new Type(12);
        public static final Type CERTIFICATE_REQUEST = new Type(13);
        public static final Type SERVER_HELLO_DONE = new Type(14);
        public static final Type CERTIFICATE_VERIFY = new Type(15);
        public static final Type CLIENT_KEY_EXCHANGE = new Type(16);
        public static final Type FINISHED = new Type(20);
        public static final Type CERTIFICATE_URL = new Type(21);
        public static final Type CERTIFICATE_STATUS = new Type(22);
        public static final int HELLO_REQUEST_I = 0;
        public static final int CLIENT_HELLO_I = 1;
        public static final int SERVER_HELLO_I = 2;
        public static final int CERTIFICATE_I = 11;
        public static final int SERVER_KEY_EXCHANGE_I = 12;
        public static final int CERTIFICATE_REQUEST_I = 13;
        public static final int SERVER_HELLO_DONE_I = 14;
        public static final int CERTIFICATE_VERIFY_I = 15;
        public static final int CLIENT_KEY_EXCHANGE_I = 16;
        public static final int FINISHED_I = 20;
        public static final int CERTIFICATE_URL_I = 21;
        public static final int CERTIFICATE_STATUS_I = 22;
        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type read(InputStream in) throws IOException {
            int i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (i & 0xFF) {
                case 0: {
                    return HELLO_REQUEST;
                }
                case 1: {
                    return CLIENT_HELLO;
                }
                case 2: {
                    return SERVER_HELLO;
                }
                case 11: {
                    return CERTIFICATE;
                }
                case 12: {
                    return SERVER_KEY_EXCHANGE;
                }
                case 13: {
                    return CERTIFICATE_REQUEST;
                }
                case 14: {
                    return SERVER_HELLO_DONE;
                }
                case 15: {
                    return CERTIFICATE_VERIFY;
                }
                case 16: {
                    return CLIENT_KEY_EXCHANGE;
                }
                case 20: {
                    return FINISHED;
                }
                case 21: {
                    return CERTIFICATE_URL;
                }
                case 22: {
                    return CERTIFICATE_STATUS;
                }
            }
            return new Type(i);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "hello_request";
                }
                case 1: {
                    return "client_hello";
                }
                case 2: {
                    return "server_hello";
                }
                case 11: {
                    return "certificate";
                }
                case 12: {
                    return "server_key_exchange";
                }
                case 13: {
                    return "certificate_request";
                }
                case 14: {
                    return "server_hello_done";
                }
                case 15: {
                    return "certificate_verify";
                }
                case 16: {
                    return "client_key_exchange";
                }
                case 20: {
                    return "finished";
                }
                case 21: {
                    return "certificate_url";
                }
                case 22: {
                    return "certificate_status";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }

    private static class buffer
    extends ThreadLocal {
        static final int SIZE = 2048;

        private buffer() {
        }

        protected Object initialValue() {
            return new ByteArrayOutputStream(2048);
        }

        ByteArrayOutputStream getBuffer() {
            return (ByteArrayOutputStream)this.get();
        }
    }
}

