/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.BitString;
import btworks.jsse.provider.DER;
import btworks.jsse.provider.DEREncodingException;
import btworks.jsse.provider.DERValue;
import btworks.jsse.provider.OID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public class DERWriter
implements DER {
    private DERWriter() {
    }

    public static int write(OutputStream out, DERValue object) throws IOException {
        out.write(object.getExternalTag());
        Object value = object.getValue();
        if (value == null) {
            DERWriter.writeLength(out, 0);
            return 0;
        }
        if (value instanceof Boolean) {
            return DERWriter.writeBoolean(out, (Boolean)value);
        }
        if (value instanceof BigInteger) {
            return DERWriter.writeInteger(out, (BigInteger)value);
        }
        if (value instanceof Date) {
            return DERWriter.writeDate(out, object.getExternalTag(), (Date)value);
        }
        if (value instanceof String) {
            return DERWriter.writeString(out, object.getExternalTag(), (String)value);
        }
        if (value instanceof List) {
            return DERWriter.writeSequence(out, (List)value);
        }
        if (value instanceof Set) {
            return DERWriter.writeSet(out, (Set)value);
        }
        if (value instanceof BitString) {
            return DERWriter.writeBitString(out, (BitString)value);
        }
        if (value instanceof OID) {
            return DERWriter.writeOID(out, (OID)value);
        }
        if (value instanceof byte[]) {
            DERWriter.writeLength(out, ((byte[])value).length);
            out.write((byte[])value);
            return ((byte[])value).length;
        }
        if (value instanceof DERValue) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DERWriter.write(bout, (DERValue)value);
            byte[] buf = bout.toByteArray();
            DERWriter.writeLength(out, buf.length);
            out.write(buf);
            return buf.length;
        }
        throw new DEREncodingException("cannot encode " + value.getClass().getName());
    }

    public static int definiteEncodingSize(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    private static int writeBoolean(OutputStream out, Boolean b) throws IOException {
        DERWriter.writeLength(out, 1);
        if (b.booleanValue()) {
            out.write(255);
        } else {
            out.write(0);
        }
        return 1;
    }

    private static int writeInteger(OutputStream out, BigInteger integer) throws IOException {
        byte[] bytes = integer.toByteArray();
        DERWriter.writeLength(out, bytes.length);
        out.write(bytes);
        return bytes.length;
    }

    private static int writeSequence(OutputStream out, List sequence) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Iterator i = sequence.iterator();
        while (i.hasNext()) {
            DERWriter.write(bout, (DERValue)i.next());
        }
        byte[] buf = bout.toByteArray();
        DERWriter.writeLength(out, buf.length);
        out.write(buf);
        return buf.length;
    }

    private static int writeSet(OutputStream out, Set set) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            DERWriter.write(bout, (DERValue)i.next());
        }
        byte[] buf = bout.toByteArray();
        DERWriter.writeLength(out, buf.length);
        out.write(buf);
        return buf.length;
    }

    private static int writeOID(OutputStream out, OID oid) throws IOException {
        byte[] der = oid.getDER();
        DERWriter.writeLength(out, der.length);
        out.write(der);
        return der.length;
    }

    private static int writeBitString(OutputStream out, BitString bs) throws IOException {
        byte[] buf = bs.getShiftedByteArray();
        out.write(buf.length + 1);
        out.write(bs.getIgnoredBits());
        out.write(buf);
        return buf.length;
    }

    private static int writeString(OutputStream out, int tag, String str) throws IOException {
        byte[] b = null;
        switch (tag & 0x1F) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                b = str.getBytes("ISO-8859-1");
                break;
            }
            case 28: 
            case 30: {
                b = str.getBytes("UTF-16BE");
                break;
            }
            default: {
                b = str.getBytes("UTF-8");
            }
        }
        if (b == null) {
            throw new DEREncodingException("no charset");
        }
        DERWriter.writeLength(out, b.length);
        out.write(b);
        return b.length;
    }

    private static int writeDate(OutputStream out, int tag, Date date) throws IOException {
        SimpleDateFormat sdf = null;
        sdf = (tag & 0x1F) == 23 ? new SimpleDateFormat("yyMMddHHmmss'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'.'SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] b = sdf.format(date).getBytes("ISO-8859-1");
        DERWriter.writeLength(out, b.length);
        out.write(b);
        return b.length;
    }

    static void writeLength(OutputStream out, int len) throws IOException {
        if (len < 128) {
            out.write(len);
        } else if (len < 256) {
            out.write(129);
            out.write(len);
        } else if (len < 65536) {
            out.write(130);
            out.write(len >> 8);
            out.write(len);
        } else if (len < 0x1000000) {
            out.write(131);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len);
        } else {
            out.write(132);
            out.write(len >> 24);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len);
        }
    }
}

