/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.NullManagerParameters;
import btworks.jsse.StaticTrustAnchors;
import btworks.jsse.provider.SSLServerSocketFactory;
import btworks.jsse.provider.SSLSocketFactory;
import btworks.jsse.provider.SessionContext;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public final class Context
extends SSLContextSpi {
    private SessionContext clientSessions = new SessionContext();
    private SessionContext serverSessions = new SessionContext();
    private X509KeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom random;

    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessions;
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessions;
    }

    protected javax.net.ssl.SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactory(this.trustManager, this.keyManager, this.random, this.serverSessions);
    }

    protected javax.net.ssl.SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactory(this.trustManager, this.keyManager, this.random, this.clientSessions);
    }

    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom random) throws KeyManagementException {
        int i;
        this.keyManager = null;
        this.trustManager = null;
        if (keyManagers != null) {
            i = 0;
            while (i < keyManagers.length) {
                if (keyManagers[i] instanceof X509KeyManager) {
                    this.keyManager = (X509KeyManager)keyManagers[i];
                    break;
                }
                ++i;
            }
        }
        if (this.keyManager == null) {
            this.keyManager = this.defaultKeyManager();
        }
        if (trustManagers != null) {
            i = 0;
            while (i < trustManagers.length) {
                if (trustManagers[i] instanceof X509TrustManager && this.trustManager == null) {
                    this.trustManager = (X509TrustManager)trustManagers[i];
                }
                ++i;
            }
        }
        if (this.trustManager == null) {
            this.trustManager = this.defaultTrustManager();
        }
        this.random = random != null ? random : this.defaultRandom();
    }

    private X509KeyManager defaultKeyManager() throws KeyManagementException {
        KeyManagerFactory fact = null;
        try {
            fact = KeyManagerFactory.getInstance("BtworksX509", "BtworksJSSE");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyManagementException();
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyManagementException();
        }
        try {
            fact.init(null, null);
            return (X509KeyManager)fact.getKeyManagers()[0];
        }
        catch (NoSuchAlgorithmException nspe) {
        }
        catch (KeyStoreException nspe) {
        }
        catch (UnrecoverableKeyException nspe) {
        }
        catch (IllegalStateException nspe) {
            // empty catch block
        }
        try {
            fact.init(new NullManagerParameters());
            return (X509KeyManager)fact.getKeyManagers()[0];
        }
        catch (Exception shouldNotHappen) {
            throw new Error(shouldNotHappen.toString());
        }
    }

    private X509TrustManager defaultTrustManager() throws KeyManagementException {
        try {
            TrustManagerFactory fact = TrustManagerFactory.getInstance("BtworksX509", "BtworksJSSE");
            fact.init(StaticTrustAnchors.CA_CERTS);
            return (X509TrustManager)fact.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyManagementException(nsae.toString());
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyManagementException(nspe.toString());
        }
        catch (InvalidAlgorithmParameterException kse) {
            throw new KeyManagementException(kse.toString());
        }
    }

    private SecureRandom defaultRandom() throws KeyManagementException {
        SecureRandom rand = null;
        try {
            rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyManagementException(nsae.toString());
        }
        byte[] seed = new byte[20];
        Random rd = new Random();
        rd.nextBytes(seed);
        rand.setSeed(seed);
        return rand;
    }
}

