/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;

final class ClientKeyExchange
implements Handshake.Body {
    private final Object exObject;

    ClientKeyExchange(byte[] encryptedSecret) {
        this.exObject = encryptedSecret;
    }

    ClientKeyExchange(BigInteger bigint) {
        this.exObject = bigint;
    }

    static ClientKeyExchange read(InputStream in, CipherSuite suite, PublicKey key) throws IOException {
        DataInputStream din = new DataInputStream(in);
        if (suite.getKeyExchange().equals("RSA")) {
            int len = 0;
            len = suite.getVersion() == ProtocolVersion.SSL_3 ? (((RSAKey)((Object)key)).getModulus().bitLength() + 7) / 8 : din.readUnsignedShort();
            byte[] buf = new byte[len];
            din.readFully(buf);
            return new ClientKeyExchange(buf);
        }
        return new ClientKeyExchange(new byte[0]);
    }

    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("use write(java.io.OutputStream,ProtocolVersion) instead");
    }

    public void write(OutputStream out, ProtocolVersion version) throws IOException {
        if (this.exObject instanceof byte[]) {
            byte[] b = (byte[])this.exObject;
            if (b.length > 0) {
                if (version != ProtocolVersion.SSL_3) {
                    out.write(b.length >>> 8 & 0xFF);
                    out.write(b.length & 0xFF);
                }
                out.write(b);
            }
        } else {
            byte[] bigint = ((BigInteger)this.exObject).toByteArray();
            if (bigint[0] == 0) {
                out.write(bigint.length - 1 >>> 8 & 0xFF);
                out.write(bigint.length - 1 & 0xFF);
                out.write(bigint, 1, bigint.length - 1);
            } else {
                out.write(bigint.length >>> 8 & 0xFF);
                out.write(bigint.length & 0xFF);
                out.write(bigint);
            }
        }
    }

    Object getExchangeObject() {
        return this.exObject;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        if (this.exObject instanceof byte[] && ((byte[])this.exObject).length > 0) {
            out.println("  encryptedPreMasterSecret =");
            out.print(Util.hexDump((byte[])this.exObject, "    "));
        } else if (this.exObject instanceof BigInteger) {
            out.println("  clientPublic = " + ((BigInteger)this.exObject).toString(16) + ";");
        }
        out.println("} ClientKeyExchange;");
        return str.toString();
    }
}

