/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Enumerated;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;

final class CertificateRequest
implements Handshake.Body {
    private final ClientType[] types;
    private final Principal[] authorities;
    static /* synthetic */ Class class$0;

    CertificateRequest(ClientType[] types, Principal[] authorities) {
        if (types == null) {
            throw new NullPointerException();
        }
        this.types = types;
        if (authorities == null) {
            throw new NullPointerException();
        }
        this.authorities = authorities;
    }

    static CertificateRequest read(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        ClientType[] types = new ClientType[din.readUnsignedByte()];
        int i = 0;
        while (i < types.length) {
            types[i] = ClientType.read(din);
            ++i;
        }
        LinkedList<X500Principal> authorities = new LinkedList<X500Principal>();
        byte[] buf = new byte[din.readUnsignedShort()];
        din.readFully(buf);
        ByteArrayInputStream bin = new ByteArrayInputStream(buf);
        try {
            while (bin.available() > 0) {
                buf = new byte[(bin.read() & 0xFF) << 8 | bin.read() & 0xFF];
                bin.read(buf);
                authorities.add(new X500Principal(buf));
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
        return new CertificateRequest(types, authorities.toArray(new Principal[authorities.size()]));
    }

    public void write(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        out.write(this.types.length);
        int i = 0;
        while (i < this.types.length) {
            out.write(this.types[i].getValue());
            ++i;
        }
        try {
            Class<?> x500class = this.authorities[0].getClass();
            Method m = x500class.getMethod("getEncoded", null);
            int i2 = 0;
            while (i2 < this.authorities.length) {
                byte[] buf = (byte[])m.invoke((Object)this.authorities[i2], null);
                bout.write(buf.length >>> 8 & 0xFF);
                bout.write(buf.length & 0xFF);
                bout.write(buf, 0, buf.length);
                ++i2;
            }
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
        out.write(bout.size() >>> 8 & 0xFF);
        out.write(bout.size() & 0xFF);
        bout.writeTo(out);
    }

    ClientType[] getTypes() {
        return this.types;
    }

    String[] getTypeStrings() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (String[])Util.transform(this.types, clazz, "toString", null);
        }
        catch (Exception x) {
            return null;
        }
    }

    Principal[] getAuthorities() {
        return this.authorities;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.print("  types = ");
        int i = 0;
        while (i < this.types.length) {
            out.print(this.types[i]);
            if (i != this.types.length - 1) {
                out.print(", ");
            }
            ++i;
        }
        out.println(";");
        out.println("  authorities =");
        i = 0;
        while (i < this.authorities.length) {
            out.print("    ");
            out.print(this.authorities[i].getName());
            if (i != this.types.length - 1) {
                out.println(",");
            }
            ++i;
        }
        out.println(";");
        out.println("} CertificateRequest;");
        return str.toString();
    }

    static final class ClientType
    implements Enumerated {
        static final ClientType RSA_SIGN = new ClientType(1);
        static final ClientType DSS_SIGN = new ClientType(2);
        static final ClientType RSA_FIXED_DH = new ClientType(3);
        static final ClientType DSS_FIXED_DH = new ClientType(4);
        private final int value;

        private ClientType(int value) {
            this.value = value;
        }

        static ClientType read(InputStream in) throws IOException {
            int i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (i & 0xFF) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
            }
            return new ClientType(i);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 1: {
                    return "rsa_sign";
                }
                case 2: {
                    return "dss_sign";
                }
                case 3: {
                    return "rsa_fixed_dh";
                }
                case 4: {
                    return "dss_fixed_dh";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }
}

