/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.https;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLTunnelSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory dfactory;
    private String tunnelHost;
    private int tunnelPort;
    static final boolean dev = BtworksJSSE.DEBUG_URLConnection;

    public SSLTunnelSocketFactory(String proxyhost, int proxyport) {
        if (dev) {
            Trace.a("SSLTunnelSocketFactory()", "INIT_COUNT");
        }
        this.tunnelHost = proxyhost;
        this.tunnelPort = proxyport;
        this.dfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        if (dev) {
            Trace.a("SSLTunnelSocketFactory()", "contructor..[Host:" + this.tunnelHost + "][port:" + this.tunnelPort + "]");
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(null, host, port, true);
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.createSocket(null, host, port, true);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket(null, host.getHostName(), port, true);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return this.createSocket(null, address.getHostName(), port, true);
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().createSocket", "connect to tunnel host: " + this.tunnelHost + ":" + this.tunnelPort);
        }
        Socket tunnel = new Socket(this.tunnelHost, this.tunnelPort);
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().createSocket", "try to tunnelHandshake..");
        }
        this.doTunnelHandshake(tunnel, host, port);
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().createSocket", "doing tunnelHandshake..");
        }
        SSLSocket result = (SSLSocket)this.dfactory.createSocket(tunnel, host, port, autoClose);
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().createSocket", "tunnelHandshake ok");
        }
        result.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            public void handshakeCompleted(HandshakeCompletedEvent event) {
                System.out.println("Handshake finished!");
                System.out.println("\t CipherSuite:" + event.getCipherSuite());
                System.out.println("\t SessionId " + event.getSession());
                System.out.println("\t PeerHost " + event.getSession().getPeerHost());
            }
        });
        result.startHandshake();
        return result;
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        String replyStr;
        byte[] b;
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "try to getOutputStream");
        }
        OutputStream out = tunnel.getOutputStream();
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "getOutputStream ok");
        }
        String msg = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + "User-Agent: " + "BtworksJSSE/1.1.2" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "write ok");
        }
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "try to getInputStream");
        }
        InputStream in = tunnel.getInputStream();
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "getInputStream ok");
        }
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (dev) {
            Trace.a("SSLTunnelSocketFactory().doTunnelHandshake", "replyStr:" + replyStr);
        }
        if (replyStr.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through " + this.tunnelHost + ":" + this.tunnelPort + ".  Proxy returns \"" + replyStr + "\"");
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.dfactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.dfactory.getSupportedCipherSuites();
    }
}

