/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.https;

import btworks.jsse.https.ChunkedInputStream;
import btworks.jsse.https.SSLTunnelSocketFactory;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Trace;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;

public class Connection
extends HttpsURLConnection {
    public static final String USER_AGENT = "BtworksJSSE/1.1.2";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CHUNKED = "chunked";
    public static final int HTTPS_PORT = 443;
    private ArrayList requestProps;
    private ArrayList headers;
    private SSLSocket socket;
    private InputStream in;
    private OutputStream out;
    private ByteArrayOutputStream bufferedOut;
    private boolean requestSent = false;
    private boolean usingProxy = false;
    private String tunnelHost;
    private int tunnelPort;
    private boolean usingChunked;
    static final boolean dev = BtworksJSSE.DEBUG_URLConnection;

    protected Connection(URL uRL) throws IOException {
        super(uRL);
        this.doOutput = false;
        this.headers = new ArrayList(10);
        this.tunnelHost = System.getProperty("https.proxyHost");
        Integer n = Integer.getInteger("https.proxyPort");
        if (dev) {
            Trace.a("Connection()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("Connection()", "contructor...");
        }
        if (this.tunnelHost != null && n != null) {
            this.tunnelPort = n;
            this.setSSLSocketFactory(new SSLTunnelSocketFactory(this.tunnelHost, this.tunnelPort));
            this.usingProxy = true;
            if (dev) {
                Trace.a("Connection()", "using proxy [Host:" + this.tunnelHost + "][port:" + this.tunnelPort + "]");
            }
        }
    }

    public String getCipherSuite() {
        if (!this.connected) {
            throw new IllegalStateException("not yet connected");
        }
        return this.socket.getSession().getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (!this.connected) {
            throw new IllegalStateException("not yet connected");
        }
        return this.socket.getSession().getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (!this.connected) {
            throw new IllegalStateException("not yet connected");
        }
        return this.socket.getSession().getPeerCertificates();
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean usingProxy() {
        return this.usingProxy;
    }

    public synchronized void connect() throws IOException {
        block8: {
            String string = this.url.getHost();
            int n = this.url.getPort();
            if (n == -1) {
                n = 443;
            }
            this.socket = (SSLSocket)this.getSSLSocketFactory().createSocket(string, n);
            String string2 = Security.getProperty("btworks.https.timeout");
            if (string2 != null) {
                try {
                    this.socket.setSoTimeout(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.usingProxy) {
                this.socket.startHandshake();
            }
            try {
                X509Certificate x509Certificate = (X509Certificate)this.socket.getSession().getPeerCertificates()[0];
                if (!this.checkHostname(string, x509Certificate) && !this.hostnameVerifier.verify(string, this.socket.getSession())) {
                    throw new SSLPeerUnverifiedException("hostname mismatch");
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (this.hostnameVerifier.verify(string, this.socket.getSession())) break block8;
                throw sSLPeerUnverifiedException;
            }
        }
        this.out = this.socket.getOutputStream();
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (dev) {
            Trace.a("Connection.getInputStream()", "call getInputStream");
        }
        if (this.in != null) {
            return this.in;
        }
        if (!this.connected) {
            this.connect();
        }
        this.in = this.socket.getInputStream();
        this.sendRequest();
        this.receiveReply();
        if (this.usingChunked) {
            this.in = new ChunkedInputStream(this.in);
        }
        return this.in;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (dev) {
            Trace.a("Connection.getOutputStream()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("Connection.getOutputStream()", "call getOutputStream");
        }
        if (!this.doOutput) {
            throw new IOException("not set up for output");
        }
        if (!this.method.equals("POST")) {
            this.setRequestMethod("POST");
        }
        if (!this.connected) {
            if (dev) {
                Trace.a("Connection.getOutputStream()", "not connected...");
            }
            this.connect();
            if (dev) {
                Trace.a("Connection.getOutputStream()", "connect success...");
            }
        }
        if (this.bufferedOut == null) {
            this.bufferedOut = new ByteArrayOutputStream();
        }
        return this.bufferedOut;
    }

    public String getContentEncoding() {
        return this.getHeaderField("Content-Encoding");
    }

    public int getContentLength() {
        return this.getHeaderFieldInt(CONTENT_LENGTH, -1);
    }

    public String getContentType() {
        return this.getHeaderField("Content-Type");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    public int getHeaderFieldInt(String string, int n) {
        try {
            return Integer.parseInt(this.getHeaderField(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getHeaderFieldDate(String string, long l) {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(1);
            dateFormat.setLenient(true);
            return dateFormat.parse(this.getHeaderField(string)).getTime();
        }
        catch (Exception exception) {
            return l;
        }
    }

    public long getIfModifiedSince() {
        return this.getHeaderFieldDate("If-Modified-Since", 0L);
    }

    public Map getHeaderFields() {
        List<Object> list;
        Map.Entry entry;
        if (this.headers == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.headers.size());
        for (int i = 0; i < this.headers.size(); ++i) {
            entry = (Header)this.headers.get(i);
            if (hashMap.containsKey(((Header)entry).getKey())) {
                ((List)hashMap.get(((Header)entry).getKey())).add(((Header)entry).getValue());
                continue;
            }
            list = new LinkedList();
            ((LinkedList)list).add(((Header)entry).getValue());
            hashMap.put(((Header)entry).getKey(), ((Header)entry).getValue());
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            list = (List)entry.getValue();
            entry.setValue(Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        if (n < 0 || this.headers == null || n >= this.headers.size()) {
            return null;
        }
        return (String)((Header)this.headers.get(n)).getValue();
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        if (this.headers == null) {
            return null;
        }
        Iterator iterator = ((AbstractList)this.headers).iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (!((String)header.getKey()).equalsIgnoreCase(string)) continue;
            return (String)header.getValue();
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            throw new IllegalStateException("not connected");
        }
        if (n < 0 || this.headers == null || n >= this.headers.size()) {
            return null;
        }
        return (String)((Header)this.headers.get(n)).getKey();
    }

    public void addRequestProperty(String string, String string2) {
        if (this.requestSent) {
            throw new IllegalStateException("already connected");
        }
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.requestProps == null) {
            this.requestProps = new ArrayList(10);
        }
        Iterator iterator = ((AbstractList)this.requestProps).iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (!((String)header.getKey()).equalsIgnoreCase(string)) continue;
            header.setValue(header.getValue() + ", " + string2);
            return;
        }
        this.requestProps.add(new Header(string, string2));
    }

    public void setRequestProperty(String string, String string2) {
        if (this.requestSent) {
            throw new IllegalStateException("already connected");
        }
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.requestProps == null) {
            this.requestProps = new ArrayList(10);
        }
        Iterator iterator = ((AbstractList)this.requestProps).iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (!((String)header.getKey()).equalsIgnoreCase(string)) continue;
            iterator.remove();
            break;
        }
        this.requestProps.add(new Header(string, string2));
    }

    public String getRequestProperty(String string) {
        if (this.requestSent) {
            throw new IllegalStateException("already connected");
        }
        if (string == null || this.requestProps == null) {
            return null;
        }
        Iterator iterator = ((AbstractList)this.requestProps).iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (!((String)header.getKey()).equalsIgnoreCase(string)) continue;
            return (String)header.getValue();
        }
        return null;
    }

    public Map getRequestProperties() {
        if (this.requestSent) {
            throw new IllegalStateException("already connected");
        }
        HashMap<Object, List<Object>> hashMap = new HashMap<Object, List<Object>>(this.requestProps.size());
        Iterator iterator = ((AbstractList)this.requestProps).iterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            hashMap.put(header.getKey(), Collections.singletonList(header.getValue()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private boolean checkHostname(String string, X509Certificate x509Certificate) {
        return true;
    }

    private void sendRequest() throws IOException {
        Object object;
        Object object2;
        if (dev) {
            Trace.a("Connection.sendRequest()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("Connection.sendRequest()", "sendRequest start...");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.out);
        String string = this.getRequestMethod() + " " + this.getURL().getFile() + " HTTP/1.1\r\n";
        bufferedOutputStream.write(string.getBytes());
        if (this.getRequestProperty("Host") == null) {
            this.setRequestProperty("Host", this.getURL().getHost());
        }
        if (this.getRequestProperty("Connection") == null) {
            this.setRequestProperty("Connection", "Close");
        }
        if (this.getRequestProperty("User-Agent") == null) {
            this.setRequestProperty("User-Agent", USER_AGENT);
        } else {
            this.setRequestProperty("User-Agent", this.getRequestProperty("User-Agent") + " " + USER_AGENT);
        }
        if (this.getRequestProperty("Accept") == null) {
            this.setRequestProperty("Accept", "*/*");
        }
        if (this.getRequestProperty("Content-Type") == null) {
            this.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        if (dev) {
            Trace.a("Connection.sendRequest()", "requestProperty: " + this.requestProps);
        }
        Iterator iterator = ((AbstractList)this.requestProps).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object2 = (Header)iterator.next();
            object = (String)((Header)object2).getKey();
            String string2 = (String)((Header)object2).getValue();
            if (((String)object).length() + string2.length() + 2 < 72) {
                string = (String)object + ": " + string2 + "\r\n";
                bufferedOutputStream.write(string.getBytes());
                continue;
            }
            string = (String)object + ": ";
            bufferedOutputStream.write(string.getBytes());
            int n = ((String)object).length() + 2;
            bufferedOutputStream.write(string2.substring(0, n).getBytes());
            string2 = string2.substring(n + 1);
            while (string2 != null) {
                bufferedOutputStream.write(9);
                n = Math.min(72, string2.length());
                bufferedOutputStream.write(string2.substring(0, n).getBytes());
                if (n == string2.length()) {
                    string2 = null;
                    continue;
                }
                string2 = string2.substring(n + 1);
            }
            bufferedOutputStream.write("\r\n".getBytes());
        }
        if (this.bufferedOut != null) {
            if (this.getRequestProperty(CONTENT_LENGTH) == null) {
                if (dev) {
                    Trace.a("Connection.sendRequest()", "add Content-Length field");
                }
                bufferedOutputStream.write(("Content-Length: " + this.bufferedOut.size() + "\r\n").getBytes());
            } else if (dev) {
                Trace.a("Connection.sendRequest()", "Content-Length field is already included");
            }
        }
        bufferedOutputStream.write("\r\n".getBytes());
        if (this.bufferedOut != null) {
            if (dev) {
                object2 = new ByteArrayOutputStream();
                this.bufferedOut.writeTo((OutputStream)object2);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                Trace.a("Connection.sendRequest()", "bufferedOut length: " + this.bufferedOut.size());
                Trace.a("Connection.sendRequest()", "bufferedOut: " + new String((byte[])object) + "[END]");
                bufferedOutputStream.write((byte[])object);
            } else {
                this.bufferedOut.writeTo(bufferedOutputStream);
            }
        }
        bufferedOutputStream.flush();
        Trace.a("Connection.sendRequest()", "bufferedOut flushed...");
        this.requestSent = true;
    }

    private void receiveReply() throws IOException {
        String string = this.readLine();
        int n = string.indexOf(" ");
        if (n < 0 || string.length() < n + 6) {
            throw new IOException("malformed HTTP reply");
        }
        string = string.substring(n + 1);
        String string2 = string.substring(0, 3);
        try {
            this.responseCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("malformed HTTP reply: unparsable response code: " + string2);
        }
        this.responseMessage = string.substring(4);
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine()).trim().length() != 0) {
            if (string.startsWith(" ") || string.startsWith("\t")) {
                string = string.trim();
                do {
                    if (string.length() != 1) continue;
                    throw new IOException("malformed header");
                } while ((string = string.substring(1)).startsWith(" ") || string.startsWith("\t"));
                stringBuffer.append(' ');
                stringBuffer.append(string);
                continue;
            }
            if (string3 != null) {
                this.headers.add(new Header(string3, stringBuffer.toString()));
                string3 = null;
                stringBuffer.setLength(0);
            }
            if ((n = string.indexOf(":")) < 0 || string.length() < n + 2) {
                throw new IOException("malformed header");
            }
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
            while (string.startsWith(" ") || string.startsWith("\t")) {
                if (string.length() == 1) {
                    throw new IOException("malformed header");
                }
                string = string.substring(1);
            }
            stringBuffer.append(string);
        }
        if (string3 != null) {
            this.headers.add(new Header(string3, stringBuffer.toString()));
        }
        if (CHUNKED.equals(this.getHeaderField("Transfer-Encoding"))) {
            if (dev) {
                Trace.a("Connection.receiveReply()", "Transfer-Encoding: chunked (" + string + ")");
            }
            this.usingChunked = true;
        }
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.in.read()) != -1 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private class Header
    implements Map.Entry {
        private final String name;
        private String value;

        public Header(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public Object getKey() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            return ((Header)object).name.equalsIgnoreCase(this.name) && ((Header)object).value.equalsIgnoreCase(this.value);
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.value.hashCode();
        }

        public Object setValue(Object object) {
            String string = this.value;
            this.value = (String)object;
            return string;
        }
    }
}

