/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.https;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Trace;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    InputStream in;
    int chunkLength;
    int readLength;
    static final boolean dev = BtworksJSSE.DEBUG_URLConnection;

    public ChunkedInputStream(InputStream is) {
        this.in = is;
    }

    public int read() throws IOException {
        int bytes = 0;
        if (this.readLength == this.chunkLength) {
            String line = this.readLine();
            if (this.chunkLength != 0) {
                line = this.readLine();
            }
            this.chunkLength = Integer.parseInt(line, 16);
            if (this.chunkLength == 0) {
                if (dev) {
                    Trace.a("ChunkedInputStream.read()", "chunked data ends..");
                }
                bytes = -1;
            } else {
                if (dev) {
                    Trace.a("ChunkedInputStream.read()", "chunked length (" + line + ")");
                }
                this.readLength = 0;
                bytes = this.in.read();
                ++this.readLength;
            }
        } else {
            bytes = this.in.read();
            ++this.readLength;
        }
        return bytes;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int i = 0;
        if (this.readLength + len <= this.chunkLength) {
            i = this.in.read(b, off, len);
            this.readLength += i;
        } else {
            int remindLen = this.chunkLength - this.readLength;
            if (remindLen == 0) {
                String line = this.readLine();
                if (this.chunkLength != 0) {
                    line = this.readLine();
                }
                if (dev) {
                    Trace.a("ChunkedInputStream.read2()", "chunked length (" + line + ")");
                }
                this.chunkLength = Integer.parseInt(line, 16);
                if (this.chunkLength == 0) {
                    line = this.readLine();
                    if (dev) {
                        Trace.a("ChunkedInputStream.read2()", "chunked data ends..");
                    }
                    i = -1;
                } else {
                    this.readLength = 0;
                    i = this.in.read(b, off, len);
                    this.readLength += i;
                }
            } else {
                i = this.in.read(b, off, remindLen);
                this.readLength += i;
            }
        }
        return i;
    }

    private String readLine() throws IOException {
        int i;
        StringBuffer line = new StringBuffer();
        while ((i = this.in.read()) != -1 && i != 10) {
            if (i == 13) continue;
            line.append((char)i);
        }
        return line.toString();
    }
}

