/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.ManagerFactoryParameters;

public class StaticTrustAnchors
implements ManagerFactoryParameters {
    private X509Certificate[] certs;
    public static final StaticTrustAnchors CA_CERTS;

    static {
        LinkedList<X509Certificate> certs = new LinkedList<X509Certificate>();
        CertificateFactory factory = null;
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            throw new Error(ce.toString());
        }
        X509Certificate cert = null;
        cert = StaticTrustAnchors.generate(factory, "-----BEGIN CERTIFICATE-----MIICQDCCAakCBEE/B5gwDQYJKoZIhvcNAQEFBQAwZzELMAkGA1UEBhMCS1IxDjAM\nBgNVBAgTBVNlb3VsMQ4wDAYDVQQHEwVTZW91bDEQMA4GA1UEChMHQlRXb3JrczEQ\nMA4GA1UECxMHUEtJIERldjEUMBIGA1UEAxMLVExTIExldmVsIDQwHhcNMDQwOTA4\nMTMyMjMyWhcNMDQxMjA3MTMyMjMyWjBnMQswCQYDVQQGEwJLUjEOMAwGA1UECBMF\nU2VvdWwxDjAMBgNVBAcTBVNlb3VsMRAwDgYDVQQKEwdCVFdvcmtzMRAwDgYDVQQL\nEwdQS0kgRGV2MRQwEgYDVQQDEwtUTFMgTGV2ZWwgNDCBnzANBgkqhkiG9w0BAQEF\nAAOBjQAwgYkCgYEApBymOu+E5e+CedrHyJZJCwaCVKECApLXTJMEgvpeIHkzs2sP\nO3F9Grda8OI3m75Wg4ilwjVubhP0rKpLXEM4Qqa4VRdKnEcW2F+aHOQOIfWtPoRi\nJSwsGnWYz4kHk57Rfy4LGow242SA3Gw5jR4MyDvjMMZl+i1BDQn4rWQyII0CAwEA\nATANBgkqhkiG9w0BAQUFAAOBgQAMKWU+KZieT0cfOKPVEOMq8Vf26p5/8XMRIMg2\nw/QCFfQUF9Xop3HclWIL4hrop6SaHHb5m6RgIK0zLH94qgKHlf8pwa4Fdn3xauCH\nh1I3jcYfJWz0eJAWEqAF16kI0xu5lWBiKgN0KgU2Hffogb5SYoD3zaRmUTpS7S+9\nuCQawQ==\n-----END CERTIFICATE-----\n");
        if (cert != null) {
            certs.add(cert);
        }
        CA_CERTS = new StaticTrustAnchors(certs.toArray(new X509Certificate[0]));
    }

    public StaticTrustAnchors(X509Certificate[] certs) {
        this.certs = (X509Certificate[])certs.clone();
    }

    public static X509Certificate generate(CertificateFactory factory, String encoded) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(encoded.getBytes("UTF-8"));
            return (X509Certificate)factory.generateCertificate(in);
        }
        catch (Exception x) {
            return null;
        }
    }

    public X509Certificate[] getCertificates() {
        return (X509Certificate[])this.certs.clone();
    }
}

