/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse;

import btworks.crypto.cipher.DESacc2;
import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.jsse.Base64;
import btworks.jsse.callbacks.ConsoleCallbackHandler;
import btworks.jsse.provider.DERReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.ManagerFactoryParameters;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PrivateCredentials
implements ManagerFactoryParameters {
    public static final String BEGIN_DSA = "-----BEGIN DSA PRIVATE KEY";
    public static final String END_DSA = "-----END DSA PRIVATE KEY";
    public static final String BEGIN_RSA = "-----BEGIN RSA PRIVATE KEY";
    public static final String END_RSA = "-----END RSA PRIVATE KEY";
    private List privateKeys = new LinkedList();
    private List certChains = new LinkedList();

    public void add(InputStream certChain, InputStream privateKey) throws CertificateException, InvalidKeyException, InvalidKeySpecException, IOException, NoSuchAlgorithmException {
        DERReader der;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = cf.generateCertificates(certChain);
        X509Certificate[] chain = certs.toArray(new X509Certificate[0]);
        String alg = null;
        String line = this.readLine(privateKey);
        String finalLine = null;
        if (line.startsWith(BEGIN_DSA)) {
            alg = "DSA";
            finalLine = END_DSA;
        } else if (line.startsWith(BEGIN_RSA)) {
            alg = "RSA";
            finalLine = END_RSA;
        } else {
            throw new IOException("Unknown private key type.");
        }
        boolean encrypted = false;
        String cipher = null;
        String salt = null;
        StringBuffer base64 = new StringBuffer();
        while (true) {
            if ((line = this.readLine(privateKey)) == null) {
                throw new EOFException("premature end-of-file");
            }
            if (line.startsWith("Proc-Type: 4,ENCRYPTED")) {
                encrypted = true;
                continue;
            }
            if (line.startsWith("DEK-Info: ")) {
                int i = line.indexOf(44);
                if (i < 0) {
                    cipher = line.substring(10).trim();
                    continue;
                }
                cipher = line.substring(10, i).trim();
                salt = line.substring(i + 1).trim();
                continue;
            }
            if (line.startsWith(finalLine)) break;
            if (line.length() <= 0) continue;
            base64.append(line);
            base64.append(System.getProperty("line.separator"));
        }
        byte[] enckey = Base64.decode(base64.toString());
        if (encrypted) {
            enckey = this.decryptKey(enckey, cipher, this.toByteArray(salt));
        }
        if ((der = new DERReader(enckey)).read().getTag() != 16) {
            throw new IOException("malformed DER sequence");
        }
        der.read();
        KeyFactory kf = KeyFactory.getInstance(alg);
        KeySpec spec = null;
        if (alg.equals("DSA")) {
            BigInteger p = (BigInteger)der.read().getValue();
            BigInteger q = (BigInteger)der.read().getValue();
            BigInteger g = (BigInteger)der.read().getValue();
            der.read();
            BigInteger x = (BigInteger)der.read().getValue();
            spec = new DSAPrivateKeySpec(x, p, q, g);
        } else {
            spec = new RSAPrivateCrtKeySpec((BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue(), (BigInteger)der.read().getValue());
        }
        this.privateKeys.add(kf.generatePrivate(spec));
        this.certChains.add(chain);
    }

    public List getPrivateKeys() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("this object is destroyed");
        }
        return this.privateKeys;
    }

    public List getCertChains() {
        return this.certChains;
    }

    public void destroy() {
        this.privateKeys.clear();
        this.privateKeys = null;
    }

    public boolean isDestroyed() {
        return this.privateKeys == null;
    }

    private String readLine(InputStream in) throws IOException {
        boolean eol_is_cr = System.getProperty("line.separator").equals("\r");
        StringBuffer str = new StringBuffer();
        while (true) {
            int i;
            if ((i = in.read()) == -1) {
                if (str.length() > 0) break;
                return null;
            }
            if (i == 13) {
                if (!eol_is_cr) continue;
                break;
            }
            if (i == 10) break;
            str.append((char)i);
        }
        return str.toString();
    }

    private byte[] decryptKey(byte[] ct, String cipher, byte[] salt) throws IOException {
        DESacc2 acc = null;
        byte[] key = null;
        if (cipher.equals("DES-CBC")) {
            acc = new DESacc2();
            key = this.deriveKey(salt, 8);
        } else if (cipher.equals("SEED-CBC")) {
            acc = new DESacc2();
            key = this.deriveKey(salt, 16);
        }
        return acc.decryptCBC(ct, true);
    }

    private byte[] deriveKey(byte[] salt, int keylen) throws IOException {
        ConsoleCallbackHandler passwordHandler = new ConsoleCallbackHandler();
        PasswordCallback passwdCallback = new PasswordCallback("Enter PEM passphrase: ", false);
        try {
            passwordHandler.handle(new Callback[]{passwdCallback});
        }
        catch (UnsupportedCallbackException uce) {
            throw new IOException("specified handler cannot handle passwords");
        }
        char[] passwd = passwdCallback.getPassword();
        BtwMessageDigest md5 = HashFactory.getInstance("MD5");
        byte[] key = new byte[keylen];
        int count = 0;
        while (count < keylen) {
            int i = 0;
            while (i < passwd.length) {
                md5.update((byte)passwd[i]);
                ++i;
            }
            md5.update(salt, 0, salt.length);
            byte[] digest = md5.digest();
            int len = Math.min(digest.length, keylen - count);
            System.arraycopy(digest, 0, key, count, len);
            if ((count += len) >= keylen) break;
            md5.reset();
            md5.update(digest, 0, digest.length);
        }
        passwdCallback.clearPassword();
        return key;
    }

    private byte[] toByteArray(String hex) {
        hex = hex.toLowerCase();
        byte[] buf = new byte[hex.length() / 2];
        int j = 0;
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)(Character.digit(hex.charAt(j++), 16) << 4 | Character.digit(hex.charAt(j++), 16));
            ++i;
        }
        return buf;
    }
}

