/*
 * Decompiled with CFR 0.152.
 */
package btworks.crypto.mac;

import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.mac.BtwMac;
import java.security.InvalidKeyException;
import java.util.Map;

public abstract class BaseMac
implements BtwMac {
    protected String name;
    protected BtwMessageDigest underlyingHash;
    protected int truncatedSize;

    protected BaseMac(String name) {
        this.name = name;
    }

    protected BaseMac(String name, BtwMessageDigest underlyingHash) {
        this(name);
        if (underlyingHash != null) {
            this.truncatedSize = underlyingHash.hashSize();
        }
        this.underlyingHash = underlyingHash;
    }

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.truncatedSize;
    }

    public void update(byte b) {
        this.underlyingHash.update(b);
    }

    public void update(byte[] b, int offset, int len) {
        this.underlyingHash.update(b, offset, len);
    }

    public void reset() {
        this.underlyingHash.reset();
    }

    public abstract Object clone();

    public abstract void init(Map var1) throws InvalidKeyException, IllegalStateException;

    public abstract byte[] digest();

    public abstract boolean selfTest();
}

