/*
 * Decompiled with CFR 0.152.
 */
package btworks.crypto.cipher;

import btworks.crypto.cipher.Acc;
import btworks.crypto.cipher.DESacc;
import java.util.Collections;
import java.util.Iterator;

public class TripleDES
implements Acc {
    public static final int BSIZE = 8;
    public static final int BSIZE_BITS = 3;
    public static final int KEY_SIZE = 24;
    private DESacc des;
    Object K;
    byte[] iv;
    byte[] fBlock = new byte[8];

    public TripleDES() {
        this.des = new DESacc();
    }

    public static void adjustParity(byte[] kb, int offset) {
        DESacc.adjustParity(kb, offset);
        DESacc.adjustParity(kb, offset + 8);
        DESacc.adjustParity(kb, offset + 16);
    }

    public static boolean isParityAdjusted(byte[] kb, int offset) {
        return DESacc.isParityAdjusted(kb, offset) && DESacc.isParityAdjusted(kb, offset + 8) && DESacc.isParityAdjusted(kb, offset + 16);
    }

    public Object clone() {
        return new TripleDES();
    }

    public Iterator blockSizes() {
        return Collections.singleton(new Integer(8)).iterator();
    }

    public Iterator keySizes() {
        return Collections.singleton(new Integer(24)).iterator();
    }

    public Object makeKey(byte[] kb, int bs) {
        if (kb.length != 24) {
            throw new IllegalArgumentException("TripleDES key must be 24 bytes");
        }
        if (!TripleDES.isParityAdjusted(kb, 0)) {
            TripleDES.adjustParity(kb, 0);
        }
        byte[] k1 = new byte[8];
        byte[] k2 = new byte[8];
        byte[] k3 = new byte[8];
        System.arraycopy(kb, 0, k1, 0, 8);
        System.arraycopy(kb, 8, k2, 0, 8);
        System.arraycopy(kb, 16, k3, 0, 8);
        Context ctx = new Context();
        ctx.k1 = (DESacc.Context)this.des.makeKey(k1, bs);
        ctx.k2 = (DESacc.Context)this.des.makeKey(k2, bs);
        ctx.k3 = (DESacc.Context)this.des.makeKey(k3, bs);
        return ctx;
    }

    public void encrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        byte[] temp = new byte[8];
        this.des.encrypt(in, i, temp, 0, ((Context)K).k1, bs);
        this.des.decrypt(temp, 0, temp, 0, ((Context)K).k2, bs);
        this.des.encrypt(temp, 0, out, o, ((Context)K).k3, bs);
    }

    public void decrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        byte[] temp = new byte[8];
        this.des.decrypt(in, i, temp, 0, ((Context)K).k3, bs);
        this.des.encrypt(temp, 0, temp, 0, ((Context)K).k2, bs);
        this.des.decrypt(temp, 0, out, o, ((Context)K).k1, bs);
    }

    public int currentBlockSize() {
        return 8;
    }

    public void init(byte[] key, byte[] iv) {
        this.K = this.makeKey(key, 8);
        this.iv = iv;
    }

    public byte[] encryptCBC(byte[] plainText, boolean padding) {
        int dLen = plainText.length;
        int fBlock_no = padding ? dLen >>> 3 : dLen - 1 >>> 3;
        int fBlock_idx = fBlock_no << 3;
        int blockCount = fBlock_no + 1;
        int tLen = blockCount << 3;
        byte[] input = new byte[tLen];
        byte[] output = new byte[tLen];
        System.arraycopy(plainText, 0, input, 0, dLen);
        if (padding) {
            int padLen = tLen - dLen;
            byte padByte = (byte)padLen;
            int ti = dLen;
            while (ti < tLen) {
                input[ti] = padByte;
                ++ti;
            }
        }
        int bi = 8;
        while (--bi >= 0) {
            int n = bi;
            input[n] = (byte)(input[n] ^ this.iv[bi]);
        }
        int bn = 0;
        while (bn < fBlock_no) {
            int ti = bn << 3;
            int ti_next = ti + 8;
            this.encrypt(input, ti, output, ti, this.K, 0);
            int i = 8;
            while (--i >= 0) {
                int n = ti_next + i;
                input[n] = (byte)(input[n] ^ output[ti + i]);
            }
            ++bn;
        }
        this.encrypt(input, fBlock_idx, output, fBlock_idx, this.K, 0);
        int i = 8;
        while (--i >= 0) {
            this.iv[i] = output[fBlock_idx + i];
        }
        return output;
    }

    public byte[] decryptCBC(byte[] cipherText, boolean padding) {
        int tLen = cipherText.length;
        int blockCount = tLen >>> 3;
        byte[] input = cipherText;
        byte[] output = new byte[tLen];
        this.decrypt(input, 0, output, 0, this.K, 0);
        int bi = 8;
        while (--bi >= 0) {
            int n = bi;
            output[n] = (byte)(output[n] ^ this.iv[bi]);
        }
        int bn = 1;
        while (bn < blockCount) {
            int ti = bn << 3;
            int ti_prev = ti - 8;
            this.decrypt(input, ti, output, ti, this.K, 0);
            int i = 8;
            while (--i >= 0) {
                int n = ti + i;
                output[n] = (byte)(output[n] ^ input[ti_prev + i]);
            }
            ++bn;
        }
        int fBlock_idx = tLen - 8;
        int i = 8;
        while (--i >= 0) {
            this.iv[i] = input[fBlock_idx + i];
        }
        if (padding) {
            int padByte = output[tLen - 1] & 0xFF;
            byte[] result = new byte[tLen - padByte];
            System.arraycopy(output, 0, result, 0, result.length);
            return result;
        }
        return output;
    }

    public void decryptCBC2(byte[] cipherText) {
        int tLen = cipherText.length;
        int blockCount = tLen >>> 3;
        byte[] input = cipherText;
        byte[] aBlock = new byte[8];
        int fBlock_idx = tLen - 8;
        int bi = 8;
        while (--bi >= 0) {
            this.fBlock[bi] = input[fBlock_idx + bi];
        }
        int bn = blockCount;
        while (--bn > 0) {
            int ti = bn << 3;
            int ti_prev = ti - 8;
            this.decrypt(input, ti, aBlock, 0, this.K, 0);
            int bi2 = 8;
            while (--bi2 >= 0) {
                input[ti + bi2] = (byte)(aBlock[bi2] ^ input[ti_prev + bi2]);
            }
        }
        this.decrypt(input, 0, aBlock, 0, this.K, 0);
        bi = 8;
        while (--bi >= 0) {
            input[bi] = (byte)(aBlock[bi] ^ this.iv[bi]);
            this.iv[bi] = this.fBlock[bi];
        }
    }

    private final class Context {
        DESacc.Context k1;
        DESacc.Context k2;
        DESacc.Context k3;

        private Context() {
        }
    }
}

