/*
 * Decompiled with CFR 0.152.
 */
package btworks.crypto.cipher;

import btworks.crypto.cipher.Acc;
import btworks.jsse.provider.Util;

public class DESacc
implements Acc {
    public static final int BSIZE = 8;
    public static final int KEY_SIZE = 8;
    public static final int BSIZE_BITS = 3;
    Object K;
    byte[] iv;
    byte[] fBlock = new byte[8];
    private static final int[] SP1;
    private static final int[] SP2;
    private static final int[] SP3;
    private static final int[] SP4;
    private static final int[] SP5;
    private static final int[] SP6;
    private static final int[] SP7;
    private static final int[] SP8;
    private static final byte[] PARITY;
    private static final byte[] ROTARS;
    private static final byte[] PC1;
    private static final byte[] PC2;

    static {
        int[] nArray = new int[64];
        nArray[0] = 0x1010400;
        nArray[2] = 65536;
        nArray[3] = 0x1010404;
        nArray[4] = 0x1010004;
        nArray[5] = 66564;
        nArray[6] = 4;
        nArray[7] = 65536;
        nArray[8] = 1024;
        nArray[9] = 0x1010400;
        nArray[10] = 0x1010404;
        nArray[11] = 1024;
        nArray[12] = 0x1000404;
        nArray[13] = 0x1010004;
        nArray[14] = 0x1000000;
        nArray[15] = 4;
        nArray[16] = 1028;
        nArray[17] = 0x1000400;
        nArray[18] = 0x1000400;
        nArray[19] = 66560;
        nArray[20] = 66560;
        nArray[21] = 0x1010000;
        nArray[22] = 0x1010000;
        nArray[23] = 0x1000404;
        nArray[24] = 65540;
        nArray[25] = 0x1000004;
        nArray[26] = 0x1000004;
        nArray[27] = 65540;
        nArray[29] = 1028;
        nArray[30] = 66564;
        nArray[31] = 0x1000000;
        nArray[32] = 65536;
        nArray[33] = 0x1010404;
        nArray[34] = 4;
        nArray[35] = 0x1010000;
        nArray[36] = 0x1010400;
        nArray[37] = 0x1000000;
        nArray[38] = 0x1000000;
        nArray[39] = 1024;
        nArray[40] = 0x1010004;
        nArray[41] = 65536;
        nArray[42] = 66560;
        nArray[43] = 0x1000004;
        nArray[44] = 1024;
        nArray[45] = 4;
        nArray[46] = 0x1000404;
        nArray[47] = 66564;
        nArray[48] = 0x1010404;
        nArray[49] = 65540;
        nArray[50] = 0x1010000;
        nArray[51] = 0x1000404;
        nArray[52] = 0x1000004;
        nArray[53] = 1028;
        nArray[54] = 66564;
        nArray[55] = 0x1010400;
        nArray[56] = 1028;
        nArray[57] = 0x1000400;
        nArray[58] = 0x1000400;
        nArray[60] = 65540;
        nArray[61] = 66560;
        nArray[63] = 0x1010004;
        SP1 = nArray;
        int[] nArray2 = new int[64];
        nArray2[0] = -2146402272;
        nArray2[1] = -2147450880;
        nArray2[2] = 32768;
        nArray2[3] = 1081376;
        nArray2[4] = 0x100000;
        nArray2[5] = 32;
        nArray2[6] = -2146435040;
        nArray2[7] = -2147450848;
        nArray2[8] = -2147483616;
        nArray2[9] = -2146402272;
        nArray2[10] = -2146402304;
        nArray2[11] = Integer.MIN_VALUE;
        nArray2[12] = -2147450880;
        nArray2[13] = 0x100000;
        nArray2[14] = 32;
        nArray2[15] = -2146435040;
        nArray2[16] = 0x108000;
        nArray2[17] = 0x100020;
        nArray2[18] = -2147450848;
        nArray2[20] = Integer.MIN_VALUE;
        nArray2[21] = 32768;
        nArray2[22] = 1081376;
        nArray2[23] = -2146435072;
        nArray2[24] = 0x100020;
        nArray2[25] = -2147483616;
        nArray2[27] = 0x108000;
        nArray2[28] = 32800;
        nArray2[29] = -2146402304;
        nArray2[30] = -2146435072;
        nArray2[31] = 32800;
        nArray2[33] = 1081376;
        nArray2[34] = -2146435040;
        nArray2[35] = 0x100000;
        nArray2[36] = -2147450848;
        nArray2[37] = -2146435072;
        nArray2[38] = -2146402304;
        nArray2[39] = 32768;
        nArray2[40] = -2146435072;
        nArray2[41] = -2147450880;
        nArray2[42] = 32;
        nArray2[43] = -2146402272;
        nArray2[44] = 1081376;
        nArray2[45] = 32;
        nArray2[46] = 32768;
        nArray2[47] = Integer.MIN_VALUE;
        nArray2[48] = 32800;
        nArray2[49] = -2146402304;
        nArray2[50] = 0x100000;
        nArray2[51] = -2147483616;
        nArray2[52] = 0x100020;
        nArray2[53] = -2147450848;
        nArray2[54] = -2147483616;
        nArray2[55] = 0x100020;
        nArray2[56] = 0x108000;
        nArray2[58] = -2147450880;
        nArray2[59] = 32800;
        nArray2[60] = Integer.MIN_VALUE;
        nArray2[61] = -2146435040;
        nArray2[62] = -2146402272;
        nArray2[63] = 0x108000;
        SP2 = nArray2;
        int[] nArray3 = new int[64];
        nArray3[0] = 520;
        nArray3[1] = 0x8020200;
        nArray3[3] = 0x8020008;
        nArray3[4] = 0x8000200;
        nArray3[6] = 131592;
        nArray3[7] = 0x8000200;
        nArray3[8] = 131080;
        nArray3[9] = 0x8000008;
        nArray3[10] = 0x8000008;
        nArray3[11] = 131072;
        nArray3[12] = 0x8020208;
        nArray3[13] = 131080;
        nArray3[14] = 0x8020000;
        nArray3[15] = 520;
        nArray3[16] = 0x8000000;
        nArray3[17] = 8;
        nArray3[18] = 0x8020200;
        nArray3[19] = 512;
        nArray3[20] = 131584;
        nArray3[21] = 0x8020000;
        nArray3[22] = 0x8020008;
        nArray3[23] = 131592;
        nArray3[24] = 0x8000208;
        nArray3[25] = 131584;
        nArray3[26] = 131072;
        nArray3[27] = 0x8000208;
        nArray3[28] = 8;
        nArray3[29] = 0x8020208;
        nArray3[30] = 512;
        nArray3[31] = 0x8000000;
        nArray3[32] = 0x8020200;
        nArray3[33] = 0x8000000;
        nArray3[34] = 131080;
        nArray3[35] = 520;
        nArray3[36] = 131072;
        nArray3[37] = 0x8020200;
        nArray3[38] = 0x8000200;
        nArray3[40] = 512;
        nArray3[41] = 131080;
        nArray3[42] = 0x8020208;
        nArray3[43] = 0x8000200;
        nArray3[44] = 0x8000008;
        nArray3[45] = 512;
        nArray3[47] = 0x8020008;
        nArray3[48] = 0x8000208;
        nArray3[49] = 131072;
        nArray3[50] = 0x8000000;
        nArray3[51] = 0x8020208;
        nArray3[52] = 8;
        nArray3[53] = 131592;
        nArray3[54] = 131584;
        nArray3[55] = 0x8000008;
        nArray3[56] = 0x8020000;
        nArray3[57] = 0x8000208;
        nArray3[58] = 520;
        nArray3[59] = 0x8020000;
        nArray3[60] = 131592;
        nArray3[61] = 8;
        nArray3[62] = 0x8020008;
        nArray3[63] = 131584;
        SP3 = nArray3;
        int[] nArray4 = new int[64];
        nArray4[0] = 8396801;
        nArray4[1] = 8321;
        nArray4[2] = 8321;
        nArray4[3] = 128;
        nArray4[4] = 0x802080;
        nArray4[5] = 0x800081;
        nArray4[6] = 0x800001;
        nArray4[7] = 8193;
        nArray4[9] = 0x802000;
        nArray4[10] = 0x802000;
        nArray4[11] = 8396929;
        nArray4[12] = 129;
        nArray4[14] = 0x800080;
        nArray4[15] = 0x800001;
        nArray4[16] = 1;
        nArray4[17] = 8192;
        nArray4[18] = 0x800000;
        nArray4[19] = 8396801;
        nArray4[20] = 128;
        nArray4[21] = 0x800000;
        nArray4[22] = 8193;
        nArray4[23] = 8320;
        nArray4[24] = 0x800081;
        nArray4[25] = 1;
        nArray4[26] = 8320;
        nArray4[27] = 0x800080;
        nArray4[28] = 8192;
        nArray4[29] = 0x802080;
        nArray4[30] = 8396929;
        nArray4[31] = 129;
        nArray4[32] = 0x800080;
        nArray4[33] = 0x800001;
        nArray4[34] = 0x802000;
        nArray4[35] = 8396929;
        nArray4[36] = 129;
        nArray4[39] = 0x802000;
        nArray4[40] = 8320;
        nArray4[41] = 0x800080;
        nArray4[42] = 0x800081;
        nArray4[43] = 1;
        nArray4[44] = 8396801;
        nArray4[45] = 8321;
        nArray4[46] = 8321;
        nArray4[47] = 128;
        nArray4[48] = 8396929;
        nArray4[49] = 129;
        nArray4[50] = 1;
        nArray4[51] = 8192;
        nArray4[52] = 0x800001;
        nArray4[53] = 8193;
        nArray4[54] = 0x802080;
        nArray4[55] = 0x800081;
        nArray4[56] = 8193;
        nArray4[57] = 8320;
        nArray4[58] = 0x800000;
        nArray4[59] = 8396801;
        nArray4[60] = 128;
        nArray4[61] = 0x800000;
        nArray4[62] = 8192;
        nArray4[63] = 0x802080;
        SP4 = nArray4;
        int[] nArray5 = new int[64];
        nArray5[0] = 256;
        nArray5[1] = 34078976;
        nArray5[2] = 0x2080000;
        nArray5[3] = 1107296512;
        nArray5[4] = 524288;
        nArray5[5] = 256;
        nArray5[6] = 0x40000000;
        nArray5[7] = 0x2080000;
        nArray5[8] = 1074266368;
        nArray5[9] = 524288;
        nArray5[10] = 0x2000100;
        nArray5[11] = 1074266368;
        nArray5[12] = 1107296512;
        nArray5[13] = 1107820544;
        nArray5[14] = 524544;
        nArray5[15] = 0x40000000;
        nArray5[16] = 0x2000000;
        nArray5[17] = 0x40080000;
        nArray5[18] = 0x40080000;
        nArray5[20] = 0x40000100;
        nArray5[21] = 1107820800;
        nArray5[22] = 1107820800;
        nArray5[23] = 0x2000100;
        nArray5[24] = 1107820544;
        nArray5[25] = 0x40000100;
        nArray5[27] = 0x42000000;
        nArray5[28] = 34078976;
        nArray5[29] = 0x2000000;
        nArray5[30] = 0x42000000;
        nArray5[31] = 524544;
        nArray5[32] = 524288;
        nArray5[33] = 1107296512;
        nArray5[34] = 256;
        nArray5[35] = 0x2000000;
        nArray5[36] = 0x40000000;
        nArray5[37] = 0x2080000;
        nArray5[38] = 1107296512;
        nArray5[39] = 1074266368;
        nArray5[40] = 0x2000100;
        nArray5[41] = 0x40000000;
        nArray5[42] = 1107820544;
        nArray5[43] = 34078976;
        nArray5[44] = 1074266368;
        nArray5[45] = 256;
        nArray5[46] = 0x2000000;
        nArray5[47] = 1107820544;
        nArray5[48] = 1107820800;
        nArray5[49] = 524544;
        nArray5[50] = 0x42000000;
        nArray5[51] = 1107820800;
        nArray5[52] = 0x2080000;
        nArray5[54] = 0x40080000;
        nArray5[55] = 0x42000000;
        nArray5[56] = 524544;
        nArray5[57] = 0x2000100;
        nArray5[58] = 0x40000100;
        nArray5[59] = 524288;
        nArray5[61] = 0x40080000;
        nArray5[62] = 34078976;
        nArray5[63] = 0x40000100;
        SP5 = nArray5;
        int[] nArray6 = new int[64];
        nArray6[0] = 0x20000010;
        nArray6[1] = 0x20400000;
        nArray6[2] = 16384;
        nArray6[3] = 541081616;
        nArray6[4] = 0x20400000;
        nArray6[5] = 16;
        nArray6[6] = 541081616;
        nArray6[7] = 0x400000;
        nArray6[8] = 0x20004000;
        nArray6[9] = 0x404010;
        nArray6[10] = 0x400000;
        nArray6[11] = 0x20000010;
        nArray6[12] = 0x400010;
        nArray6[13] = 0x20004000;
        nArray6[14] = 0x20000000;
        nArray6[15] = 16400;
        nArray6[17] = 0x400010;
        nArray6[18] = 536887312;
        nArray6[19] = 16384;
        nArray6[20] = 0x404000;
        nArray6[21] = 536887312;
        nArray6[22] = 16;
        nArray6[23] = 541065232;
        nArray6[24] = 541065232;
        nArray6[26] = 0x404010;
        nArray6[27] = 0x20404000;
        nArray6[28] = 16400;
        nArray6[29] = 0x404000;
        nArray6[30] = 0x20404000;
        nArray6[31] = 0x20000000;
        nArray6[32] = 0x20004000;
        nArray6[33] = 16;
        nArray6[34] = 541065232;
        nArray6[35] = 0x404000;
        nArray6[36] = 541081616;
        nArray6[37] = 0x400000;
        nArray6[38] = 16400;
        nArray6[39] = 0x20000010;
        nArray6[40] = 0x400000;
        nArray6[41] = 0x20004000;
        nArray6[42] = 0x20000000;
        nArray6[43] = 16400;
        nArray6[44] = 0x20000010;
        nArray6[45] = 541081616;
        nArray6[46] = 0x404000;
        nArray6[47] = 0x20400000;
        nArray6[48] = 0x404010;
        nArray6[49] = 0x20404000;
        nArray6[51] = 541065232;
        nArray6[52] = 16;
        nArray6[53] = 16384;
        nArray6[54] = 0x20400000;
        nArray6[55] = 0x404010;
        nArray6[56] = 16384;
        nArray6[57] = 0x400010;
        nArray6[58] = 536887312;
        nArray6[60] = 0x20404000;
        nArray6[61] = 0x20000000;
        nArray6[62] = 0x400010;
        nArray6[63] = 536887312;
        SP6 = nArray6;
        int[] nArray7 = new int[64];
        nArray7[0] = 0x200000;
        nArray7[1] = 0x4200002;
        nArray7[2] = 67110914;
        nArray7[4] = 2048;
        nArray7[5] = 67110914;
        nArray7[6] = 0x200802;
        nArray7[7] = 69208064;
        nArray7[8] = 69208066;
        nArray7[9] = 0x200000;
        nArray7[11] = 0x4000002;
        nArray7[12] = 2;
        nArray7[13] = 0x4000000;
        nArray7[14] = 0x4200002;
        nArray7[15] = 2050;
        nArray7[16] = 0x4000800;
        nArray7[17] = 0x200802;
        nArray7[18] = 0x200002;
        nArray7[19] = 0x4000800;
        nArray7[20] = 0x4000002;
        nArray7[21] = 0x4200000;
        nArray7[22] = 69208064;
        nArray7[23] = 0x200002;
        nArray7[24] = 0x4200000;
        nArray7[25] = 2048;
        nArray7[26] = 2050;
        nArray7[27] = 69208066;
        nArray7[28] = 0x200800;
        nArray7[29] = 2;
        nArray7[30] = 0x4000000;
        nArray7[31] = 0x200800;
        nArray7[32] = 0x4000000;
        nArray7[33] = 0x200800;
        nArray7[34] = 0x200000;
        nArray7[35] = 67110914;
        nArray7[36] = 67110914;
        nArray7[37] = 0x4200002;
        nArray7[38] = 0x4200002;
        nArray7[39] = 2;
        nArray7[40] = 0x200002;
        nArray7[41] = 0x4000000;
        nArray7[42] = 0x4000800;
        nArray7[43] = 0x200000;
        nArray7[44] = 69208064;
        nArray7[45] = 2050;
        nArray7[46] = 0x200802;
        nArray7[47] = 69208064;
        nArray7[48] = 2050;
        nArray7[49] = 0x4000002;
        nArray7[50] = 69208066;
        nArray7[51] = 0x4200000;
        nArray7[52] = 0x200800;
        nArray7[54] = 2;
        nArray7[55] = 69208066;
        nArray7[57] = 0x200802;
        nArray7[58] = 0x4200000;
        nArray7[59] = 2048;
        nArray7[60] = 0x4000002;
        nArray7[61] = 0x4000800;
        nArray7[62] = 2048;
        nArray7[63] = 0x200002;
        SP7 = nArray7;
        int[] nArray8 = new int[64];
        nArray8[0] = 0x10001040;
        nArray8[1] = 4096;
        nArray8[2] = 262144;
        nArray8[3] = 0x10041040;
        nArray8[4] = 0x10000000;
        nArray8[5] = 0x10001040;
        nArray8[6] = 64;
        nArray8[7] = 0x10000000;
        nArray8[8] = 262208;
        nArray8[9] = 0x10040000;
        nArray8[10] = 0x10041040;
        nArray8[11] = 266240;
        nArray8[12] = 0x10041000;
        nArray8[13] = 266304;
        nArray8[14] = 4096;
        nArray8[15] = 64;
        nArray8[16] = 0x10040000;
        nArray8[17] = 0x10000040;
        nArray8[18] = 0x10001000;
        nArray8[19] = 4160;
        nArray8[20] = 266240;
        nArray8[21] = 262208;
        nArray8[22] = 0x10040040;
        nArray8[23] = 0x10041000;
        nArray8[24] = 4160;
        nArray8[27] = 0x10040040;
        nArray8[28] = 0x10000040;
        nArray8[29] = 0x10001000;
        nArray8[30] = 266304;
        nArray8[31] = 262144;
        nArray8[32] = 266304;
        nArray8[33] = 262144;
        nArray8[34] = 0x10041000;
        nArray8[35] = 4096;
        nArray8[36] = 64;
        nArray8[37] = 0x10040040;
        nArray8[38] = 4096;
        nArray8[39] = 266304;
        nArray8[40] = 0x10001000;
        nArray8[41] = 64;
        nArray8[42] = 0x10000040;
        nArray8[43] = 0x10040000;
        nArray8[44] = 0x10040040;
        nArray8[45] = 0x10000000;
        nArray8[46] = 262144;
        nArray8[47] = 0x10001040;
        nArray8[49] = 0x10041040;
        nArray8[50] = 262208;
        nArray8[51] = 0x10000040;
        nArray8[52] = 0x10040000;
        nArray8[53] = 0x10001000;
        nArray8[54] = 0x10001040;
        nArray8[56] = 0x10041040;
        nArray8[57] = 266240;
        nArray8[58] = 266240;
        nArray8[59] = 4160;
        nArray8[60] = 4160;
        nArray8[61] = 262208;
        nArray8[62] = 0x10000000;
        nArray8[63] = 0x10041000;
        SP8 = nArray8;
        byte[] byArray = new byte[256];
        byArray[0] = 8;
        byArray[1] = 1;
        byArray[3] = 8;
        byArray[5] = 8;
        byArray[6] = 8;
        byArray[9] = 8;
        byArray[10] = 8;
        byArray[12] = 8;
        byArray[14] = 2;
        byArray[15] = 8;
        byArray[17] = 8;
        byArray[18] = 8;
        byArray[20] = 8;
        byArray[23] = 8;
        byArray[24] = 8;
        byArray[27] = 8;
        byArray[29] = 8;
        byArray[30] = 8;
        byArray[31] = 3;
        byArray[33] = 8;
        byArray[34] = 8;
        byArray[36] = 8;
        byArray[39] = 8;
        byArray[40] = 8;
        byArray[43] = 8;
        byArray[45] = 8;
        byArray[46] = 8;
        byArray[48] = 8;
        byArray[51] = 8;
        byArray[53] = 8;
        byArray[54] = 8;
        byArray[57] = 8;
        byArray[58] = 8;
        byArray[60] = 8;
        byArray[63] = 8;
        byArray[65] = 8;
        byArray[66] = 8;
        byArray[68] = 8;
        byArray[71] = 8;
        byArray[72] = 8;
        byArray[75] = 8;
        byArray[77] = 8;
        byArray[78] = 8;
        byArray[80] = 8;
        byArray[83] = 8;
        byArray[85] = 8;
        byArray[86] = 8;
        byArray[89] = 8;
        byArray[90] = 8;
        byArray[92] = 8;
        byArray[95] = 8;
        byArray[96] = 8;
        byArray[99] = 8;
        byArray[101] = 8;
        byArray[102] = 8;
        byArray[105] = 8;
        byArray[106] = 8;
        byArray[108] = 8;
        byArray[111] = 8;
        byArray[113] = 8;
        byArray[114] = 8;
        byArray[116] = 8;
        byArray[119] = 8;
        byArray[120] = 8;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[126] = 8;
        byArray[129] = 8;
        byArray[130] = 8;
        byArray[132] = 8;
        byArray[135] = 8;
        byArray[136] = 8;
        byArray[139] = 8;
        byArray[141] = 8;
        byArray[142] = 8;
        byArray[144] = 8;
        byArray[147] = 8;
        byArray[149] = 8;
        byArray[150] = 8;
        byArray[153] = 8;
        byArray[154] = 8;
        byArray[156] = 8;
        byArray[159] = 8;
        byArray[160] = 8;
        byArray[163] = 8;
        byArray[165] = 8;
        byArray[166] = 8;
        byArray[169] = 8;
        byArray[170] = 8;
        byArray[172] = 8;
        byArray[175] = 8;
        byArray[177] = 8;
        byArray[178] = 8;
        byArray[180] = 8;
        byArray[183] = 8;
        byArray[184] = 8;
        byArray[187] = 8;
        byArray[189] = 8;
        byArray[190] = 8;
        byArray[192] = 8;
        byArray[195] = 8;
        byArray[197] = 8;
        byArray[198] = 8;
        byArray[201] = 8;
        byArray[202] = 8;
        byArray[204] = 8;
        byArray[207] = 8;
        byArray[209] = 8;
        byArray[210] = 8;
        byArray[212] = 8;
        byArray[215] = 8;
        byArray[216] = 8;
        byArray[219] = 8;
        byArray[221] = 8;
        byArray[222] = 8;
        byArray[224] = 4;
        byArray[225] = 8;
        byArray[226] = 8;
        byArray[228] = 8;
        byArray[231] = 8;
        byArray[232] = 8;
        byArray[235] = 8;
        byArray[237] = 8;
        byArray[238] = 8;
        byArray[240] = 8;
        byArray[241] = 5;
        byArray[243] = 8;
        byArray[245] = 8;
        byArray[246] = 8;
        byArray[249] = 8;
        byArray[250] = 8;
        byArray[252] = 8;
        byArray[254] = 6;
        byArray[255] = 8;
        PARITY = byArray;
        ROTARS = new byte[]{1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28};
        byte[] byArray2 = new byte[56];
        byArray2[0] = 56;
        byArray2[1] = 48;
        byArray2[2] = 40;
        byArray2[3] = 32;
        byArray2[4] = 24;
        byArray2[5] = 16;
        byArray2[6] = 8;
        byArray2[8] = 57;
        byArray2[9] = 49;
        byArray2[10] = 41;
        byArray2[11] = 33;
        byArray2[12] = 25;
        byArray2[13] = 17;
        byArray2[14] = 9;
        byArray2[15] = 1;
        byArray2[16] = 58;
        byArray2[17] = 50;
        byArray2[18] = 42;
        byArray2[19] = 34;
        byArray2[20] = 26;
        byArray2[21] = 18;
        byArray2[22] = 10;
        byArray2[23] = 2;
        byArray2[24] = 59;
        byArray2[25] = 51;
        byArray2[26] = 43;
        byArray2[27] = 35;
        byArray2[28] = 62;
        byArray2[29] = 54;
        byArray2[30] = 46;
        byArray2[31] = 38;
        byArray2[32] = 30;
        byArray2[33] = 22;
        byArray2[34] = 14;
        byArray2[35] = 6;
        byArray2[36] = 61;
        byArray2[37] = 53;
        byArray2[38] = 45;
        byArray2[39] = 37;
        byArray2[40] = 29;
        byArray2[41] = 21;
        byArray2[42] = 13;
        byArray2[43] = 5;
        byArray2[44] = 60;
        byArray2[45] = 52;
        byArray2[46] = 44;
        byArray2[47] = 36;
        byArray2[48] = 28;
        byArray2[49] = 20;
        byArray2[50] = 12;
        byArray2[51] = 4;
        byArray2[52] = 27;
        byArray2[53] = 19;
        byArray2[54] = 11;
        byArray2[55] = 3;
        PC1 = byArray2;
        byte[] byArray3 = new byte[48];
        byArray3[0] = 13;
        byArray3[1] = 16;
        byArray3[2] = 10;
        byArray3[3] = 23;
        byArray3[5] = 4;
        byArray3[6] = 2;
        byArray3[7] = 27;
        byArray3[8] = 14;
        byArray3[9] = 5;
        byArray3[10] = 20;
        byArray3[11] = 9;
        byArray3[12] = 22;
        byArray3[13] = 18;
        byArray3[14] = 11;
        byArray3[15] = 3;
        byArray3[16] = 25;
        byArray3[17] = 7;
        byArray3[18] = 15;
        byArray3[19] = 6;
        byArray3[20] = 26;
        byArray3[21] = 19;
        byArray3[22] = 12;
        byArray3[23] = 1;
        byArray3[24] = 40;
        byArray3[25] = 51;
        byArray3[26] = 30;
        byArray3[27] = 36;
        byArray3[28] = 46;
        byArray3[29] = 54;
        byArray3[30] = 29;
        byArray3[31] = 39;
        byArray3[32] = 50;
        byArray3[33] = 44;
        byArray3[34] = 32;
        byArray3[35] = 47;
        byArray3[36] = 43;
        byArray3[37] = 48;
        byArray3[38] = 38;
        byArray3[39] = 55;
        byArray3[40] = 33;
        byArray3[41] = 52;
        byArray3[42] = 45;
        byArray3[43] = 41;
        byArray3[44] = 49;
        byArray3[45] = 35;
        byArray3[46] = 28;
        byArray3[47] = 31;
        PC2 = byArray3;
    }

    public DESacc() {
    }

    public DESacc(byte[] key, byte[] iv) {
        this.init(key, iv);
    }

    public static void adjustParity(byte[] kb, int offset) {
        int i = offset;
        while (i < 8) {
            int n = i;
            kb[n] = (byte)(kb[n] ^ (PARITY[kb[i] & 0xFF] == 8 ? (byte)1 : 0));
            ++i;
        }
    }

    public static boolean isParityAdjusted(byte[] kb, int offset) {
        int w = -2004318072;
        int n = PARITY[kb[offset + 0] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 1] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 2] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 3] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 4] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 5] & 0xFF];
        n <<= 4;
        n |= PARITY[kb[offset + 6] & 0xFF];
        n <<= 4;
        return ((n |= PARITY[kb[offset + 7] & 0xFF]) & w) == 0;
    }

    public void init(byte[] key, byte[] iv) {
        this.K = this.makeKey(key, 8);
        this.iv = iv;
    }

    public int currentBlockSize() {
        return 8;
    }

    private static void desFunc(byte[] in, int i, byte[] out, int o, int[] key) {
        int left = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i++] & 0xFF;
        int right = (in[i++] & 0xFF) << 24 | (in[i++] & 0xFF) << 16 | (in[i++] & 0xFF) << 8 | in[i] & 0xFF;
        int work = (left >>> 4 ^ right) & 0xF0F0F0F;
        left ^= work << 4;
        right ^= work;
        work = (left >>> 16 ^ right) & 0xFFFF;
        left ^= work << 16;
        right ^= work;
        work = (right >>> 2 ^ left) & 0x33333333;
        right ^= work << 2;
        left ^= work;
        work = (right >>> 8 ^ left) & 0xFF00FF;
        right ^= work << 8;
        left ^= work;
        right = (right << 1 | right >>> 31 & 1) & 0xFFFFFFFF;
        work = (left ^ right) & 0xAAAAAAAA;
        left ^= work;
        right ^= work;
        left = (left << 1 | left >>> 31 & 1) & 0xFFFFFFFF;
        int k = 0;
        int round = 0;
        while (round < 8) {
            work = right >>> 4 | right << 28;
            int t = SP7[(work ^= key[k++]) & 0x3F];
            t |= SP5[(work >>>= 8) & 0x3F];
            t |= SP3[(work >>>= 8) & 0x3F];
            t |= SP1[(work >>>= 8) & 0x3F];
            work = right ^ key[k++];
            t |= SP8[work & 0x3F];
            t |= SP6[(work >>>= 8) & 0x3F];
            t |= SP4[(work >>>= 8) & 0x3F];
            work = (left ^= (t |= SP2[(work >>>= 8) & 0x3F])) >>> 4 | left << 28;
            t = SP7[(work ^= key[k++]) & 0x3F];
            t |= SP5[(work >>>= 8) & 0x3F];
            t |= SP3[(work >>>= 8) & 0x3F];
            t |= SP1[(work >>>= 8) & 0x3F];
            work = left ^ key[k++];
            t |= SP8[work & 0x3F];
            t |= SP6[(work >>>= 8) & 0x3F];
            t |= SP4[(work >>>= 8) & 0x3F];
            right ^= (t |= SP2[(work >>>= 8) & 0x3F]);
            ++round;
        }
        right = right << 31 | right >>> 1;
        work = (left ^ right) & 0xAAAAAAAA;
        left ^= work;
        right ^= work;
        left = left << 31 | left >>> 1;
        work = (left >>> 8 ^ right) & 0xFF00FF;
        left ^= work << 8;
        right ^= work;
        work = (left >>> 2 ^ right) & 0x33333333;
        left ^= work << 2;
        right ^= work;
        work = (right >>> 16 ^ left) & 0xFFFF;
        right ^= work << 16;
        left ^= work;
        work = (right >>> 4 ^ left) & 0xF0F0F0F;
        out[o++] = (byte)((right ^= work << 4) >>> 24);
        out[o++] = (byte)(right >>> 16);
        out[o++] = (byte)(right >>> 8);
        out[o++] = (byte)right;
        out[o++] = (byte)((left ^= work) >>> 24);
        out[o++] = (byte)(left >>> 16);
        out[o++] = (byte)(left >>> 8);
        out[o] = (byte)left;
    }

    public void encrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        DESacc.desFunc(in, i, out, o, ((Context)K).ek);
    }

    public void decrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        DESacc.desFunc(in, i, out, o, ((Context)K).dk);
    }

    public Object clone() {
        System.err.println("#################################### DESacc.clone()");
        DESacc clone = new DESacc();
        clone.K = new Context();
        int i = 0;
        while (i < ((Context)this.K).ek.length) {
            ((Context)clone.K).ek[i] = ((Context)this.K).ek[i];
            ((Context)clone.K).dk[i] = ((Context)this.K).dk[i];
            ++i;
        }
        i = 0;
        while (i < this.iv.length) {
            clone.iv[i] = this.iv[i];
            ++i;
        }
        return clone;
    }

    public Object makeKey(byte[] kb, int bs) {
        int l;
        if (kb == null || kb.length != 8) {
            throw new IllegalArgumentException("DES keys must be 8 bytes long");
        }
        long pc1m = 0L;
        long pcr = 0L;
        int i = 0;
        while (i < 56) {
            l = PC1[i];
            pc1m |= (kb[l >>> 3] & 128 >>> (l & 7)) != 0 ? 1L << 55 - i : 0L;
            ++i;
        }
        Context ctx = new Context();
        i = 0;
        while (i < 16) {
            pcr = 0L;
            int m = i << 1;
            int n = m + 1;
            int j = 0;
            while (j < 28) {
                l = j + ROTARS[i];
                pcr = l < 28 ? (pcr |= (pc1m & 1L << 55 - l) != 0L ? 1L << 55 - j : 0L) : (pcr |= (pc1m & 1L << 55 - (l - 28)) != 0L ? 1L << 55 - j : 0L);
                ++j;
            }
            j = 28;
            while (j < 56) {
                l = j + ROTARS[i];
                pcr = l < 56 ? (pcr |= (pc1m & 1L << 55 - l) != 0L ? 1L << 55 - j : 0L) : (pcr |= (pc1m & 1L << 55 - (l - 28)) != 0L ? 1L << 55 - j : 0L);
                ++j;
            }
            j = 0;
            while (j < 24) {
                if ((pcr & 1L << 55 - PC2[j]) != 0L) {
                    int n2 = m;
                    ctx.ek[n2] = ctx.ek[n2] | 1 << 23 - j;
                }
                if ((pcr & 1L << 55 - PC2[j + 24]) != 0L) {
                    int n3 = n;
                    ctx.ek[n3] = ctx.ek[n3] | 1 << 23 - j;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            ctx.dk[30 - i] = ctx.ek[i];
            ctx.dk[31 - i] = ctx.ek[i + 1];
            i += 2;
        }
        i = 0;
        while (i < 32) {
            int x = ctx.ek[i];
            int y = ctx.ek[i + 1];
            ctx.ek[i] = (x & 0xFC0000) << 6 | (x & 0xFC0) << 10 | (y & 0xFC0000) >>> 10 | (y & 0xFC0) >>> 6;
            ctx.ek[i + 1] = (x & 0x3F000) << 12 | (x & 0x3F) << 16 | (y & 0x3F000) >>> 4 | y & 0x3F;
            x = ctx.dk[i];
            y = ctx.dk[i + 1];
            ctx.dk[i] = (x & 0xFC0000) << 6 | (x & 0xFC0) << 10 | (y & 0xFC0000) >>> 10 | (y & 0xFC0) >>> 6;
            ctx.dk[i + 1] = (x & 0x3F000) << 12 | (x & 0x3F) << 16 | (y & 0x3F000) >>> 4 | y & 0x3F;
            i += 2;
        }
        return ctx;
    }

    public byte[] encryptCBC(byte[] plainText, boolean padding) {
        int dLen = plainText.length;
        int fBlock_no = padding ? dLen >>> 3 : dLen - 1 >>> 3;
        int fBlock_idx = fBlock_no << 3;
        int blockCount = fBlock_no + 1;
        int tLen = blockCount << 3;
        byte[] input = new byte[tLen];
        byte[] output = new byte[tLen];
        System.arraycopy(plainText, 0, input, 0, dLen);
        if (padding) {
            int padLen = tLen - dLen;
            byte padByte = (byte)padLen;
            int ti = dLen;
            while (ti < tLen) {
                input[ti] = padByte;
                ++ti;
            }
        }
        int bi = 8;
        while (--bi >= 0) {
            int n = bi;
            input[n] = (byte)(input[n] ^ this.iv[bi]);
        }
        int bn = 0;
        while (bn < fBlock_no) {
            int ti = bn << 3;
            int ti_next = ti + 8;
            DESacc.desFunc(input, ti, output, ti, ((Context)this.K).ek);
            int i = 8;
            while (--i >= 0) {
                int n = ti_next + i;
                input[n] = (byte)(input[n] ^ output[ti + i]);
            }
            ++bn;
        }
        DESacc.desFunc(input, fBlock_idx, output, fBlock_idx, ((Context)this.K).ek);
        int i = 8;
        while (--i >= 0) {
            this.iv[i] = output[fBlock_idx + i];
        }
        return output;
    }

    public byte[] decryptCBC(byte[] cipherText, boolean padding) {
        int tLen = cipherText.length;
        int blockCount = tLen >>> 3;
        byte[] input = cipherText;
        byte[] output = new byte[tLen];
        DESacc.desFunc(input, 0, output, 0, ((Context)this.K).dk);
        int bi = 8;
        while (--bi >= 0) {
            int n = bi;
            output[n] = (byte)(output[n] ^ this.iv[bi]);
        }
        int bn = 1;
        while (bn < blockCount) {
            int ti = bn << 3;
            int ti_prev = ti - 8;
            DESacc.desFunc(input, ti, output, ti, ((Context)this.K).dk);
            int i = 8;
            while (--i >= 0) {
                int n = ti + i;
                output[n] = (byte)(output[n] ^ input[ti_prev + i]);
            }
            ++bn;
        }
        int fBlock_idx = tLen - 8;
        int i = 8;
        while (--i >= 0) {
            this.iv[i] = input[fBlock_idx + i];
        }
        if (padding) {
            int padByte = output[tLen - 1] & 0xFF;
            byte[] result = new byte[tLen - padByte];
            System.arraycopy(output, 0, result, 0, result.length);
            return result;
        }
        return output;
    }

    public void decryptCBC2(byte[] cipherText) {
        int tLen = cipherText.length;
        int blockCount = tLen >>> 3;
        byte[] input = cipherText;
        byte[] aBlock = new byte[8];
        int fBlock_idx = tLen - 8;
        int bi = 8;
        while (--bi >= 0) {
            this.fBlock[bi] = input[fBlock_idx + bi];
        }
        int bn = blockCount;
        while (--bn > 0) {
            int ti = bn << 3;
            int ti_prev = ti - 8;
            DESacc.desFunc(input, ti, aBlock, 0, ((Context)this.K).dk);
            int bi2 = 8;
            while (--bi2 >= 0) {
                input[ti + bi2] = (byte)(aBlock[bi2] ^ input[ti_prev + bi2]);
            }
        }
        DESacc.desFunc(input, 0, aBlock, 0, ((Context)this.K).dk);
        bi = 8;
        while (--bi >= 0) {
            input[bi] = (byte)(aBlock[bi] ^ this.iv[bi]);
            this.iv[bi] = this.fBlock[bi];
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] data = args[0].getBytes();
        byte[] key = "12345678".getBytes();
        byte[] iv = new byte[8];
        DESacc des = new DESacc(key, (byte[])iv.clone());
        byte[] cipherText = des.encryptCBC(data, true);
        System.out.println(">> cipher : " + Util.hexDump(cipherText));
        DESacc des2 = new DESacc(key, iv);
        byte[] result = des2.decryptCBC(cipherText, false);
        System.out.println(">> result : " + Util.hexDump(result));
    }

    final class Context {
        private static final int EXPANDED_KEY_SIZE = 32;
        int[] ek = new int[32];
        int[] dk = new int[32];

        Context() {
        }

        byte[] getEncryptionKeyBytes() {
            return this.toByteArray(this.ek);
        }

        byte[] getDecryptionKeyBytes() {
            return this.toByteArray(this.dk);
        }

        byte[] toByteArray(int[] k) {
            byte[] result = new byte[4 * k.length];
            int i = 0;
            int j = 0;
            while (i < k.length) {
                result[j++] = (byte)(k[i] >>> 24);
                result[j++] = (byte)(k[i] >>> 16);
                result[j++] = (byte)(k[i] >>> 8);
                result[j++] = (byte)k[i];
                ++i;
            }
            return result;
        }
    }
}

