/*
  KonfPlugin.h

  Konfabulator

  Created by Sam Magnuson on 2008-10-20 14:54:59 PDT
  Copyright (c) 2008 Yahoo! Inc. All rights reserved.
*/

#ifndef __KONFPLUGIN_H__
#define __KONFPLUGIN_H__

typedef enum
{
	KonfInterfaceVersion_1_0 = 1,
	KonfInterfaceVersion_2_0 = 2,

	KonfInterfaceVersion_Current = KonfInterfaceVersion_2_0
} KonfInterfaceVersion;


// key codes
typedef enum KonfPluginKeyInput
{
	KonfPluginKeyInput_Up       = 1,
	KonfPluginKeyInput_Down     = 2,
	KonfPluginKeyInput_Left     = 3,
	KonfPluginKeyInput_Right    = 4,
	KonfPluginKeyInput_F1		= 5,
	KonfPluginKeyInput_F2		= 6,
	KonfPluginKeyInput_F3		= 7,
	KonfPluginKeyInput_F4		= 8,
	KonfPluginKeyInput_F5		= 9,
	KonfPluginKeyInput_F6		= 10,
	KonfPluginKeyInput_F7		= 11,
	KonfPluginKeyInput_F8		= 12,
	KonfPluginKeyInput_F9		= 13,
	KonfPluginKeyInput_F10		= 14,
	KonfPluginKeyInput_F11		= 15,
	KonfPluginKeyInput_F12		= 16,
	KonfPluginKeyInput_F13		= 17,
	KonfPluginKeyInput_F14		= 18,
	KonfPluginKeyInput_F15		= 19,
	KonfPluginKeyInput_F16		= 20,
	KonfPluginKeyInput_Delete	= 21,
	KonfPluginKeyInput_Home		= 22,
	KonfPluginKeyInput_End		= 23,
	KonfPluginKeyInput_PageUp   = 24,
	KonfPluginKeyInput_PageDown = 25,
	KonfPluginKeyInput_Help     = 26,
	KonfPluginKeyInput_Pause    = 31,
	KonfPluginKeyInput_Return   = 32,
	KonfPluginKeyInput_Select   = KonfPluginKeyInput_Return, // synonym
	KonfPluginKeyInput_Enter    = 33,
	KonfPluginKeyInput_Backspace= 34,
	KonfPluginKeyInpute_Space	= 35,
	KonfPluginKeyInput_Tab		= 36,
	KonfPluginKeyInput_Escape   = 37,
	KonfPluginKeyInput_0        = 38,
	KonfPluginKeyInput_1        = 39,
	KonfPluginKeyInput_2        = 40,
	KonfPluginKeyInput_3        = 41,
	KonfPluginKeyInput_4        = 42,
	KonfPluginKeyInput_5        = 43,
	KonfPluginKeyInput_6        = 44,
	KonfPluginKeyInput_7        = 45,
	KonfPluginKeyInput_8        = 46,
	KonfPluginKeyInput_9        = 47,
	KonfPluginKeyInput_A        = 48,
	KonfPluginKeyInput_B        = 49,
	KonfPluginKeyInput_C        = 50,
	KonfPluginKeyInput_D        = 51,
	KonfPluginKeyInput_E        = 52,
	KonfPluginKeyInput_F        = 53,
	KonfPluginKeyInput_G        = 54,
	KonfPluginKeyInput_H        = 55,
	KonfPluginKeyInput_I        = 56,
	KonfPluginKeyInput_J        = 57,
	KonfPluginKeyInput_K        = 58,
	KonfPluginKeyInput_L        = 59,
	KonfPluginKeyInput_M        = 60,
	KonfPluginKeyInput_N        = 61,
	KonfPluginKeyInput_O        = 62,
	KonfPluginKeyInput_P        = 63,
	KonfPluginKeyInput_Q        = 64,
	KonfPluginKeyInput_R        = 65,
	KonfPluginKeyInput_S        = 66,
	KonfPluginKeyInput_T        = 67,
	KonfPluginKeyInput_U        = 68,
	KonfPluginKeyInput_V        = 69,
	KonfPluginKeyInput_W        = 70,
	KonfPluginKeyInput_X        = 71,
	KonfPluginKeyInput_Y        = 72,
	KonfPluginKeyInput_Z        = 73,
	KonfPluginKeyInput_Mute     = 85,
	KonfPluginKeyInput_VolDown  = 86,
	KonfPluginKeyInput_VolUp    = 87,
	KonfPluginKeyInput_Stop     = 90,
	KonfPluginKeyInput_ChUp     = 91,
	KonfPluginKeyInput_ChDown   = 92,
	KonfPluginKeyInput_Play     = 93,
	KonfPluginKeyInput_Record   = 94,
	KonfPluginKeyInput_Rewind   = 96,
	KonfPluginKeyInput_Guide    = 98,
	KonfPluginKeyInput_Info     = 99,
	KonfPluginKeyInput_Power    = 100,
	KonfPluginKeyInput_FastFwd  = 101,
	KonfPluginKeyInput_Source   = 102,
	KonfPluginKeyInput_Menu     = 103,
	KonfPluginKeyInput_SkipFwd  = 104,
	KonfPluginKeyInput_SkipRew  = 105,
	KonfPluginKeyInput_Pip      = 106,
	KonfPluginKeyInput_Red      = 107,
	KonfPluginKeyInput_Green    = 108,
	KonfPluginKeyInput_Yellow   = 109,
	KonfPluginKeyInput_Blue     = 110,
	KonfPluginKeyInput_Back     = 111,
	KonfPluginKeyInput_Pound    = 112,
	KonfPluginKeyInput_Star     = 113,

	/* special values */
	KonfPluginKeyInput_RotateClockWise1        = 200,
	KonfPluginKeyInput_RotateClockWise2        = 201,
	KonfPluginKeyInput_RotateClockWise3        = 202,
	KonfPluginKeyInput_RotateClockWise4        = 203,
	KonfPluginKeyInput_RotateClockWise5        = 204,
	KonfPluginKeyInput_RotateClockWise6        = 205,
	KonfPluginKeyInput_RotateClockWise7        = 206,
	KonfPluginKeyInput_RotateCounterClockWise1 = 210,
	KonfPluginKeyInput_RotateCounterClockWise2 = 211,
	KonfPluginKeyInput_RotateCounterClockWise3 = 212,
	KonfPluginKeyInput_RotateCounterClockWise4 = 213,
	KonfPluginKeyInput_RotateCounterClockWise5 = 214,
	KonfPluginKeyInput_RotateCounterClockWise6 = 215,
	KonfPluginKeyInput_RotateCounterClockWise7 = 216,

	/* unknown */
	KonfPluginKeyInput_Unknown = 0
} KonfPluginKeyInput;

// key modifiers
typedef enum
{
	KonfPluginKeyModifier_None     = 0x00,
	KonfPluginKeyModifier_Alt      = 0x01,
	KonfPluginKeyModifier_Ctrl     = 0x02,
	KonfPluginKeyModifier_Command  = 0x04,
	KonfPluginKeyModifier_Meta     = 0x08,
	KonfPluginKeyModifier_Shift    = 0x10,
	KonfPluginKeyModifier_CapsLock = 0x20,
	KonfPluginKeyModifier_NumLock  = 0x40,
} KonfPluginKeyModifier;

// key up/down states
typedef enum
{
	KonfPluginKeyState_None     = 0x0,
	KonfPluginKeyState_KeyUp    = 0x1,
	KonfPluginKeyState_KeyDown  = 0x2
} KonfPluginKeyState;

// Defines a key event,
typedef struct
{
	KonfPluginKeyInput     keycode;      // key input that generated event
	KonfPluginKeyModifier  modifiers;    // key modifiers
	unsigned short*        utf16_buffer; // UTF16 input
	int                    utf16_length; // number of UTF16 characters
	KonfPluginKeyState     keystate;     // key up/down state
} KonfPluginInputEvent;

// See struct KonfPluginInterface (following) for usage.

typedef enum
{
	KonfAppInterfaceEvent_Show                = 0,
	KonfAppInterfaceEvent_Hide                = 1,
	KonfAppInterfaceEvent_Terminate           = 2,
	KonfAppInterfaceEvent_SDLQuit             = 3,
	KonfAppInterfaceEvent_SDLQuit_Exit        = 4,
	KonfAppInterfaceEvent_SetLowPriority      = 5,
	KonfAppInterfaceEvent_SetNormalPriority   = 6,
	KonfAppInterfaceEvent_Hide_Exit           = 7,
	KonfAppInterfaceEvent_Suspend             = 8,
	KonfAppInterfaceEvent_Resume              = 9
} KonfPluginInterfaceEvent;

typedef void (*KonfApp_SendEventCompletion)(KonfPluginInterfaceEvent);
typedef void (*KonfPlugin_ProcessKeyEvent)(KonfPluginInputEvent*);
typedef void (*KonfPlugin_SendEvent)(KonfPluginInterfaceEvent, KonfApp_SendEventCompletion);
typedef void (*KonfPlugin_SetConfig)(const char *inKey, const char *inValue);

typedef struct
{
	KonfPlugin_SendEvent       sendEvent;
	KonfPlugin_SetConfig       setConfig;
	KonfInterfaceVersion       version;
	KonfPlugin_ProcessKeyEvent processKeyEvent;
} KonfPluginInterface;

typedef enum
{
	KonfAppInterfaceState_OutputTV       = 0x001,	/*TV Video and TV Audio*/
	KonfAppInterfaceState_InputChannel   = 0x010,	/*Number Key*/
	KonfAppInterfaceState_InputSound     = 0x020,	/*TV Volume and TV mute*/
	KonfAppInterfaceState_InputTransport = 0x040,	/*Playback control function*/
	KonfAppInterfaceState_OutputOSD      = 0x080,    /*Closed Caption -- Hidden State*/
    KonfAppInterfaceState_Loading        = 0x100,
	KonfAppInterfaceState_Installing     = 0x200,
	KonfAppInterfaceState_InputText      = 0x400,	/*KonfPluginInputEvent*/
} KonfAppInterfaceState;

typedef enum
{
	KonfAppInterfaceResource_Dock        = KonfAppInterfaceState_OutputTV,
	KonfAppInterfaceResource_Sidebar     = KonfAppInterfaceState_OutputTV,
	KonfAppInterfaceResource_SidebarPIN  = KonfAppInterfaceResource_Sidebar | KonfAppInterfaceState_InputChannel,
	KonfAppInterfaceResource_Fullscreen1 = KonfAppInterfaceState_InputChannel | KonfAppInterfaceState_InputSound | KonfAppInterfaceState_InputTransport,
	KonfAppInterfaceResource_Fullscreen2 = 0,
	KonfAppInterfaceResource_Fullscreen3 = KonfAppInterfaceState_InputChannel,
	KonfAppInterfaceResource_Fullscreen4 = KonfAppInterfaceState_InputChannel | KonfAppInterfaceState_InputTransport,
	KonfAppInterfaceResource_Fullscreen5 = KonfAppInterfaceState_InputChannel | KonfAppInterfaceState_InputSound,
	KonfAppInterfaceResource_Fullscreen6 = KonfAppInterfaceState_InputTransport,
	KonfAppInterfaceResource_Fullscreen7 = KonfAppInterfaceState_InputTransport | KonfAppInterfaceState_InputSound,
	KonfAppInterfaceResource_Fullscreen8 = KonfAppInterfaceState_InputSound,
	KonfAppInterfaceResource_Hide		 = KonfAppInterfaceState_OutputTV  | KonfAppInterfaceState_OutputOSD,
	KonfAppInterfaceResource_Loading     = KonfAppInterfaceState_Loading,
    KonfAppInterfaceResource_Installing  = KonfAppInterfaceState_Installing,
    KonfAppInterfaceResource_OOBE        = KonfAppInterfaceState_OutputTV
} KonfAppInterfaceResourceGroup;


typedef void (*KonfApp_SetState)(unsigned int); /*KonfAppInterfaceState(s)*/

/*
00000000 : HideWithoutSDL
00000001 : Show
00000010 : FactoryReset
00000011 : Show & FactoryReset
*/

typedef enum
{
	KonfAppInterfaceFlag_Show          		= 0x01,
	KonfAppInterfaceFlag_FactoryReset  		= 0x02,
	KonfAppInterfaceFlag_ProcessServer 		= 0x04
} KonfAppInterfaceFlag;


typedef struct
{
	char *                 appPath;
	unsigned int           flags;		/*KonfAppInterfaceFlag(s)*/
	KonfApp_SetState       setState;
	KonfInterfaceVersion   version;
} KonfAppInterface;

#ifdef __cplusplus
extern "C" {
#endif
	KonfPluginInterface *KonfInitPlugin( KonfAppInterface *inApp );
	int                  KonfRunPlugin();
	void                 KonfCleanPlugin();
#ifdef __cplusplus
}
#endif

#endif /* __KONFPLUGIN_H__ */
