/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object other) {
        if (other == null || !(other instanceof Certificate)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        try {
            return Arrays.equals(this.getEncoded(), ((Certificate)other).getEncoded());
        }
        catch (CertificateEncodingException cee) {
            return false;
        }
    }

    public int hashCode() {
        int retval = 0;
        try {
            byte[] certData = this.getEncoded();
            int i = 1;
            while (i < certData.length) {
                retval += certData[i] * i;
                ++i;
            }
            return retval;
        }
        catch (CertificateException cee) {
            return retval;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();
}

