/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Trace;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.Engine;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLContext {
    private static final String SSL_CONTEXT = "SSLContext";
    private final SSLContextSpi ctxSpi;
    private final Provider provider;
    private final String protocol;
    static final boolean dev = BtworksJSSE.DEBUG_JAVAX;

    protected SSLContext(SSLContextSpi ctxSpi, Provider provider, String protocol) {
        this.ctxSpi = ctxSpi;
        this.provider = provider;
        this.protocol = protocol;
    }

    public static SSLContext getInstance(String protocol) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        int i = 0;
        while (i < provs.length) {
            try {
                return SSLContext.getInstance(protocol, provs[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(protocol);
    }

    public static SSLContext getInstance(String protocol, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (dev) {
            Trace.a("SSLContext().getInstance", "INIT_COUNT");
        }
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SSLContext.getInstance(protocol, p);
    }

    public static SSLContext getInstance(String protocol, Provider provider) throws NoSuchAlgorithmException {
        try {
            if (dev) {
                Trace.a("SSLContext().getInstance", "getInstance start");
            }
            return new SSLContext((SSLContextSpi)Engine.getInstance(SSL_CONTEXT, protocol, provider), provider, protocol);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new NoSuchAlgorithmException();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            throw new NoSuchAlgorithmException();
        }
    }

    public final SSLSessionContext getClientSessionContext() {
        return this.ctxSpi.engineGetClientSessionContext();
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SSLSessionContext getServerSessionContext() {
        return this.ctxSpi.engineGetServerSessionContext();
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return this.ctxSpi.engineGetServerSocketFactory();
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.ctxSpi.engineGetSocketFactory();
    }

    public final void init(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom random) throws KeyManagementException {
        this.ctxSpi.engineInit(keyManagers, trustManagers, random);
    }
}

