/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrivialHostnameVerifier;

public abstract class HttpsURLConnection
extends HttpURLConnection {
    private static HostnameVerifier defaultVerifier = new TrivialHostnameVerifier();
    private static SSLSocketFactory defaultFactory;
    protected HostnameVerifier hostnameVerifier = defaultVerifier;
    private SSLSocketFactory factory = defaultFactory;

    static {
        try {
            defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected HttpsURLConnection(URL url) throws IOException {
        super(url);
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("default verifier cannot be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SSLPermission("setHostnameVerifier"));
        }
        defaultVerifier = newDefault;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory newDefault) {
        if (newDefault == null) {
            throw new IllegalArgumentException("default factory cannot be null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        defaultFactory = newDefault;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("verifier cannot be null");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.factory;
    }

    public void setSSLSocketFactory(SSLSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        this.factory = factory;
    }

    public abstract String getCipherSuite();

    public abstract Certificate[] getLocalCertificates();

    public abstract Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;
}

