/*
 * Decompiled with CFR 0.152.
 */
package btworks.xutil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static final String ZIP_SEPARATOR = "/";
    public static final char ZIP_SEPARATOR_CHAR = '/';
    public static int BUFFER_SIZE = 1024;
    public static int R_BUFFER_SIZE = 1024;
    public static int W_BUFFER_SIZE = 1024;

    public static void compressFiles(File[] srcFiles, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        ZipUtil.compressFiles(srcFiles, new BufferedOutputStream(fos, W_BUFFER_SIZE));
        fos.flush();
        fos.close();
    }

    public static void compressFiles(File[] srcFiles, OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        int i = 0;
        while (i < srcFiles.length) {
            ZipUtil._compress(srcFiles[i], zos);
            ++i;
        }
        zos.flush();
        zos.close();
    }

    public static void compressFile(File srcFile, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        ZipUtil.compressFile(srcFile, new BufferedOutputStream(fos, W_BUFFER_SIZE));
        fos.flush();
        fos.close();
    }

    public static void compressFile(File srcFile, OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        ZipUtil._compress(srcFile, zos);
        zos.flush();
        zos.close();
    }

    private static void _compress(File f, ZipOutputStream zos) throws IOException {
        ZipUtil._compress(f, "", zos);
    }

    private static void _compress(File f, String parentPath, ZipOutputStream zos) throws IOException {
        ZipUtil._compress(f, parentPath, null, zos);
    }

    private static void _compress(File f, String parentPath, String altPath, ZipOutputStream zos) throws IOException {
        String entryPath = null;
        if (f.isDirectory()) {
            String string = entryPath = altPath != null ? altPath : f.getName();
            if (!entryPath.endsWith(ZIP_SEPARATOR)) {
                entryPath = entryPath.concat(ZIP_SEPARATOR);
            }
        } else {
            entryPath = f.getName();
        }
        entryPath = parentPath.concat(entryPath);
        ZipEntry entry = new ZipEntry(entryPath);
        entry.setTime(f.lastModified());
        zos.putNextEntry(entry);
        if (f.isDirectory()) {
            File[] subFiles = f.listFiles();
            int i = 0;
            while (i < subFiles.length) {
                ZipUtil._compress(subFiles[i], entryPath, zos);
                ++i;
            }
        } else {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f), R_BUFFER_SIZE);
            byte[] buf = new byte[BUFFER_SIZE];
            long index = 0L;
            while (index < f.length()) {
                int read = bis.read(buf);
                if (read < 0) {
                    throw new EOFException("reach illegal eof : " + f.getName() + " (idx." + index + ")");
                }
                zos.write(buf, 0, read);
                index += (long)read;
            }
            bis.close();
        }
    }

    public static void compressFilesWithEnv(Map env, File srcFile, String srcEntryPath, File destFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile), W_BUFFER_SIZE));
        Iterator iter = env.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            byte[] content = (byte[])env.get(key);
            ZipEntry entry = new ZipEntry(key);
            zos.putNextEntry(entry);
            if (content == null) continue;
            zos.write(content, 0, content.length);
        }
        ZipUtil._compress(srcFile, "", srcEntryPath, zos);
        zos.flush();
        zos.close();
    }

    public static void decompressFile(File zipFile, File destPath) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile), R_BUFFER_SIZE));
        ZipUtil._decompress(zis, destPath);
        zis.close();
    }

    private static void _decompress(ZipInputStream zis, File destPath) throws IOException {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            int read;
            File entryFile = new File(destPath, entry.getName().replace('/', File.separatorChar));
            if (entry.isDirectory()) {
                if (entryFile.exists()) continue;
                entryFile.mkdirs();
                continue;
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(entryFile));
            byte[] buf = new byte[BUFFER_SIZE];
            long index = 0L;
            while ((read = zis.read(buf)) >= 0) {
                bos.write(buf, 0, read);
                index += (long)read;
            }
            if (index < entry.getSize()) {
                throw new EOFException("reach illegal eof : [ZIP]/" + entry.getName() + " (idx." + index + ")");
            }
            bos.flush();
            bos.close();
        }
    }

    public static void decompressWithEnv(File zipFile, Map env) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile), R_BUFFER_SIZE));
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            int read;
            if (!env.containsKey(entry.getName())) continue;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[BUFFER_SIZE];
            long index = 0L;
            while ((read = zis.read(buf)) >= 0) {
                bos.write(buf, 0, read);
                index += (long)read;
            }
            if (index < entry.getSize()) {
                throw new EOFException("reach illegal eof : [ZIP]/" + entry.getName() + " (idx." + index + ")");
            }
            bos.flush();
            bos.close();
            env.put(entry.getName(), bos.toByteArray());
        }
        zis.close();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, byte[]> cableCard_entries = new HashMap<String, byte[]>();
        cableCard_entries.put("DC/rootca/dcrootca.der", new byte[]{49});
        cableCard_entries.put("DC/mfgca/cablecardca001.der", new byte[]{50});
        cableCard_entries.put("CVC/rootca/cvcrootca.der", new byte[]{51});
        cableCard_entries.put("CVC/cvcca/cvcca.der", new byte[]{52});
        cableCard_entries.put("CVC/appcvcca/appcvcca.der", new byte[]{53});
        ZipUtil.compressFilesWithEnv(cableCard_entries, new File("jutil"), "jutil_altName", new File("res.zip"));
    }
}

