/*
 * Decompiled with CFR 0.152.
 */
package btworks.xutil;

import btworks.xutil.ZipUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;

public class MetaInfoUtil {
    public static final String LF = "\n";
    public static String MANIFEST = "META-INF/MANIFEST.MF";
    public static String TITLE = "btworks4jce";

    public static String getManifest(String jarFile) throws IOException {
        return MetaInfoUtil.getManifest(jarFile, true);
    }

    public static String getManifest(String jarFile, boolean shortFormat) throws IOException {
        HashMap env = new HashMap();
        env.put(MANIFEST, null);
        ZipUtil.decompressWithEnv(new File(jarFile), env);
        byte[] content = (byte[])env.get(MANIFEST);
        if (content == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
        StringBuffer sbuf = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (shortFormat && (line = line.trim()).length() == 0) break;
            sbuf.append(line).append(LF);
        }
        reader.close();
        return sbuf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("* usage: java btwrosk.xutil.MetaInfoUtil JARFILE");
            System.out.println("     eg. java -jar ./btworks4jce.jar ./btworks4jce.jar");
            System.exit(0);
        }
        System.out.println("******************* " + MANIFEST + " *******************");
        System.out.print(MetaInfoUtil.getManifest(args[0]));
        System.out.println("************************************************************");
    }
}

