/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public final class Util {
    static final String HEX = "0123456789abcdef";

    private Util() {
    }

    static byte[] toByteArray(String hex) {
        hex = hex.toLowerCase();
        byte[] buf = new byte[hex.length() / 2];
        int j = 0;
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)(Character.digit(hex.charAt(j++), 16) << 4 | Character.digit(hex.charAt(j++), 16));
            ++i;
        }
        return buf;
    }

    static String toHexString(byte[] buf, int off, int len) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < len) {
            str.append(HEX.charAt(buf[i + off] >>> 4 & 0xF));
            str.append(HEX.charAt(buf[i + off] & 0xF));
            ++i;
        }
        return str.toString();
    }

    static String toHexString(byte[] buf) {
        return Util.toHexString(buf, 0, buf.length);
    }

    static String toHexString(byte[] buf, int off, int len, char sep) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < len) {
            str.append(HEX.charAt(buf[i + off] >>> 4 & 0xF));
            str.append(HEX.charAt(buf[i + off] & 0xF));
            if (i < len - 1) {
                str.append(sep);
            }
            ++i;
        }
        return str.toString();
    }

    static String toHexString(byte[] buf, char sep) {
        return Util.toHexString(buf, 0, buf.length, sep);
    }

    public static String hexDump(byte[] buf, int off, int len, String prefix) {
        String nl = Util.getProperty("line.separator");
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (prefix != null) {
                str.append(prefix);
            }
            str.append(Util.formatInt(i + off, 16, 8));
            str.append("  ");
            String s = Util.toHexString(buf, i + off, Math.min(16, len - i), ' ');
            str.append(s);
            int j = 56 - (56 - s.length());
            while (j < 56) {
                str.append(" ");
                ++j;
            }
            j = 0;
            while (j < Math.min(16, len - i)) {
                if ((buf[i + off + j] & 0xFF) < 32 || (buf[i + off + j] & 0xFF) > 126) {
                    str.append('.');
                } else {
                    str.append((char)(buf[i + off + j] & 0xFF));
                }
                ++j;
            }
            str.append(nl);
            i += 16;
        }
        return str.toString();
    }

    public static String hexDump(byte[] buf, int off, int len) {
        return Util.hexDump(buf, off, len, "");
    }

    public static String hexDump(byte[] buf, String prefix) {
        return Util.hexDump(buf, 0, buf.length, prefix);
    }

    public static String hexDump(byte[] buf) {
        return Util.hexDump(buf, 0, buf.length);
    }

    static String formatInt(int i, int radix, int len) {
        String s = Integer.toString(i, radix);
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < len - s.length()) {
            buf.append("0");
            ++j;
        }
        buf.append(s);
        return buf.toString();
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        byte[] b3 = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b3, 0, b1.length);
        System.arraycopy(b2, 0, b3, b1.length, b2.length);
        return b3;
    }

    public static byte[] trim(byte[] buffer2, int len) {
        return Util.trim(buffer2, 0, len);
    }

    public static byte[] trim(byte[] buffer2, int off, int len) {
        if (off < 0 || len < 0 || off > buffer2.length) {
            throw new IndexOutOfBoundsException("max=" + buffer2.length + " off=" + off + " len=" + len);
        }
        if (off == 0 && len == buffer2.length) {
            return buffer2;
        }
        byte[] b = new byte[len];
        System.arraycopy(buffer2, off, b, 0, Math.min(len, buffer2.length - off));
        return b;
    }

    public static byte[] trim(BigInteger bi) {
        byte[] buf = bi.toByteArray();
        if (buf[0] == 0 && !bi.equals(BigInteger.ZERO)) {
            return Util.trim(buf, 1, buf.length - 1);
        }
        return buf;
    }

    static int unixTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static Object[] transform(Object[] array, Class returnType, String method, Object[] args) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] result = (Object[])Array.newInstance(returnType, array.length);
        Class[] argsClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argsClasses[i] = args[i].getClass();
            ++i;
        }
        i = 0;
        while (i < array.length) {
            if (array[i] == null) {
                result[i] = null;
            } else {
                Class<?> objClass = array[i].getClass();
                Method objMethod = objClass.getMethod(method, argsClasses);
                Object o = objMethod.invoke(array[i], args);
                if (!returnType.isAssignableFrom(o.getClass())) {
                    throw new ClassCastException();
                }
                result[i] = o;
            }
            ++i;
        }
        return result;
    }

    static String getProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    static String getSecurityProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(name);
            }
        });
    }
}

