/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.HashFactory;
import btworks.crypto.mac.BtwMac;
import btworks.crypto.prng.BtwRandom;
import btworks.jsse.provider.TLSHMac;
import btworks.jsse.provider.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

class TLSRandom
implements BtwRandom {
    static final String SECRET = "btworks.tls.prng.secret";
    static final String SEED = "btworks.tls.prng.seed";
    private final BtwMac hmac_sha = new TLSHMac(HashFactory.getInstance("SHA1"));
    private final BtwMac hmac_md5 = new TLSHMac(HashFactory.getInstance("MD5"));
    private byte[] sha_a;
    private byte[] md5_a;
    private byte[] seed;
    private final byte[] buffer = new byte[80];
    private int idx = 0;
    private boolean init = false;

    TLSRandom() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException shouldNotHappen) {
            throw new Error();
        }
    }

    public void init(Map attributes) {
        HashMap<String, byte[]> sha_attr = new HashMap<String, byte[]>();
        HashMap<String, byte[]> md5_attr = new HashMap<String, byte[]>();
        byte[] secret = (byte[])attributes.get(SECRET);
        if (secret != null) {
            int l = (secret.length >>> 1) + (secret.length & 1);
            byte[] s1 = Util.trim(secret, 0, l);
            byte[] s2 = Util.trim(secret, secret.length - l, l);
            md5_attr.put("btworks.crypto.mac.key.material", s1);
            sha_attr.put("btworks.crypto.mac.key.material", s2);
            try {
                this.hmac_md5.init(md5_attr);
                this.hmac_sha.init(sha_attr);
            }
            catch (InvalidKeyException ike) {
                throw new Error(ike.toString());
            }
        } else if (!this.init) {
            throw new IllegalArgumentException("no secret supplied");
        }
        byte[] seeed = (byte[])attributes.get(SEED);
        if (seeed != null) {
            this.seed = (byte[])seeed.clone();
        } else if (!this.init) {
            throw new IllegalArgumentException("no seed supplied");
        }
        this.hmac_md5.update(this.seed, 0, this.seed.length);
        this.md5_a = this.hmac_md5.digest();
        this.hmac_md5.reset();
        this.hmac_sha.update(this.seed, 0, this.seed.length);
        this.sha_a = this.hmac_sha.digest();
        this.hmac_sha.reset();
        this.fillBuffer();
        this.init = true;
    }

    public String name() {
        return "TLSRandom";
    }

    public byte nextByte() {
        if (!this.init) {
            throw new IllegalStateException();
        }
        if (this.idx >= this.buffer.length) {
            this.fillBuffer();
        }
        return this.buffer[this.idx++];
    }

    public void nextBytes(byte[] buf, int off, int len) {
        if (!this.init) {
            throw new IllegalStateException();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int count = 0;
        if (this.idx >= this.buffer.length) {
            this.fillBuffer();
        }
        while (count < len) {
            int l = Math.min(this.buffer.length - this.idx, len - count);
            System.arraycopy(this.buffer, this.idx, buf, off + count, l);
            this.idx += l;
            if ((count += l) >= len || this.idx < this.buffer.length) continue;
            this.fillBuffer();
        }
    }

    private synchronized void fillBuffer() {
        byte[] b;
        int len = this.hmac_md5.macSize();
        int i = 0;
        while (i < this.buffer.length) {
            this.hmac_md5.update(this.md5_a, 0, this.md5_a.length);
            this.hmac_md5.update(this.seed, 0, this.seed.length);
            b = this.hmac_md5.digest();
            this.hmac_md5.reset();
            System.arraycopy(b, 0, this.buffer, i, len);
            this.hmac_md5.update(this.md5_a, 0, this.md5_a.length);
            this.md5_a = this.hmac_md5.digest();
            this.hmac_md5.reset();
            i += len;
        }
        len = this.hmac_sha.macSize();
        i = 0;
        while (i < this.buffer.length) {
            this.hmac_sha.update(this.sha_a, 0, this.sha_a.length);
            this.hmac_sha.update(this.seed, 0, this.seed.length);
            b = this.hmac_sha.digest();
            this.hmac_sha.reset();
            int j = 0;
            while (j < len) {
                int n = j + i;
                this.buffer[n] = (byte)(this.buffer[n] ^ b[j]);
                ++j;
            }
            this.hmac_sha.update(this.sha_a, 0, this.sha_a.length);
            this.sha_a = this.hmac_sha.digest();
            this.hmac_sha.reset();
            i += len;
        }
        this.idx = 0;
    }
}

