/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Alert;
import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.SecurityParameters;
import btworks.jsse.provider.SessionContext;
import btworks.jsse.provider.Util;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class Session
implements SSLSession {
    private static final SSLPermission GET_SESSION_CONTEXT_PERMISSION = new SSLPermission("getSSLSessionContext");
    private final long creationTime;
    private Date lastAccessedTime;
    ID sessionId;
    Certificate[] localCerts;
    Certificate[] peerCerts;
    X509Certificate[] peerCertChain;
    String peerHost;
    boolean peerVerified = false;
    SessionContext context;
    HashMap values;
    boolean valid = true;
    List enabledSuites;
    CipherSuite cipherSuite;
    SortedSet enabledProtocols;
    ProtocolVersion protocol;
    byte[] masterSecret;
    X509TrustManager trustManager;
    X509KeyManager keyManager;
    SecureRandom random;
    SecurityParameters params;
    Alert currentAlert;

    Session() {
        this(System.currentTimeMillis());
    }

    Session(long creationTime) {
        this.creationTime = creationTime;
        this.lastAccessedTime = new Date(0L);
        this.values = new HashMap();
        this.params = new SecurityParameters();
    }

    protected Object clone() {
        Session result = new Session(this.creationTime);
        result.lastAccessedTime = this.lastAccessedTime;
        result.sessionId = this.sessionId;
        result.localCerts = this.localCerts != null ? (Certificate[])this.localCerts.clone() : null;
        result.peerCerts = this.peerCerts != null ? (Certificate[])this.peerCerts.clone() : null;
        result.peerHost = this.peerHost;
        result.peerVerified = this.peerVerified;
        result.context = this.context;
        result.values = this.values;
        result.enabledSuites = new ArrayList(this.enabledSuites);
        result.cipherSuite = this.cipherSuite;
        result.enabledProtocols = new TreeSet(this.enabledProtocols);
        result.protocol = this.protocol;
        result.masterSecret = this.masterSecret;
        result.keyManager = this.keyManager;
        result.trustManager = this.trustManager;
        result.random = this.random;
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Session)) {
            return false;
        }
        return this.sessionId.equals(((Session)other).sessionId);
    }

    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            return null;
        }
        return this.cipherSuite.toString();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.sessionId != null ? this.sessionId.getId() : null;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime.getTime();
    }

    public Certificate[] getLocalCertificates() {
        return (Certificate[])(this.localCerts != null ? this.localCerts.clone() : null);
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        return (Certificate[])(this.peerCerts != null ? this.peerCerts.clone() : null);
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCerts == null) {
            return null;
        }
        if (this.peerCertChain != null) {
            return (X509Certificate[])this.peerCertChain.clone();
        }
        try {
            this.peerCertChain = new X509Certificate[this.peerCerts.length];
            int i = 0;
            while (i < this.peerCerts.length) {
                this.peerCertChain[i] = X509Certificate.getInstance(this.peerCerts[i].getEncoded());
                ++i;
            }
            return (X509Certificate[])this.peerCertChain.clone();
        }
        catch (CertificateException ce) {
            return null;
        }
        catch (CertificateEncodingException e) {
            return null;
        }
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public SSLSessionContext getSessionContext() {
        return this.context;
    }

    public String[] getValueNames() {
        Set names = this.values.keySet();
        return names.toArray(new String[names.size()]);
    }

    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.values.get(name);
    }

    public void putValue(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.removeValue(name);
        this.values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void removeValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Object value = this.values.remove(name);
        if (value != null && value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    public void invalidate() {
        if (this.masterSecret != null) {
            int i = 0;
            while (i < this.masterSecret.length) {
                this.masterSecret[i] = 0;
                ++i;
            }
            this.masterSecret = null;
        }
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    synchronized void access() {
        this.lastAccessedTime.setTime(System.currentTimeMillis());
        this.context.notifyAccess(this);
    }

    void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime.setTime(lastAccessedTime);
    }

    static final class ID
    implements Comparable {
        private final byte[] id;

        ID(byte[] id) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            this.id = id;
        }

        public byte[] getId() {
            return (byte[])this.id.clone();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ID)) {
                return false;
            }
            return Arrays.equals(this.id, ((ID)other).id);
        }

        public int hashCode() {
            int code = 0;
            int i = 0;
            while (i < this.id.length) {
                code |= (this.id[i] & 0xFF) << ((i & 3) << 3);
                ++i;
            }
            return code;
        }

        public int compareTo(Object other) {
            if (other == null || !(other instanceof ID)) {
                return 1;
            }
            byte[] id2 = ((ID)other).id;
            if (this.id.length != id2.length) {
                return this.id.length < id2.length ? -1 : 1;
            }
            int i = 0;
            while (i < this.id.length) {
                if (this.id[i] < id2[i]) {
                    return -1;
                }
                if (this.id[i] > id2[i]) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        public String toString() {
            return Util.toHexString(this.id, ':');
        }
    }
}

