/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.cipher.Acc;
import btworks.crypto.mac.BtwMac;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.ContentType;
import btworks.jsse.provider.MacException;
import btworks.jsse.provider.OverflowException;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Trace;
import btworks.jsse.provider.Util;
import java.util.Arrays;
import java.util.Random;
import javax.net.ssl.SSLException;

class SecurityParameters {
    Acc inCipher;
    Acc outCipher;
    BtwMac inMac;
    BtwMac outMac;
    long inSequence;
    long outSequence;
    Random random;
    ProtocolVersion version;
    int fragmentLength;
    static final boolean dev = BtworksJSSE.DEBUG_SecurityParameter;

    SecurityParameters() {
        this.resetInCounter();
        this.resetOutCounter();
        if (dev) {
            Trace.a("secParams.const()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("secParams.const()", "set random..");
        }
        this.random = new Random();
        if (dev) {
            Trace.a("secParams.const()", "set random.. ok");
        }
        this.fragmentLength = 16384;
    }

    void resetInCounter() {
        this.inSequence = 0L;
    }

    void resetOutCounter() {
        this.outSequence = 0L;
    }

    void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    void setInCipher(Acc inCipher) {
        this.inCipher = inCipher;
    }

    void setOutCipher(Acc outCipher) {
        this.outCipher = outCipher;
    }

    void setInMac(BtwMac inMac) {
        this.inMac = inMac;
    }

    void setOutMac(BtwMac outMac) {
        this.outMac = outMac;
    }

    void setDeflating(boolean deflating) {
    }

    void setInflating(boolean inflating) {
    }

    void setFragmentLength(int fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    synchronized byte[] decrypt(byte[] fragment, ProtocolVersion version, ContentType type) throws MacException, OverflowException, SSLException {
        int i;
        if (dev) {
            Trace.a("secParams.decrypt()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("secParams.decrypt()", "decrypt start..");
        }
        int endIdx = fragment.length;
        boolean badPadding = false;
        boolean padFlag = false;
        if (this.inCipher != null) {
            if (dev) {
                Trace.a("secParams.decrypt() cipher:", this.inCipher.getClass().getName());
            }
            int bs = this.inCipher.currentBlockSize();
            if (dev) {
                Trace.a("secParams.decrypt()", "before decrypt..:\n " + Util.hexDump(fragment));
            }
            this.inCipher.decryptCBC2(fragment);
            if (dev) {
                Trace.a("secParams.decrypt()", "decryptCBC2... ok :\n " + Util.hexDump(fragment));
            }
            int padLen = fragment[fragment.length - 1] & 0xFF;
            int len = fragment.length - padLen - 1;
            if (dev) {
                Trace.a("secParams.decrypt()", "bs: " + bs + " padLen: " + padLen + " fragment.length: " + fragment.length);
            }
            if (version == ProtocolVersion.SSL_3) {
                if (dev) {
                    Trace.a("secParams.decrypt()", "use sslv3 ? true");
                }
                if (padLen >= bs) {
                    badPadding = true;
                }
            } else {
                if (dev) {
                    Trace.a("secParams.decrypt()", "use sslv3 ? false : " + version);
                }
                i = len;
                while (i < fragment.length) {
                    if ((fragment[i] & 0xFF) != padLen) {
                        badPadding = true;
                    }
                    ++i;
                }
            }
            endIdx = len;
            if (dev) {
                Trace.a("secParams.decrypt()", "after decrypt..:\n " + Util.hexDump(fragment));
            }
            if (dev) {
                Trace.a("secParams.decrypt()", "check pad.. ok : " + endIdx + ", badPadding ? " + badPadding);
            }
            padFlag = true;
        }
        if (this.inMac != null) {
            this.inMac.update((byte)(this.inSequence >>> 56));
            this.inMac.update((byte)(this.inSequence >>> 48));
            this.inMac.update((byte)(this.inSequence >>> 40));
            this.inMac.update((byte)(this.inSequence >>> 32));
            this.inMac.update((byte)(this.inSequence >>> 24));
            this.inMac.update((byte)(this.inSequence >>> 16));
            this.inMac.update((byte)(this.inSequence >>> 8));
            this.inMac.update((byte)this.inSequence);
            this.inMac.update((byte)type.getValue());
            if (version != ProtocolVersion.SSL_3) {
                this.inMac.update((byte)version.getMajor());
                this.inMac.update((byte)version.getMinor());
            }
            int macLen = this.inMac.macSize();
            int fragLen = endIdx - macLen;
            this.inMac.update((byte)(fragLen >>> 8));
            this.inMac.update((byte)fragLen);
            this.inMac.update(fragment, 0, fragLen);
            byte[] mac = this.inMac.digest();
            this.inMac.reset();
            i = 0;
            while (i < macLen) {
                if (fragment[i + fragLen] != mac[i]) {
                    throw new MacException();
                }
                ++i;
            }
            if (badPadding) {
                throw new MacException();
            }
            fragment = Util.trim(fragment, fragLen);
            endIdx = fragLen;
            padFlag = true;
            if (dev) {
                Trace.a("secParams.decrypt()", "check MAC.. ok : " + endIdx);
            }
        }
        ++this.inSequence;
        if (padFlag) {
            fragment = Util.trim(fragment, endIdx);
        }
        return fragment;
    }

    synchronized byte[] encrypt(byte[] buf, int off, int len, ContentType type) throws SSLException, OverflowException {
        if (dev) {
            Trace.a("secParams.encrypt()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("secParams.encrypt()", "encrypt start..");
        }
        if (dev) {
            Trace.a("secParams.encrypt()", "org message:\n " + Util.hexDump(buf, off, len));
        }
        byte[] mac = new byte[]{};
        if (this.outMac != null) {
            this.outMac.update((byte)(this.outSequence >>> 56));
            this.outMac.update((byte)(this.outSequence >>> 48));
            this.outMac.update((byte)(this.outSequence >>> 40));
            this.outMac.update((byte)(this.outSequence >>> 32));
            this.outMac.update((byte)(this.outSequence >>> 24));
            this.outMac.update((byte)(this.outSequence >>> 16));
            this.outMac.update((byte)(this.outSequence >>> 8));
            this.outMac.update((byte)this.outSequence);
            this.outMac.update((byte)type.getValue());
            if (this.version != ProtocolVersion.SSL_3) {
                this.outMac.update((byte)this.version.getMajor());
                this.outMac.update((byte)this.version.getMinor());
            }
            this.outMac.update((byte)(len >>> 8));
            this.outMac.update((byte)len);
            this.outMac.update(buf, off, len);
            mac = this.outMac.digest();
            this.outMac.reset();
        }
        ++this.outSequence;
        byte[] pad = new byte[]{};
        if (this.outCipher != null) {
            if (dev) {
                Trace.a("secParams.encrypt() cipher:", this.outCipher.getClass().getName());
            }
            int padLen = this.outCipher.currentBlockSize() - (len + mac.length + 1) % this.outCipher.currentBlockSize();
            if (this.version != ProtocolVersion.SSL_3) {
                byte[] rand = new byte[1];
                this.random.nextBytes(rand);
                padLen += (Math.abs(rand[0]) & 7) * this.outCipher.currentBlockSize();
                while (padLen > 255) {
                    padLen -= this.outCipher.currentBlockSize();
                }
            }
            pad = new byte[padLen + 1];
            Arrays.fill(pad, (byte)padLen);
        }
        int fraglen = len + mac.length + pad.length;
        if (this.outCipher != null) {
            byte[] buf2 = new byte[fraglen];
            System.arraycopy(buf, off, buf2, 0, len);
            System.arraycopy(mac, 0, buf2, len, mac.length);
            System.arraycopy(pad, 0, buf2, len + mac.length, pad.length);
            buf2 = this.outCipher.encryptCBC(buf2, false);
            if (dev) {
                Trace.a("secParams.encrypt()", "encryptCBC... ok :\n " + Util.hexDump(buf2));
            }
            return buf2;
        }
        if (mac.length == 0) {
            return Util.trim(buf, off, len);
        }
        return Util.concat(Util.trim(buf, off, len), mac);
    }
}

