/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Alert;
import btworks.jsse.provider.AlertException;
import btworks.jsse.provider.SSLSocket;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLException;

class SSLSocketOutputStream
extends FilterOutputStream {
    private final SSLSocket socket;
    private final boolean checkHandshake;

    SSLSocketOutputStream(OutputStream out, SSLSocket socket) {
        this(out, socket, true);
    }

    SSLSocketOutputStream(OutputStream out, SSLSocket socket, boolean checkHandshake) {
        super(out);
        this.socket = socket;
        this.checkHandshake = checkHandshake;
    }

    public void write(int b) throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        this.checkAlert();
        this.out.write(b);
        this.checkAlert();
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.checkAlert();
        this.out.write(buf, off, len);
        this.checkAlert();
    }

    private synchronized void checkAlert() throws SSLException {
        Alert alert = this.socket.checkAlert();
        if (alert == null) {
            return;
        }
        if (alert.getLevel().equals(Alert.Level.FATAL)) {
            throw new AlertException(alert, false);
        }
    }
}

