/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.cipher.Acc;
import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.mac.BtwMac;
import btworks.crypto.prng.BtwRandom;
import btworks.crypto.prng.LimitReachedException;
import btworks.crypto.sig.BtwSignature;
import btworks.crypto.sig.rsa.EME_PKCS1_V1_5;
import btworks.crypto.sig.rsa.RSA;
import btworks.jsse.callbacks.DefaultCallbackHandler;
import btworks.jsse.provider.Alert;
import btworks.jsse.provider.AlertException;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Certificate;
import btworks.jsse.provider.CertificateRequest;
import btworks.jsse.provider.CertificateType;
import btworks.jsse.provider.CertificateVerify;
import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.ClientHello;
import btworks.jsse.provider.ClientKeyExchange;
import btworks.jsse.provider.CompressionMethod;
import btworks.jsse.provider.ContentType;
import btworks.jsse.provider.ControlInputStream;
import btworks.jsse.provider.DigestInputStream;
import btworks.jsse.provider.DigestOutputStream;
import btworks.jsse.provider.Extension;
import btworks.jsse.provider.Extensions;
import btworks.jsse.provider.Finished;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.KeyPool;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.RSAPrivateKeyImpl;
import btworks.jsse.provider.RSAPublicKeyImpl;
import btworks.jsse.provider.Random;
import btworks.jsse.provider.RecordInput;
import btworks.jsse.provider.RecordInputStream;
import btworks.jsse.provider.RecordOutputStream;
import btworks.jsse.provider.SSLRSASignature;
import btworks.jsse.provider.SSLRandom;
import btworks.jsse.provider.SSLSocketInputStream;
import btworks.jsse.provider.SSLSocketOutputStream;
import btworks.jsse.provider.SecurityParameters;
import btworks.jsse.provider.ServerHello;
import btworks.jsse.provider.ServerKeyExchange;
import btworks.jsse.provider.Session;
import btworks.jsse.provider.SessionContext;
import btworks.jsse.provider.Signature;
import btworks.jsse.provider.TLSRandom;
import btworks.jsse.provider.Trace;
import btworks.jsse.provider.Util;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;

final class SSLSocket
extends javax.net.ssl.SSLSocket {
    private static final boolean DEBUG_HANDSHAKE_LAYER = BtworksJSSE.DEBUG_SSLSocket_Handshake;
    private static final boolean DEBUG_KEY_EXCHANGE = BtworksJSSE.DEBUG_SSLSocket_KeyExchange;
    private static final PrintStream debug = System.out;
    private Socket underlyingSocket;
    private int underlyingPort;
    private boolean autoClose;
    SessionContext sessionContext;
    Session session;
    LinkedList handshakeListeners;
    private boolean clientMode;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private boolean createSessions = true;
    private boolean handshakeDone;
    private boolean handshakeStart;
    private boolean handshakeFail;
    private static final byte[] MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    private static final byte[] KEY_EXPANTION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    private static final byte[] CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    private static final byte[] CLIENT_FINISHED = new byte[]{99, 108, 105, 101, 110, 116, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    private static final byte[] SERVER_FINISHED = new byte[]{115, 101, 114, 118, 101, 114, 32, 102, 105, 110, 105, 115, 104, 101, 100};
    private static final byte[] IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private String remoteHost;
    private InputStream socketIn;
    private OutputStream socketOut;
    private InputStream applicationIn;
    private OutputStream applicationOut;
    private InputStream handshakeIn;
    private OutputStream handshakeOut;
    RecordInput recordInput;
    private long handshakeTime;
    private SocketChannel channel;
    static SortedSet supportedProtocols = new TreeSet();
    static List supportedSuites = new ArrayList(9);
    public static final boolean dev = BtworksJSSE.DEBUG_SSLSocket;
    private static final byte[] SENDER_CLIENT;
    private static final byte[] SENDER_SERVER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        supportedProtocols.add(ProtocolVersion.TLS_1);
        supportedProtocols.add(ProtocolVersion.SSL_3);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_SEED_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_DES_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_AES_128_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_AES_256_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_NULL_WITH_NULL_NULL);
        supportedSuites.add(CipherSuite.SSL_NULL_WITH_NULL_NULL);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_MD5);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_NULL_MD5);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_NULL_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_NULL_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_EXPORT_WITH_DES40_CBC_SHA);
        supportedSuites.add(CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        supportedSuites.add(CipherSuite.SSL_RSA_WITH_3DES_EDE_CBC_SHA);
        SENDER_CLIENT = new byte[]{67, 76, 78, 84};
        SENDER_SERVER = new byte[]{83, 82, 86, 82};
    }

    SSLSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        if (dev) {
            Trace.a("SSLSocket(socket, host, port, autoClose)", "[" + socket + "][" + host + "][" + port + "][" + autoClose + "]");
        }
        this.underlyingSocket = socket;
        this.remoteHost = host;
        this.underlyingPort = port;
        this.autoClose = autoClose;
        this.initialize();
    }

    SSLSocket(Socket socket, SocketChannel channel) {
        if (dev) {
            Trace.a("SSLSocket(socket, channel)", "[" + socket + "][" + channel + "]");
        }
        this.underlyingSocket = socket;
        this.channel = channel;
        this.initialize();
    }

    SSLSocket() throws IOException {
        if (dev) {
            Trace.a("SSLSocket()", "default constructor");
        }
        this.initialize();
    }

    SSLSocket(InetAddress addr, int port) throws IOException {
        super(addr, port);
        if (dev) {
            Trace.a("SSLSocket(addr, port)", "[" + addr + "][" + port + "]");
        }
        this.initialize();
        this.remoteHost = addr.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = addr.getHostAddress();
        }
    }

    SSLSocket(InetAddress addr, int port, InetAddress laddr, int lport) throws IOException {
        super(addr, port, laddr, lport);
        if (dev) {
            Trace.a("SSLSocket(addr, port, laddr, lport)", "[" + addr + "][" + port + "]" + "[" + laddr + "][" + lport + "]");
        }
        this.initialize();
        this.remoteHost = addr.getHostName();
        if (this.remoteHost == null) {
            this.remoteHost = addr.getHostAddress();
        }
    }

    SSLSocket(String host, int port) throws IOException {
        super(host, port);
        if (dev) {
            Trace.a("SSLSocket(host, port)", "[" + host + "][" + port + "]");
        }
        this.initialize();
        this.remoteHost = host;
    }

    SSLSocket(String host, int port, InetAddress laddr, int lport) throws IOException {
        super(host, port, laddr, lport);
        if (dev) {
            Trace.a("SSLSocket(host, port, laddr, lport)", "[" + host + "][" + port + "]" + "[" + laddr + "][" + lport + "]");
        }
        this.initialize();
        this.remoteHost = host;
    }

    private void initialize() {
        this.session = new Session();
        this.session.enabledSuites = new ArrayList(supportedSuites);
        this.session.enabledProtocols = new TreeSet(supportedProtocols);
        this.session.protocol = ProtocolVersion.TLS_1;
        this.session.params.version = ProtocolVersion.TLS_1;
        this.handshakeListeners = new LinkedList();
        this.handshakeDone = false;
        this.handshakeStart = false;
        this.handshakeFail = false;
        if (dev) {
            Trace.a("SSLSocket.initialize()", "BTW-JSSE Version: 1.1.2(2.01121)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandshakeCompletedListener(HandshakeCompletedListener l) {
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            if (l == null) {
                throw new NullPointerException();
            }
            if (dev) {
                Trace.a("SSLSocket.addHandshakeCompletedListener()", "try to add listener: " + l.toString());
            }
            if (!this.handshakeListeners.contains(l)) {
                this.handshakeListeners.add(l);
            }
            if (dev) {
                Trace.a("SSLSocket.addHandshakeCompletedListener()", "add listener: " + l.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandshakeCompletedListener(HandshakeCompletedListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList = this.handshakeListeners;
        synchronized (linkedList) {
            if (!this.handshakeListeners.remove(l)) {
                throw new IllegalArgumentException();
            }
        }
    }

    public String[] getEnabledProtocols() {
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            try {
                Object[] objectArray = this.session.enabledProtocols.toArray();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (String[])Util.transform(objectArray, clazz, "toString", null);
            }
            catch (Exception x) {
                throw new Error(x.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < protocols.length) {
            if (protocols[i] == null || !protocols[i].equalsIgnoreCase("TLSv1") && !protocols[i].equalsIgnoreCase("SSLv3")) {
                throw new IllegalArgumentException("unsupported protocol: " + protocols[i]);
            }
            ++i;
        }
        SortedSet sortedSet = this.session.enabledProtocols;
        synchronized (sortedSet) {
            this.session.enabledProtocols.clear();
            int i2 = 0;
            while (i2 < protocols.length) {
                if (protocols[i2] != null) {
                    if (protocols[i2].equalsIgnoreCase("SSLv3")) {
                        this.session.enabledProtocols.add(ProtocolVersion.SSL_3);
                    } else if (protocols[i2].equalsIgnoreCase("TLSv1")) {
                        this.session.enabledProtocols.add(ProtocolVersion.TLS_1);
                    }
                }
                ++i2;
            }
        }
    }

    public String[] getSupportedProtocols() {
        return new String[]{"TLSv1", "SSLv3"};
    }

    public String[] getEnabledCipherSuites() {
        List list = this.session.enabledSuites;
        synchronized (list) {
            try {
                Object[] objectArray = this.session.enabledSuites.toArray();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (String[])Util.transform(objectArray, clazz, "toString", null);
            }
            catch (Exception x) {
                throw new Error(x.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledCipherSuites(String[] suites) {
        if (suites == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < suites.length) {
            if (CipherSuite.forName(suites[i]) == null) {
                throw new IllegalArgumentException("unsupported suite: " + suites[i]);
            }
            ++i;
        }
        List list = this.session.enabledSuites;
        synchronized (list) {
            this.session.enabledSuites.clear();
            int i2 = 0;
            while (i2 < suites.length) {
                CipherSuite suite = CipherSuite.forName(suites[i2]);
                if (!this.session.enabledSuites.contains(suite)) {
                    if (dev) {
                        Trace.a("SSLSocket.setEnabledCipherSuite", "add suite: " + suite);
                    }
                    this.session.enabledSuites.add(suite);
                }
                if (dev) {
                    Trace.a("SSLSocket.setEnabledCipherSuite", "EnabledCipherSuite count: " + this.session.enabledSuites.size());
                }
                ++i2;
            }
        }
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public SSLSession getSession() {
        block8: {
            try {
                if (this.handshakeDone) break block8;
                if (!this.handshakeStart) {
                    this.startHandshake();
                    break block8;
                }
                int timeout = this.getSoTimeout();
                int i = 1;
                while (!this.handshakeDone && !this.handshakeFail) {
                    if (DEBUG_HANDSHAKE_LAYER && ++i % 10 == 0) {
                        debug.println("wait for handshake done... " + 100 * i + " handshakeDone[" + this.handshakeDone + "] handshakeFail[" + this.handshakeFail + "]");
                    }
                    if (timeout == 0 || timeout >= 100 * i) {
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (DEBUG_HANDSHAKE_LAYER) {
                    e.printStackTrace();
                }
                this.session.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
            }
        }
        this.session.context = this.sessionContext;
        if (this.session.cipherSuite == null) {
            this.session.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
        }
        return this.session;
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public void setEnableSessionCreation(boolean flag) {
        this.createSessions = flag;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean flag) {
        this.needClientAuth = flag;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean flag) {
        this.wantClientAuth = flag;
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public void setUseClientMode(boolean flag) {
        if (this.handshakeDone && this.clientMode != flag) {
            throw new IllegalArgumentException();
        }
        this.clientMode = flag;
    }

    public synchronized void startHandshake() throws IOException {
        try {
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println("startHandshake called in " + Thread.currentThread());
                this.handshakeTime = System.currentTimeMillis();
            }
            if (this.handshakeDone) {
                if (this.clientMode) {
                    this.handshakeDone = false;
                    this.doClientHandshake();
                } else {
                    Handshake req = new Handshake(Handshake.Type.HELLO_REQUEST, null);
                    req.write(this.handshakeOut, this.session.protocol);
                    this.handshakeOut.flush();
                }
                return;
            }
            if (this.recordInput == null) {
                this.setupIO();
            }
            if (this.clientMode) {
                this.doClientHandshake();
            } else {
                this.doServerHandshake();
            }
        }
        catch (IOException e) {
            this.session.cipherSuite = CipherSuite.SSL_NULL_WITH_NULL_NULL;
            this.handshakeFail = true;
            throw e;
        }
    }

    public InetAddress getInetAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getInetAddress();
        }
        return super.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalAddress();
        }
        return super.getLocalAddress();
    }

    public int getPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getPort();
        }
        return super.getPort();
    }

    public int getLocalPort() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalPort();
        }
        return super.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        if (this.applicationIn == null) {
            this.setupIO();
        }
        return this.applicationIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.applicationOut == null) {
            this.setupIO();
        }
        return this.applicationOut;
    }

    public void setTcpNoDelay(boolean flag) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setTcpNoDelay(flag);
        } else {
            super.setTcpNoDelay(flag);
        }
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getTcpNoDelay();
        }
        return super.getTcpNoDelay();
    }

    public void setSoLinger(boolean flag, int linger) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoLinger(flag, linger);
        } else {
            super.setSoLinger(flag, linger);
        }
    }

    public int getSoLinger() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoLinger();
        }
        return super.getSoLinger();
    }

    public void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSoTimeout(timeout);
        } else {
            super.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setSendBufferSize(size);
        } else {
            super.setSendBufferSize(size);
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getSendBufferSize();
        }
        return super.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setReceiveBufferSize(size);
        } else {
            super.setReceiveBufferSize(size);
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getReceiveBufferSize();
        }
        return super.getReceiveBufferSize();
    }

    public synchronized void close() throws IOException {
        if (dev) {
            Trace.a("[SSLSocket.close()]", "close was called");
        }
        if (this.recordInput == null) {
            if (dev) {
                Trace.a("[SSLSocket.close()]", " record input is null");
            }
            if (this.underlyingSocket != null) {
                if (this.autoClose) {
                    if (dev) {
                        Trace.a("[SSLSocket.close()]", " underlyingSocet close");
                    }
                    this.underlyingSocket.close();
                }
            } else {
                super.close();
            }
            return;
        }
        if (dev) {
            Trace.a("[SSLSocket.close()]", " send alert");
        }
        Alert close = new Alert(Alert.Level.WARNING, Alert.Description.CLOSE_NOTIFY);
        this.sendAlert(close);
        if (dev) {
            Trace.a("[SSLSocket.close()]", " send alert done");
        }
        boolean gotClose = true;
        if (dev) {
            Trace.a("[SSLSocket.close()]", " getclose: " + gotClose);
        }
        this.recordInput = null;
        if (this.underlyingSocket != null) {
            if (this.autoClose) {
                this.underlyingSocket.close();
            }
        } else {
            super.close();
        }
        if (!gotClose) {
            this.session.invalidate();
            throw new SSLException("did not receive close notify");
        }
        if (dev) {
            Trace.a("[SSLSocket.close()]", " CLOSE DONE");
        }
    }

    public String toString() {
        if (this.underlyingSocket != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("btworks.jsse.provider.SSLSocket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return String.valueOf(clazz.getName()) + " [ " + this.underlyingSocket + " ]";
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("btworks.jsse.provider.SSLSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return String.valueOf(clazz.getName()) + " [ " + super.toString() + " ]";
    }

    public void connect(SocketAddress saddr) throws IOException {
        if (this.underlyingSocket != null) {
            if (dev) {
                Trace.a("SSLSocket.connect() using underlyingSocket", saddr.toString());
            }
            this.underlyingSocket.connect(saddr);
        } else {
            if (dev) {
                Trace.a("SSLSocket.connect()", saddr.toString());
            }
            super.connect(saddr);
        }
    }

    public void connect(SocketAddress saddr, int timeout) throws IOException {
        if (this.underlyingSocket != null) {
            if (dev) {
                Trace.a("SSLSocket.connect(addr, timeout) using underlyingSocket", String.valueOf(saddr.toString()) + " (timeout: " + timeout + ")");
            }
            this.underlyingSocket.connect(saddr, timeout);
        } else {
            if (dev) {
                Trace.a("SSLSocket.connect(addr, timeout)", String.valueOf(saddr.toString()) + " (timeout: " + timeout + ")");
            }
            super.connect(saddr, timeout);
        }
    }

    public void bind(SocketAddress saddr) throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.bind(saddr);
        } else {
            super.bind(saddr);
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getLocalSocketAddress();
        }
        return super.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public boolean isBound() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isBound();
        }
        return super.isBound();
    }

    public boolean isClosed() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isClosed();
        }
        return super.isClosed();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getRemoteSocketAddress();
        }
        return super.getRemoteSocketAddress();
    }

    public void setOOBInline(boolean flag) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setOOBInline(flag);
        } else {
            super.setOOBInline(flag);
        }
    }

    public boolean getOOBInline() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getOOBInline();
        }
        return super.getOOBInline();
    }

    public void setKeepAlive(boolean flag) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setKeepAlive(flag);
        } else {
            super.setKeepAlive(flag);
        }
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getKeepAlive();
        }
        return super.getKeepAlive();
    }

    public void setTrafficClass(int clazz) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setTrafficClass(clazz);
        } else {
            super.setTrafficClass(clazz);
        }
    }

    public int getTrafficClass() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getTrafficClass();
        }
        return super.getTrafficClass();
    }

    public void setReuseAddress(boolean flag) throws SocketException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.setReuseAddress(flag);
        } else {
            super.setReuseAddress(flag);
        }
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.getReuseAddress();
        }
        return super.getReuseAddress();
    }

    public void shutdownInput() throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.shutdownInput();
        } else {
            super.shutdownInput();
        }
    }

    public void shutdownOutput() throws IOException {
        if (this.underlyingSocket != null) {
            this.underlyingSocket.shutdownOutput();
        } else {
            super.shutdownOutput();
        }
    }

    public boolean isConnected() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isConnected();
        }
        return super.isConnected();
    }

    public boolean isInputShutdown() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isInputShutdown();
        }
        return super.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        if (this.underlyingSocket != null) {
            return this.underlyingSocket.isOutputShutdown();
        }
        return super.isOutputShutdown();
    }

    protected void finalize() {
        if (this.session.currentAlert == null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    void setEnabledCipherSuites(List suites) {
        this.session.enabledSuites = suites;
    }

    void setEnabledProtocols(SortedSet protocols) {
        this.session.enabledProtocols = protocols;
    }

    void setTrustManager(X509TrustManager trustManager) {
        this.session.trustManager = trustManager;
    }

    void setKeyManager(X509KeyManager keyManager) {
        this.session.keyManager = keyManager;
    }

    void setRandom(SecureRandom random) {
        this.session.random = random;
    }

    void sendAlert(Alert alert) throws IOException {
        RecordOutputStream out = new RecordOutputStream(this.socketOut, ContentType.ALERT, this.session.params);
        try {
            out.write(alert.getEncoded());
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Alert checkAlert() {
        return this.session.currentAlert;
    }

    synchronized void checkHandshakeDone() throws IOException {
        Alert alert;
        if (dev) {
            Trace.a("SSLSocket.checkHandshakeDone", "handshakeDone: " + this.handshakeDone);
        }
        if (!this.handshakeDone) {
            this.startHandshake();
        }
        if (dev) {
            Trace.a("SSLSocket.checkHandshakeDone", "handshakeDone2: " + this.handshakeDone);
        }
        if ((alert = this.session.currentAlert) != null && alert.getLevel() == Alert.Level.FATAL) {
            throw new AlertException(alert, false);
        }
        if (this.handshakeIn.available() > 0 && !this.clientMode) {
            this.handshakeDone = false;
            this.startHandshake();
        }
    }

    private void changeCipherSpec() throws IOException {
        RecordOutputStream out = new RecordOutputStream(this.socketOut, ContentType.CHANGE_CIPHER_SPEC, this.session.params);
        out.write(1);
    }

    private void readChangeCipherSpec() throws IOException {
        RecordInputStream in = new RecordInputStream(this.recordInput, ContentType.CHANGE_CIPHER_SPEC);
        if (dev) {
            Trace.a("SSLSocket.readChangeCipherSpec()", "init ok recordInput is null?" + (this.recordInput == null));
        }
        if (in.read() != 1) {
            throw new SSLProtocolException("Invalid change cipher spec message");
        }
        if (dev) {
            Trace.a("SSLSocket.readChangeCipherSpec()", "done");
        }
    }

    private synchronized void setupIO() throws IOException {
        if (this.recordInput != null) {
            return;
        }
        if (dev) {
            Trace.a("SSLSocket.setupIO()", "INIT_COUNT");
        }
        if (this.underlyingSocket != null) {
            this.socketIn = this.underlyingSocket.getInputStream();
            this.socketOut = this.underlyingSocket.getOutputStream();
            if (dev) {
                Trace.a("SSLSocket.setupIO()", "init underlyingSocket.. ok");
            }
        } else {
            this.socketIn = new ControlInputStream(super.getInputStream());
            this.socketOut = super.getOutputStream();
            if (dev) {
                Trace.a("SSLSocket.setupIO()", "init super.socket.. ok");
            }
        }
        this.recordInput = new RecordInput(this.socketIn, this.session);
        this.applicationIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.APPLICATION_DATA), this);
        this.applicationOut = new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.APPLICATION_DATA, this.session.params), this);
        this.handshakeIn = new SSLSocketInputStream(new RecordInputStream(this.recordInput, ContentType.HANDSHAKE), this, false);
        this.handshakeOut = new BufferedOutputStream(new SSLSocketOutputStream(new RecordOutputStream(this.socketOut, ContentType.HANDSHAKE, this.session.params), this, false), 8096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshakeCompleted() {
        this.handshakeDone = true;
        this.handshakeStart = false;
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.session);
        Iterator it = this.handshakeListeners.iterator();
        while (it.hasNext()) {
            try {
                ((HandshakeCompletedListener)it.next()).handshakeCompleted(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.createSessions) {
            Session session = this.session;
            synchronized (session) {
                this.sessionContext.addSession(this.session.sessionId, this.session);
                this.session.access();
            }
        }
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("Handshake finished in " + Thread.currentThread());
            this.handshakeTime = System.currentTimeMillis() - this.handshakeTime;
            debug.println("Elapsed time " + this.handshakeTime / 1000L + "s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClientHandshake() throws IOException {
        Object preMasterSecret;
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("starting client handshake in " + Thread.currentThread());
        }
        this.handshakeStart = true;
        if (dev) {
            Trace.a("SSLSocket.()", "INIT_COUNT");
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "handshake start..");
        }
        BtwMessageDigest md5 = HashFactory.getInstance("md5");
        BtwMessageDigest sha = HashFactory.getInstance("sha-160");
        DigestInputStream din = new DigestInputStream(this.handshakeIn, md5, sha);
        DigestOutputStream dout = new DigestOutputStream(this.handshakeOut, md5, sha);
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "setup hash alg");
        }
        Session continuedSession = null;
        byte[] sessionId = new byte[]{};
        List extensions = null;
        Object user = null;
        CertificateType certType = CertificateType.X509;
        Enumeration e = this.sessionContext.getIds();
        while (e.hasMoreElements()) {
            byte[] id = (byte[])e.nextElement();
            continuedSession = (Session)this.sessionContext.getSession(id);
            if (continuedSession == null) continue;
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "continuedSesion id[" + Util.toHexString(continuedSession.getId()) + "]");
            }
            if (!this.session.enabledProtocols.contains(continuedSession.protocol)) continue;
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "continuedSesion.getPeerHost[" + continuedSession.getPeerHost() + "] isValid[" + continuedSession.isValid() + "]");
            }
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "remoteHost: " + this.remoteHost);
            }
            if (this.remoteHost == null || !this.remoteHost.equals(continuedSession.getPeerHost()) || !continuedSession.isValid()) continue;
            sessionId = id;
            break;
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "session check : " + (sessionId.length > 0 ? Util.hexDump(sessionId) : "None"));
        }
        ProtocolVersion version = this.session.protocol;
        byte[] tmpSeed = new byte[28];
        this.session.random.nextBytes(tmpSeed);
        Random clientRandom = new Random(Util.unixTime(), tmpSeed);
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "generate client random");
        }
        this.session.protocol = (ProtocolVersion)this.session.enabledProtocols.last();
        ArrayList<CompressionMethod> comp = new ArrayList<CompressionMethod>(1);
        comp.add(CompressionMethod.NULL);
        ClientHello clientHello = new ClientHello(this.session.protocol, clientRandom, sessionId, this.session.enabledSuites, comp, extensions);
        Handshake msg = new Handshake(Handshake.Type.CLIENT_HELLO, clientHello);
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println(msg);
        }
        msg.write(dout, version);
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "debug point.1");
        }
        dout.flush();
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "debug point.2");
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "## send client-hello");
        }
        msg = Handshake.read(din);
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "## receive server-hello");
        }
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println(msg);
        }
        if (msg.getType() == Handshake.Type.CLIENT_HELLO) {
            this.fatal();
            throw new SSLProtocolException("both sockets try to handshake as a 'client'");
        }
        if (msg.getType() != Handshake.Type.SERVER_HELLO) {
            this.unexpectedMessage();
        }
        ServerHello serverHello = (ServerHello)msg.getBody();
        Random serverRandom = serverHello.getRandom();
        version = serverHello.getVersion();
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "check server version : " + version);
        }
        if (!this.session.enabledProtocols.contains(version)) {
            ProtocolVersion v1 = null;
            ProtocolVersion v2 = null;
            Iterator it = this.session.enabledProtocols.iterator();
            while (it.hasNext()) {
                v1 = (ProtocolVersion)it.next();
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "alt version v1: " + v1);
                }
                if (v1.compareTo(version) > 0) break;
                v2 = v1;
            }
            version = v1;
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "check version : " + version);
        }
        if (version == null) {
            Alert.Description desc = null;
            desc = serverHello.getVersion() == ProtocolVersion.SSL_3 ? Alert.Description.HANDSHAKE_FAILURE : Alert.Description.PROTOCOL_VERSION;
            Alert alert = new Alert(Alert.Level.FATAL, desc);
            this.sendAlert(alert);
            this.session.currentAlert = alert;
            this.fatal();
            throw new AlertException(alert, true);
        }
        if (serverHello.getExtensions() != null) {
            Iterator it = serverHello.getExtensions().iterator();
            while (it.hasNext()) {
                Extension e2 = (Extension)it.next();
                if (e2.getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                    int len = Extensions.getMaxFragmentLength(e2);
                    this.session.params.setFragmentLength(len);
                    continue;
                }
                if (e2.getType() != Extension.Type.CERT_TYPE) continue;
                certType = Extensions.getServerCertType(e2);
            }
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "check extension : " + (serverHello.getExtensions() != null));
        }
        CipherSuite suite = serverHello.getCipherSuite().resolve(version);
        boolean newSession = true;
        if (Arrays.equals(sessionId, serverHello.getSessionId())) {
            SecurityParameters params = this.session.params;
            this.session = (Session)continuedSession.clone();
            this.session.params = params;
            this.recordInput.setSession(this.session);
            suite = this.session.cipherSuite;
            newSession = false;
        } else {
            this.sessionContext.removeSession(new Session.ID(sessionId));
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "newSession : " + newSession);
        }
        if (newSession) {
            this.session.peerHost = this.remoteHost;
            this.session.sessionId = new Session.ID(serverHello.getSessionId());
            this.session.cipherSuite = suite;
        }
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", " ----- [cipher-suite] " + this.session.cipherSuite);
        }
        this.session.params.setInMac(null);
        this.session.params.setOutMac(null);
        this.session.params.setInCipher(null);
        this.session.params.setOutCipher(null);
        this.session.currentAlert = null;
        this.session.valid = true;
        this.session.protocol = version;
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "init session");
        }
        if (newSession) {
            HashMap<String, byte[]> attr;
            PublicKey serverKey = null;
            PublicKey serverKex = null;
            KeyPair clientKeys = null;
            Object clientKex = null;
            boolean sendKeyExchange = false;
            Object srp_x = null;
            if (suite.getSignature() != "anon") {
                msg = Handshake.read(din, certType);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "## receive certificate");
                }
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                if (msg.getType() != Handshake.Type.CERTIFICATE) {
                    this.unexpectedMessage();
                }
                Certificate serverCertificate = (Certificate)msg.getBody();
                X509Certificate[] peerCerts = serverCertificate.getCertificates();
                PublicKey peer0_rsaPublicKey = null;
                try {
                    if (dev) {
                        Trace.a("SSLSocket.doClientHandshake()", "check trusted(" + peerCerts.length + ") start.. ");
                    }
                    this.session.trustManager.checkServerTrusted(peerCerts, suite.getAuthType());
                    if (dev) {
                        Trace.a("SSLSocket.doClientHandshake()", "check trusted(" + peerCerts.length + ").. ok");
                    }
                    if (suite.getSignature() == "RSA" && !((peer0_rsaPublicKey = peerCerts[0].getPublicKey()) instanceof RSAPublicKey)) {
                        if (dev) {
                            Trace.a("SSLSocket.doClientHandshake()", "peerCerts[0].pubkey not instanceof RSAPublicKey !");
                        }
                        peer0_rsaPublicKey = new RSAPublicKeyImpl(peer0_rsaPublicKey);
                        if (dev) {
                            Trace.a("SSLSocket.doClientHandshake()", "impl RSAPublicKey.. ok");
                        }
                    }
                    this.session.peerVerified = true;
                    this.session.peerCerts = peerCerts;
                }
                catch (Exception x) {
                    if (dev) {
                        x.printStackTrace();
                    }
                    this.session.peerVerified = false;
                    this.handshakeFailure();
                }
                serverKex = serverKey = peer0_rsaPublicKey;
            }
            if ((msg = Handshake.read(din, suite, serverKey)).getType() == Handshake.Type.SERVER_KEY_EXCHANGE) {
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "## receive server-key-exchange.. ok");
                }
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                ServerKeyExchange skex = (ServerKeyExchange)msg.getBody();
                serverKex = skex.getPublicKey();
                if (suite.getSignature() != "anon") {
                    SSLRSASignature sig = null;
                    if (suite.getSignature() == "RSA") {
                        sig = new SSLRSASignature();
                    }
                    sig.setupVerify(Collections.singletonMap("btworks.crypto.sig.public.key", serverKey));
                    byte[] buf = clientRandom.getEncoded();
                    sig.update(buf, 0, buf.length);
                    buf = serverRandom.getEncoded();
                    sig.update(buf, 0, buf.length);
                    if (suite.getKeyExchange() == "RSA") {
                        this.updateSig(sig, ((RSAPublicKey)serverKex).getModulus());
                        this.updateSig(sig, ((RSAPublicKey)serverKex).getPublicExponent());
                    }
                    if (!sig.verify(skex.getSignature().getSigValue())) {
                        if (dev) {
                            Trace.a("SSLSocket.doClientHandshake()", "signature verify.. fail");
                        }
                        this.handshakeFailure();
                    }
                    if (dev) {
                        Trace.a("SSLSocket.doClientHandshake()", "signature verify.. ok");
                    }
                }
                msg = Handshake.read(din, suite, serverKey);
            }
            CertificateRequest certReq = null;
            if (msg.getType() == Handshake.Type.CERTIFICATE_REQUEST) {
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "## receive ceritificate-request.. ok");
                }
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                certReq = (CertificateRequest)msg.getBody();
                msg = Handshake.read(din);
            }
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "## receive server-hello-done.. ok");
            }
            if (msg.getType() != Handshake.Type.SERVER_HELLO_DONE) {
                this.unexpectedMessage();
            }
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            if (certReq != null) {
                String alias = this.session.keyManager.chooseClientAlias(certReq.getTypeStrings(), certReq.getAuthorities(), null);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "feedback cert-req start.." + alias);
                }
                if (alias == null && version == ProtocolVersion.SSL_3) {
                    Alert alert = new Alert(Alert.Level.WARNING, Alert.Description.NO_CERTIFICATE);
                    this.sendAlert(alert);
                } else {
                    X509Certificate[] chain = this.session.keyManager.getCertificateChain(alias);
                    PrivateKey key = this.session.keyManager.getPrivateKey(alias);
                    if (chain == null) {
                        if (dev) {
                            Trace.a("SSLSocket.doClientHandshake()", "cert chain is null ");
                        }
                        chain = new X509Certificate[]{};
                    }
                    if (dev) {
                        Trace.a("SSLSocket.doClientHandshake()", "cert chain length: " + chain.length);
                    }
                    Certificate cert = new Certificate(chain);
                    msg = new Handshake(Handshake.Type.CERTIFICATE, cert);
                    if (DEBUG_HANDSHAKE_LAYER) {
                        debug.println(msg);
                    }
                    msg.write(dout, version);
                    dout.flush();
                    if (chain.length > 0) {
                        this.session.localCerts = chain;
                        clientKeys = new KeyPair(chain[0].getPublicKey(), key);
                    }
                }
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "feedback cert-req.. ok");
                }
            }
            preMasterSecret = null;
            ClientKeyExchange ckex = null;
            if (suite.getKeyExchange() == "RSA") {
                ProtocolVersion v = (ProtocolVersion)this.session.enabledProtocols.last();
                byte[] randBytes = new byte[46];
                this.session.random.nextBytes(randBytes);
                preMasterSecret = Util.concat(v.getEncoded(), randBytes);
                EME_PKCS1_V1_5 pkcs1 = EME_PKCS1_V1_5.getInstance((RSAPublicKey)serverKex);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "debug point.3");
                }
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "debug point.3-2 preMasterSecret:\n" + Util.hexDump(preMasterSecret));
                }
                BigInteger bi = new BigInteger(1, pkcs1.encode((byte[])preMasterSecret, new java.util.Random()));
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "debug point.4 bi:\n" + Util.hexDump(bi.toByteArray()));
                }
                bi = RSA.encrypt((RSAPublicKey)serverKex, bi);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "rsa encryption.. ok");
                }
                ckex = new ClientKeyExchange(Util.trim(bi));
            } else if (suite.getKeyExchange() == "null") {
                preMasterSecret = Util.concat(version.getEncoded(), new byte[46]);
                java.util.Random rand = new java.util.Random();
                rand.nextBytes((byte[])preMasterSecret);
            }
            msg = new Handshake(Handshake.Type.CLIENT_KEY_EXCHANGE, ckex);
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            msg.write(dout, version);
            dout.flush();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "## send client-key-exchange");
            }
            if (DEBUG_KEY_EXCHANGE && preMasterSecret != null) {
                debug.println("preMasterSecret= " + Util.toHexString(preMasterSecret, ':'));
                debug.println("client.random  = " + Util.toHexString(clientRandom.getEncoded(), ':'));
                debug.println("server.random  = " + Util.toHexString(serverRandom.getEncoded(), ':'));
            }
            BtwRandom genSecret = null;
            if (version == ProtocolVersion.SSL_3) {
                genSecret = new SSLRandom();
                attr = new HashMap<String, byte[]>();
                attr.put("btworks.sslprng.secret", (byte[])preMasterSecret);
                attr.put("btworks.sslprng.seed", Util.concat(clientRandom.getEncoded(), serverRandom.getEncoded()));
                genSecret.init(attr);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "sslv3 init secret.. ok");
                }
            } else {
                genSecret = new TLSRandom();
                attr = new HashMap();
                attr.put("btworks.tls.prng.secret", (byte[])preMasterSecret);
                attr.put("btworks.tls.prng.seed", Util.concat(MASTER_SECRET, Util.concat(clientRandom.getEncoded(), serverRandom.getEncoded())));
                genSecret.init(attr);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "init secret.. ok");
                }
            }
            this.session.masterSecret = new byte[48];
            try {
                genSecret.nextBytes(this.session.masterSecret, 0, 48);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "generate masterSecret.. ok");
                }
                int i = 0;
                while (i < ((byte[])preMasterSecret).length) {
                    preMasterSecret[i] = 0;
                    ++i;
                }
            }
            catch (LimitReachedException shouldNotHappen) {
                this.internalError();
                throw new Error(shouldNotHappen.toString());
            }
            if (DEBUG_KEY_EXCHANGE) {
                debug.println("masterSecret=" + Util.toHexString(this.session.masterSecret, ':'));
            }
            if (certReq != null && clientKeys != null) {
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "handle mycert-verification message start..");
                }
                BtwMessageDigest vMD5 = (BtwMessageDigest)md5.clone();
                BtwMessageDigest vSHA = (BtwMessageDigest)sha.clone();
                PrivateKey key = clientKeys.getPrivate();
                Object sig = null;
                String sigAlg = null;
                try {
                    if (!(key instanceof RSAPrivateKey)) {
                        key = new RSAPrivateKeyImpl(key);
                    }
                    SSLRSASignature rsa = new SSLRSASignature(vMD5, vSHA);
                    rsa.setupSign(Collections.singletonMap("btworks.crypto.sig.private.key", key));
                    sig = rsa.sign();
                    sigAlg = "RSA";
                }
                catch (Exception x) {
                    if (dev) {
                        x.printStackTrace();
                    }
                    this.handshakeFailure();
                }
                CertificateVerify verify = new CertificateVerify(sig, sigAlg);
                msg = new Handshake(Handshake.Type.CERTIFICATE_VERIFY, verify);
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                msg.write(dout, version);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "handle mycert-verification message.. ok");
                }
            }
            dout.flush();
        }
        byte[][] keys = null;
        try {
            keys = this.generateKeys(serverRandom.getEncoded(), clientRandom.getEncoded(), version);
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "generate keys.. ok");
            }
        }
        catch (Exception x) {
            this.internalError();
            throw new Error(x.toString());
        }
        BtwMac readMac = null;
        BtwMac writeMac = null;
        Acc readCipher = null;
        Acc writeCipher = null;
        try {
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "setVersion: " + version);
            }
            this.session.params.setVersion(version);
            HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
            writeMac = CipherSuite.getMac(suite.getMac());
            readMac = CipherSuite.getMac(suite.getMac());
            attr.put("btworks.crypto.mac.key.material", keys[0]);
            if (writeMac != null) {
                writeMac.init(attr);
            }
            attr.put("btworks.crypto.mac.key.material", keys[1]);
            if (readMac != null) {
                readMac.init(attr);
            }
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "init mac.. ok");
            }
            if (!suite.isStreamCipher()) {
                writeCipher = CipherSuite.getCipher(suite.getCipher());
                readCipher = CipherSuite.getCipher(suite.getCipher());
                writeCipher.init(keys[2], keys[4]);
                readCipher.init(keys[3], keys[5]);
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "init cipher.. ok");
                }
            }
        }
        catch (InvalidKeyException ike) {
            this.internalError();
            throw new Error(ike.toString());
        }
        Finished finis = null;
        if (dev) {
            Trace.a("SSLSocket.doClientHandshake()", "branch#1 : " + newSession);
        }
        boolean zlibFlag = false;
        if (serverHello.getCompressionMethod() == CompressionMethod.ZLIB) {
            zlibFlag = true;
        }
        if (newSession) {
            this.changeCipherSpec();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "change ns.cipherSpec.. ok");
            }
            if (dev) {
                System.out.println("servetHello.getCompressionMethod: " + serverHello.getCompressionMethod());
            }
            this.session.params.setDeflating(zlibFlag);
            this.session.params.setOutMac(writeMac);
            this.session.params.resetOutCounter();
            if (writeCipher != null) {
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "setup ns.stream-param.. ok");
                }
                this.session.params.setOutCipher(writeCipher);
            }
            finis = this.generateFinished(version, (BtwMessageDigest)md5.clone(), (BtwMessageDigest)sha.clone(), true);
            msg = new Handshake(Handshake.Type.FINISHED, finis);
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            msg.write(dout, version);
            dout.flush();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "## send ns.finished");
            }
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        SecurityParameters securityParameters = this.session.params;
        preMasterSecret = securityParameters;
        synchronized (securityParameters) {
            byte[] tt;
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "handle stream-param start..");
            }
            this.readChangeCipherSpec();
            this.session.params.setInflating(zlibFlag);
            this.session.params.setInMac(readMac);
            if (readCipher != null) {
                this.session.params.setInCipher(readCipher);
            }
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "handle stream-param doing 2..");
            }
            this.session.params.resetInCounter();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "handle stream-param doing 3..");
            }
            this.session.params.notifyAll();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "handle stream-param.. ok");
            }
            // ** MonitorExit[preMasterSecret /* !! */ ] (shouldn't be in output)
            Finished verify = this.generateFinished(version, (BtwMessageDigest)md5.clone(), (BtwMessageDigest)sha.clone(), false);
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "generate verify...");
            }
            msg = Handshake.read(din, suite, null);
            if (!zlibFlag && (tt = new byte[((SSLSocketInputStream)this.handshakeIn).available2()]).length > 0) {
                this.handshakeIn.read(tt);
            }
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "## read finished");
            }
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            if (msg.getType() != Handshake.Type.FINISHED) {
                this.unexpectedMessage();
            }
            finis = (Finished)msg.getBody();
            if (CipherSuite.getMac(suite.getMac()) != null) {
                if (version == ProtocolVersion.SSL_3) {
                    if (!Arrays.equals(finis.getMD5Hash(), verify.getMD5Hash()) || !Arrays.equals(finis.getSHAHash(), verify.getSHAHash())) {
                        this.handshakeFailure();
                    }
                } else if (!Arrays.equals(finis.getVerifyData(), verify.getVerifyData())) {
                    this.handshakeFailure();
                }
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "verify finished.. ok");
                }
            } else if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "NULL mac (skip verify)");
            }
            if (!newSession) {
                this.changeCipherSpec();
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "change cs.cipherSpec.. ok");
                }
                this.session.params.setDeflating(zlibFlag);
                this.session.params.setOutMac(writeMac);
                this.session.params.resetOutCounter();
                if (writeCipher != null) {
                    this.session.params.setOutCipher(writeCipher);
                }
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "setup cs.stream-param.. ok");
                }
                finis = this.generateFinished(version, md5, sha, true);
                msg = new Handshake(Handshake.Type.FINISHED, finis);
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                msg.write(dout, version);
                dout.flush();
                if (dev) {
                    Trace.a("SSLSocket.doClientHandshake()", "## send cs.finished");
                }
            }
            this.handshakeCompleted();
            if (dev) {
                Trace.a("SSLSocket.doClientHandshake()", "handshake completed.. ok");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServerHandshake() throws IOException {
        byte[] tt;
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("doing server handshake in " + Thread.currentThread());
        }
        this.handshakeStart = true;
        if (this.remoteHost == null) {
            this.remoteHost = this.getInetAddress().getHostName();
        }
        BtwMessageDigest md5 = HashFactory.getInstance("md5");
        BtwMessageDigest sha = HashFactory.getInstance("sha-160");
        DigestInputStream din = new DigestInputStream(this.handshakeIn, md5, sha);
        DigestOutputStream dout = new DigestOutputStream(this.handshakeOut, md5, sha);
        Handshake msg = Handshake.read(din);
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println(msg);
        }
        if (msg.getType() != Handshake.Type.CLIENT_HELLO) {
            this.unexpectedMessage();
        }
        ClientHello clientHello = (ClientHello)msg.getBody();
        Random clientRandom = clientHello.getRandom();
        ProtocolVersion version = clientHello.getVersion();
        ProtocolVersion server = (ProtocolVersion)this.session.enabledProtocols.last();
        CompressionMethod comp = clientHello.getCompressionMethods().contains(CompressionMethod.ZLIB) ? CompressionMethod.ZLIB : CompressionMethod.NULL;
        if (!this.session.enabledProtocols.contains(version) && version.compareTo(server) < 0) {
            Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.PROTOCOL_VERSION);
            this.sendAlert(alert);
            this.session.currentAlert = alert;
            throw new AlertException(alert, true);
        }
        LinkedList<Extension> extensions = null;
        String remoteUser = null;
        if (clientHello.getExtensions() != null) {
            Iterator it = clientHello.getExtensions().iterator();
            while (it.hasNext()) {
                Extension ex = (Extension)it.next();
                if (ex.getType() == Extension.Type.SERVER_NAME) {
                    if (extensions == null) {
                        extensions = new LinkedList<Extension>();
                    }
                    extensions.add(ex);
                    continue;
                }
                if (ex.getType() == Extension.Type.MAX_FRAGMENT_LENGTH) {
                    int maxLen = Extensions.getMaxFragmentLength(ex);
                    this.session.params.setFragmentLength(maxLen);
                    if (extensions == null) {
                        extensions = new LinkedList();
                    }
                    extensions.add(ex);
                    continue;
                }
                if (ex.getType() != Extension.Type.SRP) continue;
                if (extensions == null) {
                    extensions = new LinkedList();
                }
                byte[] b = ex.getValue();
                remoteUser = new String(ex.getValue(), 1, b[0] & 0xFF, "UTF-8");
                this.session.putValue("srp-username", remoteUser);
            }
        }
        CipherSuite suite = this.selectSuite(clientHello.getCipherSuites(), version);
        if (dev) {
            Trace.a("SSLSocket.doServerHandshake()", "suite : " + suite);
        }
        if (suite == null) {
            return;
        }
        boolean newSession = true;
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("saved sessions = " + this.sessionContext);
        }
        if (this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId()))) {
            Session old = this.session;
            this.session = (Session)this.sessionContext.getSession(clientHello.getSessionId());
            if (!clientHello.getCipherSuites().contains(this.session.cipherSuite)) {
                this.handshakeFailure();
            }
            if (this.session.getPeerHost().equals(this.remoteHost) && old.enabledProtocols.contains(this.session.protocol)) {
                this.session = (Session)this.session.clone();
                suite = this.session.cipherSuite;
                newSession = false;
                this.recordInput.setSession(this.session);
                this.session.currentAlert = null;
                this.session.params = old.params;
            } else {
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println("rejected session1");
                    debug.println("hosts equal? " + this.session.getPeerHost().equals(this.remoteHost));
                    debug.println("same suites? " + old.enabledProtocols.contains(this.session.protocol));
                }
                this.session = old;
                this.session.peerHost = this.remoteHost;
                newSession = true;
            }
        } else if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("rejected session2");
            debug.println("have session id? " + this.sessionContext.containsSessionID(new Session.ID(clientHello.getSessionId())));
            debug.println("saved sessions = " + this.sessionContext);
        }
        if (newSession) {
            if (!this.createSessions) {
                if (dev) {
                    System.out.println("[SSLSocket.doServerHandshake] not allow to create new session");
                }
                this.handshakeFailure();
                throw new SSLException("new session creations are not allowed");
            }
            byte[] buf = new byte[32];
            Session.ID sid = null;
            do {
                this.session.random.nextBytes(buf);
            } while (this.sessionContext.containsSessionID(sid = new Session.ID(buf)));
            this.session.sessionId = sid;
        }
        this.session.valid = true;
        this.session.peerHost = this.remoteHost;
        this.session.cipherSuite = suite;
        this.session.protocol = version;
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("[SSLSocket.doServerHandshake] session.protocol: " + version);
        }
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("[SSLSocket.doServerHandshake] session.ciphersuite: " + suite);
        }
        this.session.params.version = version;
        Random serverRandom = new Random(Util.unixTime(), this.session.random.generateSeed(28));
        ServerHello serverHello = new ServerHello(version, serverRandom, this.session.getId(), suite, comp, extensions);
        msg = new Handshake(Handshake.Type.SERVER_HELLO, serverHello);
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println(msg);
        }
        msg.write(dout, version);
        dout.flush();
        if (newSession) {
            HashMap<String, byte[]> attr;
            X509Certificate[] certs = null;
            PrivateKey serverKey = null;
            if (suite.getSignature() != "anon") {
                String alias = this.session.keyManager.chooseServerAlias(suite.getAuthType(), null, null);
                certs = this.session.keyManager.getCertificateChain(alias);
                serverKey = this.session.keyManager.getPrivateKey(alias);
                if (certs == null || serverKey == null) {
                    this.handshakeFailure();
                }
                this.session.localCerts = certs;
                Certificate serverCert = new Certificate(certs);
                msg = new Handshake(Handshake.Type.CERTIFICATE, serverCert);
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                msg.write(dout, version);
                dout.flush();
            }
            KeyPair signPair = null;
            if (certs != null) {
                signPair = new KeyPair(certs[0].getPublicKey(), serverKey);
            }
            KeyPair kexPair = signPair;
            ServerKeyExchange skex = null;
            if (suite.getKeyExchange() == "RSA" && suite.isExportable() && ((RSAPrivateKey)serverKey).getModulus().bitLength() > 512) {
                kexPair = KeyPool.generateRSAKeyPair();
                RSAPublicKey pubkey = (RSAPublicKey)kexPair.getPublic();
                Signature s = null;
                if (suite.getSignature() != "anon") {
                    SSLRSASignature sig = new SSLRSASignature();
                    sig.setupSign(Collections.singletonMap("btworks.crypto.sig.private.key", signPair.getPrivate()));
                    byte[] buf = clientRandom.getEncoded();
                    sig.update(buf, 0, buf.length);
                    buf = serverRandom.getEncoded();
                    sig.update(buf, 0, buf.length);
                    this.updateSig(sig, pubkey.getModulus());
                    this.updateSig(sig, pubkey.getPublicExponent());
                    s = new Signature(sig.sign(), "RSA");
                }
                skex = new ServerKeyExchange(pubkey, s);
            }
            if (skex != null) {
                msg = new Handshake(Handshake.Type.SERVER_KEY_EXCHANGE, skex);
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(msg);
                }
                msg.write(dout, version);
                dout.flush();
            }
            if (this.wantClientAuth || this.needClientAuth) {
                Principal[] auths = null;
                CertificateRequest.ClientType[] types = new CertificateRequest.ClientType[]{CertificateRequest.ClientType.RSA_SIGN, CertificateRequest.ClientType.DSS_SIGN, CertificateRequest.ClientType.RSA_FIXED_DH, CertificateRequest.ClientType.DSS_FIXED_DH};
                try {
                    Object[] objectArray = this.session.trustManager.getAcceptedIssuers();
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.security.Principal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    auths = (Principal[])Util.transform(objectArray, clazz, "getSubjectDN", null);
                }
                catch (Exception x) {
                    this.internalError();
                }
                CertificateRequest req = new CertificateRequest(types, auths);
                msg = new Handshake(Handshake.Type.CERTIFICATE_REQUEST, req);
                msg.write(dout, version);
                dout.flush();
            }
            msg = new Handshake(Handshake.Type.SERVER_HELLO_DONE, null);
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            msg.write(dout, version);
            dout.flush();
            if (suite.getKeyExchange() == "RSA") {
                if (dev) {
                    Trace.a("SSLSocket.doServerHandshake()", "suite.getKeyExchage() is RSA");
                }
                msg = Handshake.read(din, suite, kexPair.getPublic(), CertificateType.X509);
            } else {
                if (dev) {
                    Trace.a("SSLSocket.doServerHandshake()", "suite.getKeyExchage() is null");
                }
                msg = Handshake.read(din, suite, null);
            }
            boolean clientCertOk = false;
            boolean clientCanSign = false;
            X509Certificate[] clientChain = null;
            RSAPublicKeyImpl clientKey = null;
            if (dev) {
                Trace.a("SSLSocket.doServerHandshake()", "check whether certifcate sent");
            }
            if (msg.getType() == Handshake.Type.CERTIFICATE) {
                block114: {
                    if (DEBUG_HANDSHAKE_LAYER) {
                        debug.println(msg);
                    }
                    Certificate cliCert = (Certificate)msg.getBody();
                    if (dev) {
                        Trace.a("SSLSocket.doServerHandshake()", "getCertififate");
                    }
                    clientChain = cliCert.getCertificates();
                    if (dev) {
                        Trace.a("SSLSocket.doServerHandshake()", "getCertificate done");
                    }
                    try {
                        this.session.trustManager.checkClientTrusted(clientChain, suite.getAuthType());
                        this.session.peerCerts = clientChain;
                        this.session.peerVerified = true;
                        clientKey = new RSAPublicKeyImpl(clientChain[0].getPublicKey());
                    }
                    catch (Exception x) {
                        this.session.peerVerified = false;
                        if (!dev) break block114;
                        x.printStackTrace();
                    }
                }
                clientCanSign = clientKey instanceof RSAPublicKey;
                msg = Handshake.read(din, suite, kexPair.getPublic());
            }
            if (dev) {
                Trace.a("SSLSocket.doServerHandshake()", "check whether certifcate sent done");
            }
            if (!this.session.peerVerified && this.needClientAuth) {
                if (dev) {
                    Trace.a("SSLSocket.doServerHandshake()", "client auth fail session.peerVerified: " + this.session.peerVerified + "   needClientAuth: " + this.needClientAuth);
                }
                this.handshakeFailure();
            }
            if (msg.getType() != Handshake.Type.CLIENT_KEY_EXCHANGE) {
                this.unexpectedMessage();
            }
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            ClientKeyExchange ckex = (ClientKeyExchange)msg.getBody();
            byte[] preMasterSecret = null;
            if (suite.getKeyExchange() == "RSA") {
                byte[] enc = (byte[])ckex.getExchangeObject();
                BigInteger bi = new BigInteger(1, enc);
                try {
                    PrivateKey prvkey = kexPair.getPrivate();
                    RSAPrivateKey rsaPrvkey = null;
                    rsaPrvkey = prvkey instanceof RSAPrivateKey ? (RSAPrivateKey)prvkey : new RSAPrivateKeyImpl(prvkey);
                    bi = RSA.decrypt(rsaPrvkey, bi);
                    if (dev) {
                        Trace.a("SSLSocket.doServerHandshake()", "client kex decrypted:\n" + Util.hexDump(bi.toByteArray()));
                    }
                    EME_PKCS1_V1_5 pkcs1 = EME_PKCS1_V1_5.getInstance(rsaPrvkey);
                    preMasterSecret = pkcs1.decode(Util.concat(new byte[1], bi.toByteArray()));
                }
                catch (Exception x) {
                    if (dev) {
                        x.printStackTrace();
                    }
                    preMasterSecret = Util.concat(version.getEncoded(), new byte[46]);
                    java.util.Random rand = new java.util.Random();
                    rand.nextBytes(preMasterSecret);
                }
            } else if (suite.getKeyExchange() == "null") {
                preMasterSecret = Util.concat(version.getEncoded(), new byte[46]);
                java.util.Random rand = new java.util.Random();
                rand.nextBytes(preMasterSecret);
            }
            if (DEBUG_KEY_EXCHANGE && preMasterSecret != null) {
                debug.println("preMasterSecret= " + Util.toHexString(preMasterSecret, ':'));
                debug.println("client.random  = " + Util.toHexString(clientRandom.getEncoded(), ':'));
                debug.println("server.random  = " + Util.toHexString(serverRandom.getEncoded(), ':'));
            }
            BtwRandom genSecret = null;
            if (version == ProtocolVersion.SSL_3) {
                genSecret = new SSLRandom();
                attr = new HashMap<String, byte[]>();
                attr.put("btworks.sslprng.secret", preMasterSecret);
                attr.put("btworks.sslprng.seed", Util.concat(clientRandom.getEncoded(), serverRandom.getEncoded()));
                genSecret.init(attr);
            } else {
                genSecret = new TLSRandom();
                attr = new HashMap();
                attr.put("btworks.tls.prng.secret", preMasterSecret);
                attr.put("btworks.tls.prng.seed", Util.concat(MASTER_SECRET, Util.concat(clientRandom.getEncoded(), serverRandom.getEncoded())));
                genSecret.init(attr);
            }
            this.session.masterSecret = new byte[48];
            try {
                genSecret.nextBytes(this.session.masterSecret, 0, 48);
                int i = 0;
                while (i < preMasterSecret.length) {
                    preMasterSecret[i] = 0;
                    ++i;
                }
            }
            catch (LimitReachedException shouldNotHappen) {
                this.internalError();
            }
            if (DEBUG_KEY_EXCHANGE) {
                debug.println("masterSecret=" + Util.toHexString(this.session.masterSecret, ':'));
            }
            if (clientCanSign && (this.wantClientAuth || this.needClientAuth)) {
                msg = Handshake.read(din, suite, (PublicKey)clientKey);
                if (msg.getType() != Handshake.Type.CERTIFICATE_VERIFY) {
                    this.unexpectedMessage();
                }
                if (dev) {
                    Trace.a("SSLSocket.doServerHandshake()", "client signature verify");
                }
                CertificateVerify verify = (CertificateVerify)msg.getBody();
                if (clientChain != null && clientChain.length > 0) {
                    BtwMessageDigest cvMD5 = (BtwMessageDigest)md5.clone();
                    BtwMessageDigest cvSHA = (BtwMessageDigest)sha.clone();
                    clientKey = new RSAPublicKeyImpl(clientChain[0].getPublicKey());
                    if (clientKey instanceof RSAPublicKey) {
                        if (dev) {
                            Trace.a("SSLSocket.doServerHandshake()", "client signature verify 1");
                        }
                        SSLRSASignature sig = new SSLRSASignature(cvMD5, cvSHA);
                        if (dev) {
                            Trace.a("SSLSocket.doServerHandshake()", "client signature verify 2");
                        }
                        sig.setupVerify(Collections.singletonMap("btworks.crypto.sig.public.key", clientKey));
                        if (dev) {
                            Trace.a("SSLSocket.doServerHandshake()", "client signature verify 3");
                        }
                        if (dev) {
                            Trace.a("SSLSocket.doServerHandshake()", "client signature verify 5");
                        }
                    }
                }
            }
        }
        byte[][] keys = null;
        try {
            keys = this.generateKeys(serverRandom.getEncoded(), clientRandom.getEncoded(), version);
        }
        catch (Exception x) {
            this.internalError();
            throw new Error(x.toString());
        }
        BtwMac readMac = null;
        BtwMac writeMac = null;
        Acc readCipher = null;
        Acc writeCipher = null;
        try {
            this.session.params.setVersion(version);
            HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
            writeMac = CipherSuite.getMac(suite.getMac());
            readMac = CipherSuite.getMac(suite.getMac());
            attr.put("btworks.crypto.mac.key.material", keys[1]);
            if (writeMac != null) {
                writeMac.init(attr);
            }
            attr.put("btworks.crypto.mac.key.material", keys[0]);
            if (readMac != null) {
                readMac.init(attr);
            }
            if (!suite.isStreamCipher()) {
                writeCipher = CipherSuite.getCipher(suite.getCipher());
                readCipher = CipherSuite.getCipher(suite.getCipher());
                writeCipher.init(keys[3], keys[5]);
                readCipher.init(keys[2], keys[4]);
            }
        }
        catch (InvalidKeyException ike) {
            this.internalError();
        }
        Finished finis = null;
        if (!newSession) {
            if (dev) {
                Trace.a("SSLSocket.doServerHandshake()", "send our Finished message first");
            }
            this.changeCipherSpec();
            this.session.params.setDeflating(comp == CompressionMethod.ZLIB);
            this.session.params.setOutMac(writeMac);
            this.session.params.resetOutCounter();
            if (writeCipher != null) {
                this.session.params.setOutCipher(writeCipher);
            }
            finis = this.generateFinished(version, (BtwMessageDigest)md5.clone(), (BtwMessageDigest)sha.clone(), false);
            msg = new Handshake(Handshake.Type.FINISHED, finis);
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            msg.write(dout, version);
            dout.flush();
        }
        if (this.session.currentAlert != null && this.session.currentAlert.getLevel() == Alert.Level.FATAL) {
            this.fatal();
            throw new AlertException(this.session.currentAlert, false);
        }
        SecurityParameters clientCanSign = this.session.params;
        synchronized (clientCanSign) {
            this.readChangeCipherSpec();
            this.session.params.setInflating(comp == CompressionMethod.ZLIB);
            this.session.params.setInMac(readMac);
            if (readCipher != null) {
                this.session.params.setInCipher(readCipher);
            }
            this.session.params.resetInCounter();
            this.session.params.notifyAll();
        }
        Finished verify = this.generateFinished(version, (BtwMessageDigest)md5.clone(), (BtwMessageDigest)sha.clone(), true);
        msg = Handshake.read(din, suite, null);
        if (comp == CompressionMethod.NULL && (tt = new byte[((SSLSocketInputStream)this.handshakeIn).available2()]).length > 0) {
            this.handshakeIn.read(tt);
        }
        if (msg.getType() != Handshake.Type.FINISHED) {
            this.unexpectedMessage();
        }
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println(msg);
        }
        finis = (Finished)msg.getBody();
        if (CipherSuite.getMac(suite.getMac()) != null) {
            if (version == ProtocolVersion.SSL_3) {
                if (!Arrays.equals(finis.getMD5Hash(), verify.getMD5Hash()) || !Arrays.equals(finis.getSHAHash(), verify.getSHAHash())) {
                    this.handshakeFailure();
                }
            } else if (!Arrays.equals(finis.getVerifyData(), verify.getVerifyData())) {
                this.handshakeFailure();
            }
        } else if (dev) {
            Trace.a("SSLSocket.doServerHandshake()", "NULL mac (skip verify)");
        }
        if (newSession) {
            this.changeCipherSpec();
            this.session.params.setDeflating(comp == CompressionMethod.ZLIB);
            this.session.params.setOutMac(writeMac);
            this.session.params.resetOutCounter();
            if (writeCipher != null) {
                this.session.params.setOutCipher(writeCipher);
            }
            finis = this.generateFinished(version, md5, sha, false);
            msg = new Handshake(Handshake.Type.FINISHED, finis);
            if (DEBUG_HANDSHAKE_LAYER) {
                debug.println(msg);
            }
            msg.write(dout, version);
            dout.flush();
        }
        this.handshakeCompleted();
    }

    private byte[][] generateKeys(byte[] server, byte[] client, ProtocolVersion activeVersion) throws LimitReachedException, IOException {
        HashMap<String, byte[]> attr;
        CipherSuite suite = this.session.cipherSuite;
        int macLen = suite.getMac().indexOf("MD5") >= 0 ? 16 : 20;
        int keyLen = suite.getKeyLength();
        int ivLen = 0;
        String cipherStr = suite.getCipher();
        if (cipherStr.indexOf("DES") >= 0) {
            ivLen = 8;
        } else if (cipherStr == "SEED" || cipherStr == "AES") {
            ivLen = 16;
        }
        byte[][] keyMaterial = new byte[][]{new byte[macLen], new byte[macLen], new byte[keyLen], new byte[keyLen], new byte[ivLen], new byte[ivLen]};
        BtwRandom prf = null;
        if (activeVersion == ProtocolVersion.SSL_3) {
            prf = new SSLRandom();
            attr = new HashMap<String, byte[]>();
            attr.put("btworks.sslprng.secret", this.session.masterSecret);
            attr.put("btworks.sslprng.seed", Util.concat(server, client));
            prf.init(attr);
        } else {
            prf = new TLSRandom();
            attr = new HashMap();
            attr.put("btworks.tls.prng.secret", this.session.masterSecret);
            attr.put("btworks.tls.prng.seed", Util.concat(KEY_EXPANTION, Util.concat(server, client)));
            prf.init(attr);
        }
        int i = 0;
        while (i < keyMaterial.length) {
            prf.nextBytes(keyMaterial[i], 0, keyMaterial[i].length);
            ++i;
        }
        if (suite.isExportable()) {
            int finalLen;
            int n = finalLen = suite.getCipher() == "DES" ? 8 : 16;
            if (activeVersion == ProtocolVersion.SSL_3) {
                BtwMessageDigest md5 = HashFactory.getInstance("md5");
                md5.update(keyMaterial[2], 0, keyMaterial[2].length);
                md5.update(client, 0, client.length);
                md5.update(server, 0, server.length);
                keyMaterial[2] = Util.trim(md5.digest(), finalLen);
                md5.update(keyMaterial[3], 0, keyMaterial[3].length);
                md5.update(server, 0, server.length);
                md5.update(client, 0, client.length);
                keyMaterial[3] = Util.trim(md5.digest(), finalLen);
                if (!suite.isStreamCipher()) {
                    md5.update(client, 0, client.length);
                    md5.update(server, 0, server.length);
                    keyMaterial[4] = Util.trim(md5.digest(), ivLen);
                    md5.update(server, 0, server.length);
                    md5.update(client, 0, client.length);
                    keyMaterial[5] = Util.trim(md5.digest(), ivLen);
                }
            } else {
                HashMap<String, byte[]> attr2 = new HashMap<String, byte[]>();
                attr2.put("btworks.tls.prng.secret", keyMaterial[2]);
                attr2.put("btworks.tls.prng.seed", Util.concat(CLIENT_WRITE_KEY, Util.concat(client, server)));
                prf.init(attr2);
                keyMaterial[2] = new byte[finalLen];
                prf.nextBytes(keyMaterial[2], 0, finalLen);
                attr2.put("btworks.tls.prng.secret", keyMaterial[3]);
                attr2.put("btworks.tls.prng.seed", Util.concat(SERVER_WRITE_KEY, Util.concat(client, server)));
                prf.init(attr2);
                keyMaterial[3] = new byte[finalLen];
                prf.nextBytes(keyMaterial[3], 0, finalLen);
                if (!suite.isStreamCipher()) {
                    attr2.put("btworks.tls.prng.secret", new byte[0]);
                    attr2.put("btworks.tls.prng.seed", Util.concat(IV_BLOCK, Util.concat(client, server)));
                    prf.init(attr2);
                    prf.nextBytes(keyMaterial[4], 0, keyMaterial[4].length);
                    prf.nextBytes(keyMaterial[5], 0, keyMaterial[5].length);
                }
            }
        }
        if (DEBUG_KEY_EXCHANGE) {
            debug.println("Generated keys:");
            i = 0;
            while (i < keyMaterial.length) {
                debug.println(String.valueOf(i) + "=" + Util.toHexString(keyMaterial[i], ':'));
                ++i;
            }
        }
        return keyMaterial;
    }

    private Finished generateFinished(ProtocolVersion version, BtwMessageDigest md5, BtwMessageDigest sha, boolean client) {
        if (version == ProtocolVersion.SSL_3) {
            if (client) {
                md5.update(SENDER_CLIENT, 0, 4);
            } else {
                md5.update(SENDER_SERVER, 0, 4);
            }
            byte[] ms = this.session.masterSecret;
            md5.update(ms, 0, ms.length);
            int i = 0;
            while (i < 48) {
                md5.update((byte)54);
                ++i;
            }
            byte[] b = md5.digest();
            md5.update(ms, 0, ms.length);
            int i2 = 0;
            while (i2 < 48) {
                md5.update((byte)92);
                ++i2;
            }
            md5.update(b, 0, b.length);
            if (client) {
                sha.update(SENDER_CLIENT, 0, 4);
            } else {
                sha.update(SENDER_SERVER, 0, 4);
            }
            sha.update(ms, 0, ms.length);
            i2 = 0;
            while (i2 < 40) {
                sha.update((byte)54);
                ++i2;
            }
            b = sha.digest();
            sha.update(ms, 0, ms.length);
            i2 = 0;
            while (i2 < 40) {
                sha.update((byte)92);
                ++i2;
            }
            sha.update(b, 0, b.length);
            return new Finished(md5.digest(), sha.digest());
        }
        byte[] h1 = md5.digest();
        byte[] h2 = sha.digest();
        byte[] label = client ? CLIENT_FINISHED : SERVER_FINISHED;
        byte[] seed = null;
        seed = Util.concat(label, Util.concat(h1, h2));
        TLSRandom prf = new TLSRandom();
        HashMap<String, byte[]> attr = new HashMap<String, byte[]>();
        attr.put("btworks.tls.prng.secret", this.session.masterSecret);
        attr.put("btworks.tls.prng.seed", seed);
        prf.init(attr);
        byte[] finishedValue = new byte[12];
        try {
            prf.nextBytes(finishedValue, 0, 12);
        }
        catch (LimitReachedException lre) {
            throw new RuntimeException(lre.toString());
        }
        return new Finished(finishedValue);
    }

    private void unexpectedMessage() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE);
        this.sendAlert(alert);
        this.fatal();
        this.handshakeFail = true;
        throw new AlertException(alert, true);
    }

    private void handshakeFailure() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE);
        this.sendAlert(alert);
        this.fatal();
        throw new AlertException(alert, true);
    }

    private void internalError() throws IOException {
        Alert alert = new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR);
        this.sendAlert(alert);
        this.fatal();
        throw new AlertException(alert, true);
    }

    private CipherSuite selectSuite(List suites, ProtocolVersion version) throws IOException {
        if (DEBUG_HANDSHAKE_LAYER) {
            debug.println("selectSuite req=" + suites + " avail=" + this.session.enabledSuites);
        }
        boolean srpSuiteNoUser = false;
        CipherSuite herSuite = null;
        CipherSuite mySuite = null;
        Iterator i = suites.iterator();
        while (i.hasNext()) {
            herSuite = (CipherSuite)i.next();
            Iterator j = this.session.enabledSuites.iterator();
            while (j.hasNext()) {
                mySuite = (CipherSuite)j.next();
                if (!mySuite.equals(herSuite)) continue;
                if (DEBUG_HANDSHAKE_LAYER) {
                    debug.println(mySuite + " == " + herSuite);
                }
                if (mySuite.getSignature() != "anon" && this.session.keyManager != null && this.session.keyManager.chooseServerAlias(mySuite.getAuthType(), null, null) == null) {
                    if (!DEBUG_HANDSHAKE_LAYER) continue;
                    debug.println(mySuite.getAuthType());
                    debug.println(this.session.keyManager.chooseServerAlias(mySuite.getAuthType(), null, null));
                    debug.println(mySuite + ": no certificate/private key");
                    continue;
                }
                return mySuite.resolve(version);
            }
        }
        Alert alert = null;
        if (srpSuiteNoUser) {
            alert = new Alert(Alert.Level.WARNING, Alert.Description.MISSING_SRP_USERNAME);
            this.sendAlert(alert);
            return null;
        }
        alert = new Alert(Alert.Level.FATAL, Alert.Description.INSUFFICIENT_SECURITY);
        this.sendAlert(alert);
        this.fatal();
        this.handshakeFail = true;
        throw new AlertException(alert, true);
    }

    private String askUserName(String remoteHost) {
        DefaultCallbackHandler handler = new DefaultCallbackHandler();
        TextInputCallback user = new TextInputCallback("User name for " + remoteHost + ": ", Util.getProperty("user.name"));
        try {
            handler.handle(new Callback[]{user});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return user.getText();
    }

    private String askPassword(String user) {
        DefaultCallbackHandler handler = new DefaultCallbackHandler();
        PasswordCallback passwd = new PasswordCallback(String.valueOf(user) + "'s password: ", false);
        try {
            handler.handle(new Callback[]{passwd});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(passwd.getPassword());
    }

    private boolean checkCertificates(X509Certificate[] chain) {
        DefaultCallbackHandler handler = new DefaultCallbackHandler();
        String nl = Util.getProperty("line.separator");
        ConfirmationCallback confirm = new ConfirmationCallback("The server's certificate could not be verified. There is no proof" + nl + "that this server is who it claims to be, or that their certificate" + nl + "is valid. Do you wish to continue connecting?", 2, 0, 1);
        try {
            handler.handle(new Callback[]{confirm});
        }
        catch (Exception x) {
            return false;
        }
        return confirm.getSelectedIndex() == 0;
    }

    private void updateSig(BtwSignature sig, BigInteger bi) {
        byte[] buf = Util.trim(bi);
        sig.update((byte)(buf.length >>> 8));
        sig.update((byte)buf.length);
        sig.update(buf, 0, buf.length);
    }

    private void fatal() throws IOException {
        if (this.session != null) {
            this.session.invalidate();
        }
        if (this.underlyingSocket != null) {
            this.underlyingSocket.close();
        } else {
            super.close();
        }
    }
}

