/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.SSLServerSocket;
import btworks.jsse.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private final SessionContext sessions;
    private final X509KeyManager keyManager;
    private final X509TrustManager trustManager;
    private final SecureRandom random;

    SSLServerSocketFactory(X509TrustManager trustManager, X509KeyManager keyManager, SecureRandom random, SessionContext sessions) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
        this.random = random;
        this.sessions = sessions;
    }

    public String[] getDefaultCipherSuites() {
        return this.getSupportedCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket socket = new SSLServerSocket();
        this.setup(socket);
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = new SSLServerSocket(port);
        this.setup(socket);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = new SSLServerSocket(port, backlog);
        this.setup(socket);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress addr) throws IOException {
        SSLServerSocket socket = new SSLServerSocket(port, backlog, addr);
        this.setup(socket);
        return socket;
    }

    private void setup(SSLServerSocket socket) {
        socket.setSessionContext(this.sessions);
        socket.setKeyManager(this.keyManager);
        socket.setTrustManager(this.trustManager);
        socket.setRandom(this.random);
    }
}

