/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.prng.BtwRandom;
import btworks.crypto.prng.LimitReachedException;
import java.util.Map;

class SSLRandom
implements BtwRandom {
    static final String SECRET = "btworks.sslprng.secret";
    static final String SEED = "btworks.sslprng.seed";
    private final BtwMessageDigest md5 = HashFactory.getInstance("MD5");
    private final BtwMessageDigest sha = HashFactory.getInstance("SHA-1");
    private byte[] secret;
    private byte[] buffer;
    private byte pad;
    private byte[] seed;
    private int idx;

    SSLRandom() {
    }

    public void init(Map attrib) {
        this.secret = (byte[])attrib.get(SECRET);
        this.seed = (byte[])attrib.get(SEED);
        if (this.secret == null || this.seed == null) {
            throw new NullPointerException();
        }
        this.pad = (byte)65;
        try {
            this.buffer = this.nextBlock();
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
    }

    public String name() {
        return "SSLRandom";
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public byte nextByte() throws LimitReachedException {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (this.idx >= this.buffer.length) {
            this.buffer = this.nextBlock();
        }
        return this.buffer[this.idx++];
    }

    public void nextBytes(byte[] buf, int off, int len) throws LimitReachedException {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        while (count < len) {
            if (this.idx >= this.buffer.length) {
                this.buffer = this.nextBlock();
            }
            int l = Math.min(this.buffer.length - this.idx, len - count);
            System.arraycopy(this.buffer, this.idx, buf, off + count, l);
            count += l;
            this.idx += l;
        }
    }

    public boolean selfTest() {
        return true;
    }

    private byte[] nextBlock() throws LimitReachedException {
        int count = this.pad - 65 + 1;
        if (count > 26) {
            throw new LimitReachedException();
        }
        int i = 0;
        while (i < count) {
            this.sha.update(this.pad);
            ++i;
        }
        this.sha.update(this.secret, 0, this.secret.length);
        this.sha.update(this.seed, 0, this.seed.length);
        byte[] b = this.sha.digest();
        this.md5.update(this.secret, 0, this.secret.length);
        this.md5.update(b, 0, b.length);
        this.idx = 0;
        this.pad = (byte)(this.pad + 1);
        return this.md5.digest();
    }
}

