/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.sig.BtwSignature;
import btworks.crypto.sig.rsa.RSA;
import btworks.jsse.provider.Util;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;

final class SSLRSASignature
implements BtwSignature {
    private RSAPublicKey pubkey;
    private RSAPrivateKey privkey;
    private final BtwMessageDigest md5;
    private final BtwMessageDigest sha;
    private boolean initVerify = false;
    private boolean initSign = false;

    SSLRSASignature() {
        this(HashFactory.getInstance("MD5"), HashFactory.getInstance("SHA-1"));
    }

    SSLRSASignature(BtwMessageDigest md5, BtwMessageDigest sha) {
        this.md5 = md5;
        this.sha = sha;
    }

    public String name() {
        return "RSA/SSL";
    }

    public void setupVerify(Map attrib) {
        PublicKey key = (PublicKey)attrib.get("btworks.crypto.sig.public.key");
        if (key == null) {
            if (this.initSign) {
                return;
            }
            throw new IllegalArgumentException("no key supplied");
        }
        if (!(key instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.pubkey = (RSAPublicKey)key;
        this.privkey = null;
        this.initSign = false;
        this.initVerify = true;
    }

    public void setupSign(Map attrib) {
        PrivateKey key = (PrivateKey)attrib.get("btworks.crypto.sig.private.key");
        if (key == null) {
            if (this.initVerify) {
                return;
            }
            throw new IllegalArgumentException("no key supplied");
        }
        if (!(key instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.privkey = (RSAPrivateKey)key;
        this.pubkey = null;
        this.initVerify = false;
        this.initSign = true;
    }

    public void update(byte b) {
        if (!this.initVerify && !this.initSign) {
            throw new IllegalStateException();
        }
        this.md5.update(b);
        this.sha.update(b);
    }

    public void update(byte[] buf, int off, int len) {
        if (!this.initVerify && !this.initSign) {
            throw new IllegalStateException();
        }
        this.md5.update(buf, off, len);
        this.sha.update(buf, off, len);
    }

    public Object sign() {
        byte[] d;
        if (!this.initSign) {
            throw new IllegalStateException();
        }
        int k = this.privkey.getModulus().bitLength() + 7 >>> 3;
        if (k - 11 < (d = Util.concat(this.md5.digest(), this.sha.digest())).length) {
            throw new IllegalArgumentException("message too long");
        }
        byte[] eb = new byte[k];
        eb[0] = 0;
        eb[1] = 1;
        int i = 2;
        while (i < k - d.length - 1) {
            eb[i] = -1;
            ++i;
        }
        System.arraycopy(d, 0, eb, k - d.length, d.length);
        BigInteger EB = new BigInteger(eb);
        BigInteger EM = RSA.sign(this.privkey, EB);
        return Util.trim(EM);
    }

    public boolean verify(Object signature) {
        if (!this.initVerify) {
            throw new IllegalStateException();
        }
        BigInteger EM = new BigInteger(1, (byte[])signature);
        BigInteger EB = RSA.verify(this.pubkey, EM);
        int i = 0;
        byte[] eb = EB.toByteArray();
        if (eb[0] == 0) {
            i = 0;
            while (i < eb.length && eb[i] == 0) {
                ++i;
            }
        } else if (eb[0] == 1) {
            i = 1;
            while (i < eb.length && eb[i] != 0) {
                if (eb[i] != -1) {
                    throw new IllegalArgumentException("bad padding");
                }
                ++i;
            }
            ++i;
        } else {
            throw new IllegalArgumentException("decryption failed");
        }
        byte[] d1 = Util.trim(eb, i, eb.length - i);
        byte[] d2 = Util.concat(this.md5.digest(), this.sha.digest());
        return Arrays.equals(d1, d2);
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

