/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class RecordingInputStream
extends FilterInputStream {
    protected ByteArrayOutputStream sink;

    RecordingInputStream(InputStream in) {
        this(in, new ByteArrayOutputStream());
    }

    RecordingInputStream(InputStream in, ByteArrayOutputStream sink) {
        super(in);
        this.sink = sink;
    }

    public synchronized int read() throws IOException {
        int i = this.in.read();
        this.sink.write(i);
        return i;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int l = this.in.read(buf, off, len);
        this.sink.write(buf, off, l);
        return l;
    }

    public synchronized int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public synchronized long skip(long len) throws IOException {
        long l = 0L;
        int i = 0;
        byte[] buf = new byte[1024];
        while (l < len) {
            i = this.read(buf, 0, (int)Math.min((long)buf.length, len - l));
            if (i == -1) break;
            l += (long)i;
        }
        return l;
    }

    byte[] getBytes() {
        return this.sink.toByteArray();
    }

    void resetSink() {
        this.sink.reset();
    }
}

