/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.util.Prime;
import btworks.jsse.provider.BtwRSAPrivateKey;
import btworks.jsse.provider.BtwRSAPublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Random;

final class KeyPool {
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger E = BigInteger.valueOf(65537L);

    private KeyPool() {
    }

    static KeyPair generateRSAKeyPair() {
        BigInteger q;
        BigInteger n;
        BigInteger p;
        int M = 256;
        BigInteger lower = TWO.pow(255);
        BigInteger upper = TWO.pow(256).subtract(ONE);
        byte[] kb = new byte[32];
        do {
            KeyPool.nextBytes(kb);
        } while ((p = new BigInteger(1, kb).setBit(0)).compareTo(lower) < 0 || p.compareTo(upper) > 0 || !Prime.isProbablePrime(p) || !p.gcd(E).equals(ONE));
        do {
            KeyPool.nextBytes(kb);
        } while ((n = (q = new BigInteger(1, kb).setBit(0)).multiply(p)).bitLength() != 512 || !Prime.isProbablePrime(q) || !q.gcd(E).equals(ONE));
        BigInteger d = E.modInverse(p.subtract(ONE).multiply(q.subtract(ONE)));
        return new KeyPair(new BtwRSAPublicKey(n, E), new BtwRSAPrivateKey(n, d));
    }

    private static void nextBytes(byte[] buf) {
        Random rand = new Random();
        rand.nextBytes(buf);
    }
}

