/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Finished
implements Handshake.Body {
    private final byte[] verifyData;
    private final byte[] md5;
    private final byte[] sha;

    Finished(byte[] verifyData) {
        this.verifyData = verifyData;
        this.sha = null;
        this.md5 = null;
    }

    Finished(byte[] md5, byte[] sha) {
        this.md5 = md5;
        this.sha = sha;
        this.verifyData = null;
    }

    static Finished read(InputStream in, CipherSuite suite) throws IOException {
        DataInputStream din = new DataInputStream(in);
        if (suite.getVersion().equals(ProtocolVersion.SSL_3)) {
            byte[] md5 = new byte[16];
            byte[] sha = new byte[20];
            din.readFully(md5);
            din.readFully(sha);
            return new Finished(md5, sha);
        }
        byte[] buf = new byte[12];
        din.readFully(buf);
        return new Finished(buf);
    }

    public void write(OutputStream out) throws IOException {
        if (this.verifyData != null) {
            out.write(this.verifyData);
        } else {
            out.write(this.md5);
            out.write(this.sha);
        }
    }

    byte[] getVerifyData() {
        return this.verifyData;
    }

    byte[] getMD5Hash() {
        return this.md5;
    }

    byte[] getSHAHash() {
        return this.sha;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        if (this.verifyData != null) {
            return "struct {" + nl + "  verifyData = " + Util.toHexString(this.verifyData, ':') + ";" + nl + "} Finished;" + nl;
        }
        return "struct {" + nl + "  md5Hash = " + Util.toHexString(this.md5, ':') + ";" + nl + "  shaHash = " + Util.toHexString(this.sha, ':') + ";" + nl + "} Finished;" + nl;
    }
}

