/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CertificateType;
import btworks.jsse.provider.Extension;
import btworks.jsse.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class Extensions {
    private static final Integer _512 = new Integer(512);
    private static final Integer _1024 = new Integer(1024);
    private static final Integer _2048 = new Integer(2048);
    private static final Integer _4096 = new Integer(4096);

    private Extensions() {
    }

    static List getServerName(Extension ex) {
        LinkedList<String> l = new LinkedList<String>();
        byte[] buf = ex.getValue();
        int pos = 0;
        try {
            while (pos < buf.length) {
                if (buf[pos++] == 0) {
                    int len = (buf[pos++] & 0xFF) << 8;
                    l.add(new String(buf, pos, len |= buf[pos++] & 0xFF, "UTF-8"));
                    pos += len;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(l);
    }

    static List getClientCertTypes(Extension ex) throws IOException {
        LinkedList<CertificateType> l = new LinkedList<CertificateType>();
        ByteArrayInputStream in = new ByteArrayInputStream(ex.getValue());
        int len = in.read() & 0xFF;
        int i = 0;
        while (i < len) {
            l.add(CertificateType.read(in));
            ++i;
        }
        return Collections.unmodifiableList(l);
    }

    static CertificateType getServerCertType(Extension ex) throws IOException {
        return CertificateType.read(new ByteArrayInputStream(ex.getValue()));
    }

    static Integer getMaxFragmentLength(Extension ex) {
        switch (ex.getValue()[0] & 0xFF) {
            case 1: {
                return _512;
            }
            case 2: {
                return _1024;
            }
            case 3: {
                return _2048;
            }
            case 4: {
                return _4096;
            }
        }
        throw new IllegalArgumentException();
    }

    static Object[] getTrustedCA(Extension ex) {
        byte[] buf = ex.getValue();
        int type = buf[0] & 0xFF;
        try {
            switch (type) {
                case 0: {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = new Integer(type);
                    return objectArray;
                }
                case 1: 
                case 3: {
                    return new Object[]{new Integer(type), Util.trim(buf, 1, 20)};
                }
                case 2: {
                    return new Object[]{new Integer(type), Util.trim(buf, 1, 20)};
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException();
    }

    static String getSRPUsername(Extension ex) {
        int len = ex.getValue()[0] & 0xFF;
        if (len > ex.getValue().length - 1) {
            throw new IllegalArgumentException();
        }
        try {
            return new String(ex.getValue(), 1, len, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error(uee.toString());
        }
    }
}

