/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.Enumerated;
import btworks.jsse.provider.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final class Extension
implements Constructed {
    private final Type type;
    private final byte[] value;

    Extension(Type type, byte[] value) {
        if (type == null || value == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.value = value;
    }

    static Extension read(InputStream in) throws IOException {
        Type t = Type.read(in);
        int len = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        byte[] v = new byte[len];
        int count = 0;
        while (count < len) {
            int l = in.read(v, count, len - count);
            if (l == -1) {
                throw new EOFException("unexpected end of extension");
            }
            count += l;
        }
        return new Extension(t, v);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.type.getEncoded());
        out.write(this.value.length >>> 8 & 0xFF);
        out.write(this.value.length & 0xFF);
        out.write(this.value);
    }

    Type getType() {
        return this.type;
    }

    byte[] getValue() {
        return this.value;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  type = " + this.type + ";");
        out.println("  value =");
        out.println(Util.hexDump(this.value, "    "));
        out.println("} Extension;");
        return str.toString();
    }

    static final class Type
    implements Enumerated {
        static final Type SERVER_NAME = new Type(0);
        static final Type MAX_FRAGMENT_LENGTH = new Type(1);
        static final Type CLIENT_CERTIFICATE_URL = new Type(2);
        static final Type TRUSTED_CA_KEYS = new Type(3);
        static final Type TRUNCATED_HMAC = new Type(4);
        static final Type STATUS_REQUEST = new Type(5);
        static final Type SRP = new Type(6);
        static final Type CERT_TYPE = new Type(7);
        private final int value;

        private Type(int value) {
            this.value = value;
        }

        static Type read(InputStream in) throws IOException {
            int i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            int value = (i & 0xFF) << 8;
            i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (value |= i & 0xFF) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return SRP;
                }
                case 7: {
                    return CERT_TYPE;
                }
            }
            return new Type(value);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)(this.value >>> 8 & 0xFF), (byte)(this.value & 0xFF)};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "server_name";
                }
                case 1: {
                    return "max_fragment_length";
                }
                case 2: {
                    return "client_certificate_url";
                }
                case 3: {
                    return "trusted_ca_keys";
                }
                case 4: {
                    return "truncated_hmac";
                }
                case 5: {
                    return "status_request";
                }
                case 6: {
                    return "srp";
                }
                case 7: {
                    return "cert_type";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }
}

