/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.BtwMessageDigest;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

final class DigestOutputStream
extends FilterOutputStream {
    private BtwMessageDigest md5;
    private BtwMessageDigest sha;
    private boolean digesting;

    DigestOutputStream(OutputStream out, BtwMessageDigest md5, BtwMessageDigest sha) {
        super(out);
        this.md5 = md5;
        this.sha = sha;
        this.digesting = true;
    }

    void setDigesting(boolean digesting) {
        this.digesting = digesting;
    }

    public void write(int b) throws IOException {
        if (this.digesting) {
            this.md5.update((byte)b);
            this.sha.update((byte)b);
        }
        this.out.write(b);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.digesting) {
            this.md5.update(buf, off, len);
            this.sha.update(buf, off, len);
        }
        this.out.write(buf, off, len);
    }
}

