/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.BtwMessageDigest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class DigestInputStream
extends FilterInputStream {
    private BtwMessageDigest md5;
    private BtwMessageDigest sha;
    private boolean digesting;

    DigestInputStream(InputStream in, BtwMessageDigest md5, BtwMessageDigest sha) {
        super(in);
        if (md5 == null || sha == null) {
            throw new NullPointerException();
        }
        this.md5 = md5;
        this.sha = sha;
        this.digesting = true;
    }

    void setDigesting(boolean digesting) {
        this.digesting = digesting;
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (this.digesting && i != -1) {
            this.md5.update((byte)i);
            this.sha.update((byte)i);
        }
        return i;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        if (this.digesting && ret != -1) {
            this.md5.update(buf, off, ret);
            this.sha.update(buf, off, ret);
        }
        return ret;
    }
}

