/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class ContentType
implements Enumerated {
    static final ContentType CLIENT_HELLO_V2 = new ContentType(1);
    static final ContentType CHANGE_CIPHER_SPEC = new ContentType(20);
    static final ContentType ALERT = new ContentType(21);
    static final ContentType HANDSHAKE = new ContentType(22);
    static final ContentType APPLICATION_DATA = new ContentType(23);
    private int value;

    private ContentType(int value) {
        this.value = value;
    }

    static final ContentType read(InputStream in) throws IOException {
        int value = in.read();
        if (value == -1) {
            throw new EOFException("unexpected end of input stream");
        }
        switch (value & 0xFF) {
            case 1: {
                return CLIENT_HELLO_V2;
            }
            case 20: {
                return CHANGE_CIPHER_SPEC;
            }
            case 21: {
                return ALERT;
            }
            case 22: {
                return HANDSHAKE;
            }
            case 23: {
                return APPLICATION_DATA;
            }
        }
        return new ContentType(value);
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.value};
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ContentType)) {
            return false;
        }
        return ((ContentType)o).value == this.value;
    }

    public int hashCode() {
        return this.getValue();
    }

    public String toString() {
        switch (this.value) {
            case 1: {
                return "v2_client_hello";
            }
            case 20: {
                return "change_cipher_spec";
            }
            case 21: {
                return "alert";
            }
            case 22: {
                return "handshake";
            }
            case 23: {
                return "application_data";
            }
        }
        return "unknown(" + this.value + ")";
    }
}

