/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class CompressionMethod
implements Enumerated {
    static final CompressionMethod NULL = new CompressionMethod(0);
    static final CompressionMethod ZLIB = new CompressionMethod(1);
    private final int value;

    private CompressionMethod(int value) {
        this.value = value;
    }

    static CompressionMethod read(InputStream in) throws IOException {
        int value = in.read();
        if (value == -1) {
            throw new EOFException("unexpected end of input stream");
        }
        switch (value & 0xFF) {
            case 0: {
                return NULL;
            }
            case 1: {
                return ZLIB;
            }
        }
        return new CompressionMethod(value);
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.value};
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "null";
            }
            case 1: {
                return "zlib";
            }
        }
        return "unknown(" + this.value + ")";
    }
}

