/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.CompressionMethod;
import btworks.jsse.provider.Extension;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Random;
import btworks.jsse.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class ClientHello
implements Handshake.Body {
    private ProtocolVersion version;
    private Random random;
    private byte[] sessionId;
    private List suites;
    private List comp;
    private List extensions;

    ClientHello(ProtocolVersion version, Random random, byte[] sessionId, List suites, List comp) {
        this(version, random, sessionId, suites, comp, null);
    }

    ClientHello(ProtocolVersion version, Random random, byte[] sessionId, List suites, List comp, List extensions) {
        this.version = version;
        this.random = random;
        this.sessionId = sessionId;
        this.suites = suites;
        this.comp = comp;
        this.extensions = extensions;
    }

    static ClientHello read(InputStream in) throws IOException {
        ProtocolVersion vers = ProtocolVersion.read(in);
        Random rand = Random.read(in);
        byte[] id = new byte[in.read() & 0xFF];
        in.read(id);
        int len = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>(len / 2);
        int i = 0;
        while (i < len) {
            suites.add(CipherSuite.read(in).resolve(vers));
            i += 2;
        }
        len = in.read() & 0xFF;
        ArrayList<CompressionMethod> comp = new ArrayList<CompressionMethod>(len);
        int i2 = 0;
        while (i2 < len) {
            comp.add(CompressionMethod.read(in));
            ++i2;
        }
        LinkedList<Extension> ext = null;
        if (in.available() > 0) {
            ext = new LinkedList<Extension>();
            len = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
            int count = 0;
            while (count < len) {
                Extension e = Extension.read(in);
                ext.add(e);
                count += e.getValue().length + 4;
            }
        }
        return new ClientHello(vers, rand, id, suites, comp, ext);
    }

    public void write(OutputStream out) throws IOException {
        this.version.write(out);
        this.random.write(out);
        out.write(this.sessionId.length);
        out.write(this.sessionId);
        out.write(this.suites.size() << 1 >>> 8 & 0xFF);
        out.write(this.suites.size() << 1 & 0xFF);
        Iterator i = this.suites.iterator();
        while (i.hasNext()) {
            ((CipherSuite)i.next()).write(out);
        }
        out.write(this.comp.size());
        i = this.comp.iterator();
        while (i.hasNext()) {
            out.write(((CompressionMethod)i.next()).getValue());
        }
        if (this.extensions != null) {
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            Iterator i2 = this.extensions.iterator();
            while (i2.hasNext()) {
                ((Extension)i2.next()).write(out2);
            }
            out.write(out2.size() >>> 8 & 0xFF);
            out.write(out2.size() & 0xFF);
            out2.writeTo(out);
        }
    }

    ProtocolVersion getVersion() {
        return this.version;
    }

    Random getRandom() {
        return this.random;
    }

    byte[] getSessionId() {
        return this.sessionId;
    }

    List getCipherSuites() {
        return this.suites;
    }

    List getCompressionMethods() {
        return this.comp;
    }

    List getExtensions() {
        return this.extensions;
    }

    public String toString() {
        String s;
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  version = " + this.version + ";");
        BufferedReader r = new BufferedReader(new StringReader(this.random.toString()));
        try {
            while ((s = r.readLine()) != null) {
                out.print("  ");
                out.println(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.println("  sessionId = " + Util.toHexString(this.sessionId, ':') + ";");
        out.println("  cipherSuites = {");
        Iterator i = this.suites.iterator();
        while (i.hasNext()) {
            out.print("    ");
            out.println(i.next());
        }
        out.println("  };");
        out.print("  compressionMethods = { ");
        i = this.comp.iterator();
        while (i.hasNext()) {
            out.print(i.next());
            if (!i.hasNext()) continue;
            out.print(", ");
        }
        out.println(" };");
        if (this.extensions != null) {
            out.println("  extensions = {");
            i = this.extensions.iterator();
            while (i.hasNext()) {
                r = new BufferedReader(new StringReader(i.next().toString()));
                try {
                    while ((s = r.readLine()) != null) {
                        out.print("    ");
                        out.println(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            out.println("  };");
        }
        out.println("} ClientHello;");
        return str.toString();
    }
}

