/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.cipher.AESacc;
import btworks.crypto.cipher.Acc;
import btworks.crypto.cipher.DESacc2;
import btworks.crypto.cipher.SEEDacc;
import btworks.crypto.cipher.TripleDES;
import btworks.crypto.mac.BtwMac;
import btworks.crypto.mac.MacFactory;
import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.SSLHMac;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

final class CipherSuite
implements Constructed {
    private static final List tlsSuiteNames = new LinkedList();
    private static final HashMap namesToSuites = new HashMap();
    static final CipherSuite TLS_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "HMAC-SHA", 8, 0, 9, "TLS_RSA_WITH_DES_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_SEED_CBC_SHA = new CipherSuite("SEED", "RSA", "RSA", "HMAC-SHA", 16, 0, 150, "TLS_RSA_WITH_SEED_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "HMAC-SHA", 16, 0, 47, "TLS_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "HMAC-SHA", 16, 0, 53, "TLS_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite SSL_NULL_WITH_NULL_NULL = new CipherSuite("null", "null", "null", "null", 0, 0, 0, "SSL_NULL_WITH_NULL_NULL", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_NULL_MD5 = new CipherSuite("null", "RSA", "RSA", "SSLMAC-MD5", 0, 0, 1, "SSL_RSA_WITH_NULL_MD5", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_NULL_SHA = new CipherSuite("null", "RSA", "RSA", "SSLMAC-SHA", 0, 0, 2, "SSL_RSA_WITH_NULL_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "SSLMAC-SHA", 5, 0, 8, "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_DES_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "SSLMAC-SHA", 8, 0, 9, "SSL_RSA_WITH_DES_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "RSA", "RSA", "SSLMAC-SHA", 24, 0, 10, "SSL_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_128_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "SSLMAC-SHA", 16, 0, 47, "SSL_RSA_WITH_AES_128_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite SSL_RSA_WITH_AES_256_CBC_SHA = new CipherSuite("AES", "RSA", "RSA", "SSLMAC-SHA", 32, 0, 53, "SSL_RSA_WITH_AES_256_CBC_SHA", ProtocolVersion.SSL_3);
    static final CipherSuite TLS_NULL_WITH_NULL_NULL = new CipherSuite("null", "null", "null", "null", 8, 0, 0, "TLS_NULL_WITH_NULL_NULL", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_NULL_MD5 = new CipherSuite("null", "RSA", "RSA", "HMAC-MD5", 8, 0, 1, "TLS_RSA_WITH_NULL_MD5", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_NULL_SHA = new CipherSuite("null", "RSA", "RSA", "HMAC-SHA", 8, 0, 2, "TLS_RSA_WITH_NULL_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = new CipherSuite("DES", "RSA", "RSA", "HMAC-SHA", 5, 0, 8, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", ProtocolVersion.TLS_1);
    static final CipherSuite TLS_RSA_WITH_3DES_EDE_CBC_SHA = new CipherSuite("TripleDES", "RSA", "RSA", "HMAC-SHA", 24, 0, 10, "TLS_RSA_WITH_3DES_EDE_CBC_SHA", ProtocolVersion.TLS_1);
    private final String cipherName;
    private final String kexName;
    private final String sigName;
    private final String macName;
    private final boolean exportable;
    private final boolean isStream;
    private final int keyLength;
    private final byte[] id;
    private final String name;
    private final ProtocolVersion version;

    private CipherSuite(String cipherName, String kexName, String sigName, String macName, int keyLength, int id1, int id2, String name, ProtocolVersion version) {
        this.cipherName = cipherName.intern();
        this.kexName = kexName.intern();
        this.sigName = sigName.intern();
        this.macName = macName.intern();
        this.exportable = keyLength <= 5;
        this.isStream = cipherName.equals("null") || cipherName.equals("RC4");
        this.keyLength = keyLength;
        this.id = new byte[]{(byte)id1, (byte)id2};
        this.name = name.intern();
        this.version = version;
        namesToSuites.put(name, this);
        if (name.startsWith("TLS") || name.startsWith("SSL")) {
            tlsSuiteNames.add(name);
        }
    }

    private CipherSuite(byte[] id) {
        this.cipherName = null;
        this.kexName = null;
        this.sigName = null;
        this.macName = null;
        this.exportable = false;
        this.isStream = false;
        this.keyLength = 0;
        this.id = id;
        this.name = null;
        this.version = null;
    }

    static CipherSuite forName(String name) {
        return (CipherSuite)namesToSuites.get(name);
    }

    static List availableSuiteNames() {
        return tlsSuiteNames;
    }

    static CipherSuite read(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        byte[] id = new byte[2];
        din.readFully(id);
        return new CipherSuite(id);
    }

    static Acc getCipher(String cbcCipherName) {
        Acc cipher = null;
        if (cbcCipherName.equals("DES")) {
            cipher = new DESacc2();
        } else if (cbcCipherName.equals("SEED")) {
            cipher = new SEEDacc();
        } else if (cbcCipherName.equals("TripleDES")) {
            cipher = new TripleDES();
        } else if (cbcCipherName.equals("AES")) {
            cipher = new AESacc();
        }
        return cipher;
    }

    static BtwMac getMac(String macName) {
        if (macName.startsWith("SSLMAC-")) {
            return new SSLHMac(macName.substring(7));
        }
        return MacFactory.getInstance(macName);
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.id);
    }

    CipherSuite resolve(ProtocolVersion version) {
        if (version == ProtocolVersion.SSL_3) {
            if (this.id[0] == 0) {
                switch (this.id[1]) {
                    case 0: {
                        return SSL_NULL_WITH_NULL_NULL;
                    }
                    case 1: {
                        return SSL_RSA_WITH_NULL_MD5;
                    }
                    case 2: {
                        return SSL_RSA_WITH_NULL_SHA;
                    }
                    case 8: {
                        return SSL_RSA_EXPORT_WITH_DES40_CBC_SHA;
                    }
                    case 9: {
                        return SSL_RSA_WITH_DES_CBC_SHA;
                    }
                    case 10: {
                        return SSL_RSA_WITH_3DES_EDE_CBC_SHA;
                    }
                    case 47: {
                        return SSL_RSA_WITH_AES_128_CBC_SHA;
                    }
                    case 53: {
                        return SSL_RSA_WITH_AES_256_CBC_SHA;
                    }
                }
            }
        } else if ((version == ProtocolVersion.TLS_1 || version == ProtocolVersion.TLS_1_1) && this.id[0] == 0) {
            switch (this.id[1]) {
                case 0: {
                    return TLS_NULL_WITH_NULL_NULL;
                }
                case 1: {
                    return TLS_RSA_WITH_NULL_MD5;
                }
                case 2: {
                    return TLS_RSA_WITH_NULL_SHA;
                }
                case 8: {
                    return TLS_RSA_EXPORT_WITH_DES40_CBC_SHA;
                }
                case 9: {
                    return TLS_RSA_WITH_DES_CBC_SHA;
                }
                case 10: {
                    return TLS_RSA_WITH_3DES_EDE_CBC_SHA;
                }
                case -106: {
                    return TLS_RSA_WITH_SEED_CBC_SHA;
                }
                case 47: {
                    return TLS_RSA_WITH_AES_128_CBC_SHA;
                }
                case 53: {
                    return TLS_RSA_WITH_AES_256_CBC_SHA;
                }
            }
        }
        return this;
    }

    String getCipher() {
        return this.cipherName;
    }

    int getKeyLength() {
        return this.keyLength;
    }

    String getKeyExchange() {
        return this.kexName;
    }

    String getSignature() {
        return this.sigName;
    }

    String getMac() {
        return this.macName;
    }

    boolean isExportable() {
        return this.exportable;
    }

    boolean isStreamCipher() {
        return this.isStream;
    }

    String getAuthType() {
        if (this.kexName.equals("RSA")) {
            if (this.isExportable()) {
                return "RSA_EXPORT";
            }
            return "RSA";
        }
        return String.valueOf(this.kexName) + "_" + this.sigName;
    }

    byte[] getId() {
        return this.id;
    }

    ProtocolVersion getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CipherSuite)) {
            return false;
        }
        if (((CipherSuite)o).getVersion() != this.getVersion()) {
            return false;
        }
        return this.id[0] == ((CipherSuite)o).id[0] && this.id[1] == ((CipherSuite)o).id[1];
    }

    public int hashCode() {
        if (this.version == null) {
            return 0xFFFF0000 | (this.id[0] & 0xFF) << 8 | this.id[1] & 0xFF;
        }
        return this.version.getMajor() << 24 | this.version.getMinor() << 16 | (this.id[0] & 0xFF) << 8 | this.id[1] & 0xFF;
    }

    public String toString() {
        if (this.name == null) {
            return "UNKNOWN { " + (this.id[0] & 0xFF) + ", " + (this.id[1] & 0xFF) + " }";
        }
        return this.name;
    }
}

