/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class CertificateType
implements Enumerated {
    static final CertificateType X509 = new CertificateType(0);
    static final CertificateType OPEN_PGP = new CertificateType(1);
    private final int value;

    private CertificateType(int value) {
        this.value = value;
    }

    static CertificateType read(InputStream in) throws IOException {
        int value = in.read();
        if (value == -1) {
            throw new EOFException("unexpected end of input stream");
        }
        switch (value & 0xFF) {
            case 0: {
                return X509;
            }
            case 1: {
                return OPEN_PGP;
            }
        }
        return new CertificateType(value);
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.value};
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "X.509";
            }
            case 1: {
                return "OpenPGP";
            }
        }
        return "unknown(" + this.value + ")";
    }
}

