/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CertificateType;
import btworks.jsse.provider.Handshake;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.SSLProtocolException;

final class Certificate
implements Handshake.Body {
    private final X509Certificate[] certs;

    Certificate(X509Certificate[] certs) {
        if (certs == null) {
            throw new NullPointerException();
        }
        this.certs = certs;
    }

    static Certificate read(InputStream in, CertificateType type) throws IOException {
        if (type == CertificateType.X509) {
            int len = (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
            byte[] buf = new byte[len];
            int count = 0;
            while (count < len) {
                int l = in.read(buf, count, len - count);
                if (l == -1) {
                    throw new EOFException("unexpected end of stream");
                }
                count += l;
            }
            try {
                LinkedList<java.security.cert.Certificate> certs = new LinkedList<java.security.cert.Certificate>();
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream bin = new ByteArrayInputStream(buf);
                count = 0;
                while (count < len) {
                    int len2 = (bin.read() & 0xFF) << 16 | (bin.read() & 0xFF) << 8 | bin.read() & 0xFF;
                    certs.add(fact.generateCertificate(bin));
                    count += len2 + 3;
                }
                return new Certificate(certs.toArray(new X509Certificate[certs.size()]));
            }
            catch (CertificateException ce) {
                ce.printStackTrace();
                throw new SSLProtocolException(ce.getMessage());
            }
        }
        if (type == CertificateType.OPEN_PGP) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new Error("unsupported certificate type " + type);
    }

    public void write(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < this.certs.length) {
                byte[] enc = this.certs[i].getEncoded();
                bout.write(enc.length >>> 16 & 0xFF);
                bout.write(enc.length >>> 8 & 0xFF);
                bout.write(enc.length & 0xFF);
                bout.write(enc);
                ++i;
            }
        }
        catch (CertificateEncodingException cee) {
            throw new Error("cannot encode certificates");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.write(bout.size() >>> 16 & 0xFF);
        out.write(bout.size() >>> 8 & 0xFF);
        out.write(bout.size() & 0xFF);
        bout.writeTo(out);
    }

    X509Certificate[] getCertificates() {
        return this.certs;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  certificateList =");
        int i = 0;
        while (i < this.certs.length) {
            BufferedReader r = new BufferedReader(new StringReader(this.certs[i].toString()));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    out.print("    ");
                    out.println(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        out.println("} Certificate;");
        return str.toString();
    }
}

