/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class Alert
implements Constructed {
    private final Level level;
    private final Description description;

    Alert(Level level, Description description) {
        this.level = level;
        this.description = description;
    }

    static Alert read(InputStream in) throws IOException {
        Level level = Level.read(in);
        Description desc = Description.read(in);
        return new Alert(level, desc);
    }

    static Alert forName(String name) {
        if (name == null) {
            return new Alert(Level.FATAL, Description.INTERNAL_ERROR);
        }
        Description desc = Description.INTERNAL_ERROR;
        if (name.equals("close_notify")) {
            desc = Description.CLOSE_NOTIFY;
        } else if (name.equals("unexpected_message")) {
            desc = Description.UNEXPECTED_MESSAGE;
        } else if (name.equals("bad_record_mac")) {
            desc = Description.BAD_RECORD_MAC;
        } else if (name.equals("DECRYPTION_FAILED")) {
            desc = Description.DECRYPTION_FAILED;
        } else if (name.equals("record_overflow")) {
            desc = Description.RECORD_OVERFLOW;
        } else if (name.equals("decompression_failure")) {
            desc = Description.DECOMPRESSION_FAILURE;
        } else if (name.equals("handshake_failure")) {
            desc = Description.HANDSHAKE_FAILURE;
        } else if (name.equals("no_certificate")) {
            desc = Description.NO_CERTIFICATE;
        } else if (name.equals("bad_certificate")) {
            desc = Description.BAD_CERTIFICATE;
        } else if (name.equals("unsupported_certificate")) {
            desc = Description.UNSUPPORTED_CERTIFICATE;
        } else if (name.equals("certificate_revoked")) {
            desc = Description.CERTIFICATE_REVOKED;
        } else if (name.equals("certificate_expired")) {
            desc = Description.CERTIFICATE_EXPIRED;
        } else if (name.equals("certificate_unknown")) {
            desc = Description.CERTIFICATE_UNKNOWN;
        } else if (name.equals("illegal_parameter")) {
            desc = Description.ILLEGAL_PARAMETER;
        } else if (name.equals("unknown_ca")) {
            desc = Description.UNKNOWN_CA;
        } else if (name.equals("access_denied")) {
            desc = Description.ACCESS_DENIED;
        } else if (name.equals("decode_error")) {
            desc = Description.DECODE_ERROR;
        } else if (name.equals("decrypt_error")) {
            desc = Description.DECRYPT_ERROR;
        } else if (name.equals("export_restriction")) {
            desc = Description.EXPORT_RESTRICTION;
        } else if (name.equals("protocol_version")) {
            desc = Description.PROTOCOL_VERSION;
        } else if (name.equals("insufficient_security")) {
            desc = Description.INSUFFICIENT_SECURITY;
        } else if (name.equals("internal_error")) {
            desc = Description.INTERNAL_ERROR;
        } else if (name.equals("user_canceled")) {
            desc = Description.USER_CANCELED;
        } else if (name.equals("no_renegotiation")) {
            desc = Description.NO_RENEGOTIATION;
        } else if (name.equals("unsupported_extension")) {
            desc = Description.UNSUPPORTED_EXTENSION;
        } else if (name.equals("certificate_unobtainable")) {
            desc = Description.CERTIFICATE_UNOBTAINABLE;
        } else if (name.equals("unrecognized_name")) {
            desc = Description.UNRECOGNIZED_NAME;
        } else if (name.equals("bad_certificate_status_response")) {
            desc = Description.BAD_CERTIFICATE_STATUS_RESPONSE;
        } else if (name.equals("bad_certificate_hash_value")) {
            desc = Description.BAD_CERTIFICATE_HASH_VALUE;
        } else if (name.equals("unknown_srp_username")) {
            desc = Description.UNKNOWN_SRP_USERNAME;
        } else if (name.equals("missing_srp_username")) {
            desc = Description.MISSING_SRP_USERNAME;
        }
        return new Alert(Level.FATAL, desc);
    }

    public void write(OutputStream out) throws IOException {
        out.write((byte)this.level.getValue());
        out.write((byte)this.description.getValue());
    }

    byte[] getEncoded() {
        return new byte[]{(byte)this.level.getValue(), (byte)this.description.getValue()};
    }

    Level getLevel() {
        return this.level;
    }

    Description getDescription() {
        return this.description;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        return "struct {" + nl + "  level = " + this.level + ";" + nl + "  description = " + this.description + ";" + nl + "} Alert;" + nl;
    }

    static final class Description
    implements Enumerated {
        static final Description CLOSE_NOTIFY = new Description(0);
        static final Description UNEXPECTED_MESSAGE = new Description(10);
        static final Description BAD_RECORD_MAC = new Description(20);
        static final Description DECRYPTION_FAILED = new Description(21);
        static final Description RECORD_OVERFLOW = new Description(22);
        static final Description DECOMPRESSION_FAILURE = new Description(30);
        static final Description HANDSHAKE_FAILURE = new Description(40);
        static final Description NO_CERTIFICATE = new Description(41);
        static final Description BAD_CERTIFICATE = new Description(42);
        static final Description UNSUPPORTED_CERTIFICATE = new Description(43);
        static final Description CERTIFICATE_REVOKED = new Description(44);
        static final Description CERTIFICATE_EXPIRED = new Description(45);
        static final Description CERTIFICATE_UNKNOWN = new Description(46);
        static final Description ILLEGAL_PARAMETER = new Description(47);
        static final Description UNKNOWN_CA = new Description(48);
        static final Description ACCESS_DENIED = new Description(49);
        static final Description DECODE_ERROR = new Description(50);
        static final Description DECRYPT_ERROR = new Description(51);
        static final Description EXPORT_RESTRICTION = new Description(60);
        static final Description PROTOCOL_VERSION = new Description(70);
        static final Description INSUFFICIENT_SECURITY = new Description(71);
        static final Description INTERNAL_ERROR = new Description(80);
        static final Description USER_CANCELED = new Description(90);
        static final Description NO_RENEGOTIATION = new Description(100);
        static final Description UNSUPPORTED_EXTENSION = new Description(110);
        static final Description CERTIFICATE_UNOBTAINABLE = new Description(111);
        static final Description UNRECOGNIZED_NAME = new Description(112);
        static final Description BAD_CERTIFICATE_STATUS_RESPONSE = new Description(113);
        static final Description BAD_CERTIFICATE_HASH_VALUE = new Description(114);
        static final Description UNKNOWN_SRP_USERNAME = new Description(120);
        static final Description MISSING_SRP_USERNAME = new Description(121);
        private final int value;

        private Description(int value) {
            this.value = value;
        }

        static Description read(InputStream in) throws IOException {
            int i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (i) {
                case 0: {
                    return CLOSE_NOTIFY;
                }
                case 10: {
                    return UNEXPECTED_MESSAGE;
                }
                case 20: {
                    return BAD_RECORD_MAC;
                }
                case 21: {
                    return DECRYPTION_FAILED;
                }
                case 22: {
                    return RECORD_OVERFLOW;
                }
                case 30: {
                    return DECOMPRESSION_FAILURE;
                }
                case 40: {
                    return HANDSHAKE_FAILURE;
                }
                case 41: {
                    return NO_CERTIFICATE;
                }
                case 42: {
                    return BAD_CERTIFICATE;
                }
                case 43: {
                    return UNSUPPORTED_CERTIFICATE;
                }
                case 44: {
                    return CERTIFICATE_REVOKED;
                }
                case 45: {
                    return CERTIFICATE_EXPIRED;
                }
                case 46: {
                    return CERTIFICATE_UNKNOWN;
                }
                case 47: {
                    return ILLEGAL_PARAMETER;
                }
                case 48: {
                    return UNKNOWN_CA;
                }
                case 49: {
                    return ACCESS_DENIED;
                }
                case 50: {
                    return DECODE_ERROR;
                }
                case 51: {
                    return DECRYPT_ERROR;
                }
                case 60: {
                    return EXPORT_RESTRICTION;
                }
                case 70: {
                    return PROTOCOL_VERSION;
                }
                case 71: {
                    return INSUFFICIENT_SECURITY;
                }
                case 80: {
                    return INTERNAL_ERROR;
                }
                case 90: {
                    return USER_CANCELED;
                }
                case 100: {
                    return NO_RENEGOTIATION;
                }
                case 120: {
                    return UNKNOWN_SRP_USERNAME;
                }
                case 121: {
                    return MISSING_SRP_USERNAME;
                }
            }
            return new Description(i);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "close_notify";
                }
                case 10: {
                    return "unexpected_message";
                }
                case 20: {
                    return "bad_record_mac";
                }
                case 21: {
                    return "decryption_failed";
                }
                case 22: {
                    return "record_overflow";
                }
                case 30: {
                    return "decompression_failure";
                }
                case 40: {
                    return "handshake_failure";
                }
                case 42: {
                    return "bad_certificate";
                }
                case 43: {
                    return "unsupported_certificate";
                }
                case 44: {
                    return "certificate_revoked";
                }
                case 45: {
                    return "certificate_expired";
                }
                case 46: {
                    return "certificate_unknown";
                }
                case 47: {
                    return "illegal_parameter";
                }
                case 48: {
                    return "unknown_ca";
                }
                case 49: {
                    return "access_denied";
                }
                case 50: {
                    return "decode_error";
                }
                case 51: {
                    return "decrypt_error";
                }
                case 60: {
                    return "export_restriction";
                }
                case 70: {
                    return "protocol_version";
                }
                case 71: {
                    return "insufficient_security";
                }
                case 80: {
                    return "internal_error";
                }
                case 90: {
                    return "user_canceled";
                }
                case 100: {
                    return "no_renegotiation";
                }
                case 110: {
                    return "unsupported_extension";
                }
                case 111: {
                    return "certificate_unobtainable";
                }
                case 112: {
                    return "unrecognized_name";
                }
                case 113: {
                    return "bad_certificate_status_response";
                }
                case 114: {
                    return "bad_certificate_hash_value";
                }
                case 120: {
                    return "unknown_srp_username";
                }
                case 121: {
                    return "missing_srp_username";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }

    static final class Level
    implements Enumerated {
        static final Level WARNING = new Level(1);
        static final Level FATAL = new Level(2);
        private final int value;

        private Level(int value) {
            this.value = value;
        }

        static Level read(InputStream in) throws IOException {
            int i = in.read();
            if (i == -1) {
                throw new EOFException("unexpected end of stream");
            }
            switch (i & 0xFF) {
                case 1: {
                    return WARNING;
                }
                case 2: {
                    return FATAL;
                }
            }
            return new Level(i);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 1: {
                    return "warning";
                }
                case 2: {
                    return "fatal";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }
}

