/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class Base64 {
    private static final String BASE_64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char BASE_64_PAD = '=';

    private Base64() {
    }

    public static String encode(byte[] buf, int tw) {
        int srcLength = buf.length;
        byte[] input = new byte[3];
        int[] output = new int[4];
        StringBuffer out = new StringBuffer();
        int i = 0;
        int chars = 0;
        while (srcLength > 2) {
            input[0] = buf[i++];
            input[1] = buf[i++];
            input[2] = buf[i++];
            srcLength -= 3;
            output[0] = (input[0] & 0xFF) >>> 2;
            output[1] = ((input[0] & 3) << 4) + ((input[1] & 0xFF) >>> 4);
            output[2] = ((input[1] & 0xF) << 2) + ((input[2] & 0xFF) >>> 6);
            output[3] = input[2] & 0x3F;
            out.append(BASE_64.charAt(output[0]));
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            out.append(BASE_64.charAt(output[1]));
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            out.append(BASE_64.charAt(output[2]));
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            out.append(BASE_64.charAt(output[3]));
            if (tw <= 0 || ++chars % tw != 0) continue;
            out.append("\n");
        }
        if (srcLength != 0) {
            input[2] = 0;
            input[1] = 0;
            input[0] = 0;
            int j = 0;
            while (j < srcLength) {
                input[j] = buf[i + j];
                ++j;
            }
            output[0] = (input[0] & 0xFF) >>> 2;
            output[1] = ((input[0] & 3) << 4) + ((input[1] & 0xFF) >>> 4);
            output[2] = ((input[1] & 0xF) << 2) + ((input[2] & 0xFF) >>> 6);
            out.append(BASE_64.charAt(output[0]));
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            out.append(BASE_64.charAt(output[1]));
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            if (srcLength == 1) {
                out.append('=');
            } else {
                out.append(BASE_64.charAt(output[2]));
            }
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
            out.append('=');
            if (tw > 0 && ++chars % tw == 0) {
                out.append("\n");
            }
        }
        if (tw > 0) {
            out.append("\n");
        }
        return out.toString();
    }

    public static byte[] decode(String b64) throws IOException {
        ByteArrayOutputStream result;
        block20: {
            int state;
            block19: {
                result = new ByteArrayOutputStream(b64.length() / 3);
                state = 0;
                byte temp = 0;
                int i = 0;
                while (i < b64.length()) {
                    if (!Character.isWhitespace(b64.charAt(i))) {
                        if (b64.charAt(i) == '=') break;
                        int pos = BASE_64.indexOf(b64.charAt(i));
                        if (pos < 0) {
                            throw new IOException("non-Base64 character " + b64.charAt(i));
                        }
                        switch (state) {
                            case 0: {
                                temp = (byte)(pos - BASE_64.indexOf(65) << 2);
                                state = 1;
                                break;
                            }
                            case 1: {
                                temp = (byte)(temp | (byte)(pos - BASE_64.indexOf(65) >>> 4));
                                result.write(temp);
                                temp = (byte)((pos - BASE_64.indexOf(65) & 0xF) << 4);
                                state = 2;
                                break;
                            }
                            case 2: {
                                temp = (byte)(temp | (byte)((pos - BASE_64.indexOf(65) & 0x7F) >>> 2));
                                result.write(temp);
                                temp = (byte)((pos - BASE_64.indexOf(65) & 3) << 6);
                                state = 3;
                                break;
                            }
                            case 3: {
                                temp = (byte)(temp | (byte)(pos - BASE_64.indexOf(65) & 0xFF));
                                result.write(temp);
                                state = 0;
                                break;
                            }
                            default: {
                                throw new Error("this statement should be unreachable");
                            }
                        }
                    }
                    ++i;
                }
                if (i >= b64.length() || b64.charAt(i) != '=') break block19;
                switch (state) {
                    case 0: 
                    case 1: {
                        throw new IOException("malformed Base64 sequence");
                    }
                    case 2: {
                        while (i < b64.length()) {
                            if (!Character.isWhitespace(b64.charAt(i))) break;
                            ++i;
                        }
                        if (b64.charAt(i) != '=') {
                            throw new IOException("malformed Base64 sequence");
                        }
                        ++i;
                    }
                    case 3: {
                        ++i;
                        while (i < b64.length()) {
                            if (!Character.isWhitespace(b64.charAt(i))) {
                                System.err.println(b64.charAt(i));
                                throw new IOException("malformed Base64 sequence");
                            }
                            ++i;
                        }
                        break block6;
                    }
                }
                break block20;
            }
            if (state != 0) {
                throw new IOException("malformed Base64 sequence");
            }
        }
        return result.toByteArray();
    }
}

