/*
 * Decompiled with CFR 0.152.
 */
package btworks.crypto.sig.jca;

import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.sig.rsa.RSA;
import btworks.jsse.provider.RSAPrivateKeyImpl;
import btworks.jsse.provider.RSAPublicKeyImpl;
import btworks.jsse.provider.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public abstract class RSASignature_PKCS1
extends SignatureSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private RSAPublicKey pubkey;
    private RSAPrivateKey privkey;
    private final BtwMessageDigest md;

    RSASignature_PKCS1(String mdAlgorithm) {
        try {
            this.md = HashFactory.getInstance(mdAlgorithm);
        }
        catch (Exception e) {
            throw new InternalError("Unable to instantiate messagedigest:" + mdAlgorithm);
        }
    }

    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        try {
            if (!(key instanceof RSAPublicKey)) {
                key = new RSAPublicKeyImpl(key);
            }
            this.pubkey = (RSAPublicKey)key;
            this.n = this.pubkey.getModulus();
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
        this.initCommon();
    }

    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        try {
            if (!(key instanceof RSAPrivateKey)) {
                key = new RSAPrivateKeyImpl(key);
            }
            this.privkey = (RSAPrivateKey)key;
            this.n = this.privkey.getModulus();
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
        this.initCommon();
    }

    private void initCommon() throws InvalidKeyException {
        this.md.reset();
        int mdl = this.md.digest().length;
        int length = this.modulusByteLength();
        int aidl = this.getAlgorithmEncoding().length;
        int padLen = length - 3 - aidl - mdl;
        if (padLen < 0) {
            throw new InvalidKeyException("Signer's key modulus too short.");
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.md.update(b);
    }

    protected void engineUpdate(byte[] in, int offset, int length) throws SignatureException {
        this.md.update(in, offset, length);
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger pkcs = this.makePKCS1();
        BigInteger EM = RSA.sign(this.privkey, pkcs);
        return Util.trim(EM);
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        int sigLen = this.pubkey.getModulus().toByteArray().length;
        BigInteger M = null;
        if (signature.length > sigLen) {
            byte[] sigTemp = new byte[--sigLen];
            System.arraycopy(signature, 0, sigTemp, 0, sigLen);
            M = new BigInteger(1, sigTemp);
        } else {
            M = new BigInteger(1, signature);
        }
        byte[] _actualDigest = this.md.digest();
        int mdl = _actualDigest.length;
        byte[] _computedDigest = null;
        try {
            BigInteger computed = RSA.verify(this.pubkey, M);
            byte[] _computed = computed.toByteArray();
            _computedDigest = Util.trim(_computed, _computed.length - mdl, mdl);
        }
        catch (Exception e) {
            throw new SignatureException(e.getMessage());
        }
        return Arrays.equals(_computedDigest, _actualDigest);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not accept parameters.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This algorithm does not accept AlgorithmParameterSpec.");
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not have parameters.");
    }

    private BigInteger makePKCS1() throws SignatureException {
        byte[] theMD = this.md.digest();
        int mdl = theMD.length;
        int length = this.modulusByteLength();
        byte[] r = new byte[length];
        r[1] = 1;
        byte[] aid = this.getAlgorithmEncoding();
        int aidl = aid.length;
        int padLen = length - 3 - aidl - mdl;
        if (padLen < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int i = 0;
        while (i < padLen) {
            r[2 + i++] = -1;
        }
        System.arraycopy(aid, 0, r, padLen + 3, aidl);
        System.arraycopy(theMD, 0, r, length - mdl, mdl);
        return new BigInteger(r);
    }

    private int modulusByteLength() {
        return (this.n.bitLength() + 7) / 8;
    }

    protected abstract byte[] getAlgorithmEncoding();
}

