/*
 * Decompiled with CFR 0.152.
 */
package btworks.crypto.mac;

import btworks.crypto.Registry;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.mac.BtwMac;
import btworks.crypto.mac.HMac;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HMacFactory
implements Registry {
    private HMacFactory() {
    }

    public static BtwMac getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        if (!(name = name.toLowerCase()).startsWith("hmac-")) {
            return null;
        }
        HMac result = new HMac(HashFactory.getInstance(name = name.substring("hmac-".length()).trim()));
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        Set hashNames = HashFactory.getNames();
        HashSet<String> hs = new HashSet<String>();
        Iterator it = hashNames.iterator();
        while (it.hasNext()) {
            hs.add("hmac-" + (String)it.next());
        }
        return Collections.unmodifiableSet(hs);
    }
}

